/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TanqueCombustivel;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="MEDICAO_TANQUE_COMB")
public class MedicaoTanqueCombustivel
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private TanqueCombustivel tanqueCombustivel;
    private Date dataMovimentacao;
    private Double quantidadeEstoqueAbertura = 0.0;
    private Double quantidadeEntradas = 0.0;
    private Double quantidadeSaidas = 0.0;
    private Double quantidaEstoqueEscriturado = 0.0;
    private Double quantidadePerda = 0.0;
    private Double quantidadeGanho = 0.0;
    private Double quantidadeFechamento = 0.0;

    @Id
    @Column(name="ID_MEDICAO_TANQUE_COMB", nullable=false)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MEDICAO_TANQUE_COMB")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MEDICAO_TANQUE_COMB_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TANQUE_COMBUSTIVEL", foreignKey=@ForeignKey(name="FK_MEDICAO_TANQUE_COMB_TANQUE"))
    public TanqueCombustivel getTanqueCombustivel() {
        return this.tanqueCombustivel;
    }

    public void setTanqueCombustivel(TanqueCombustivel tanqueCombustivel) {
        this.tanqueCombustivel = tanqueCombustivel;
    }

    @Column(nullable=false, name="DATA_MOVIMENTACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataMovimentacao() {
        return this.dataMovimentacao;
    }

    public void setDataMovimentacao(Date dataMovimentacao) {
        this.dataMovimentacao = dataMovimentacao;
    }

    @Column(name="QTDE_ESTOQUE_ABERTURA", precision=15, scale=3)
    public Double getQuantidadeEstoqueAbertura() {
        return this.quantidadeEstoqueAbertura;
    }

    public void setQuantidadeEstoqueAbertura(Double quantidadeEstoqueAbertura) {
        this.quantidadeEstoqueAbertura = quantidadeEstoqueAbertura;
    }

    @Column(name="QTDE_ENTRADAS", precision=15, scale=3)
    public Double getQuantidadeEntradas() {
        return this.quantidadeEntradas;
    }

    public void setQuantidadeEntradas(Double quantidadeEntradas) {
        this.quantidadeEntradas = quantidadeEntradas;
    }

    @Column(name="QTDE_SAIDAS", precision=15, scale=3)
    public Double getQuantidadeSaidas() {
        return this.quantidadeSaidas;
    }

    public void setQuantidadeSaidas(Double quantidadeSaidas) {
        this.quantidadeSaidas = quantidadeSaidas;
    }

    @Column(name="QTDE_ESTOQUE_ESCRITURADO", precision=15, scale=3)
    public Double getQuantidaEstoqueEscriturado() {
        return this.quantidaEstoqueEscriturado;
    }

    public void setQuantidaEstoqueEscriturado(Double quantidaEstoqueEscriturado) {
        this.quantidaEstoqueEscriturado = quantidaEstoqueEscriturado;
    }

    @Column(name="QTDE_PERDA", precision=15, scale=3)
    public Double getQuantidadePerda() {
        return this.quantidadePerda;
    }

    public void setQuantidadePerda(Double quantidadePerda) {
        this.quantidadePerda = quantidadePerda;
    }

    @Column(name="QTDE_GANHO", precision=15, scale=3)
    public Double getQuantidadeGanho() {
        return this.quantidadeGanho;
    }

    public void setQuantidadeGanho(Double quantidadeGanho) {
        this.quantidadeGanho = quantidadeGanho;
    }

    @Column(name="QTDE_FECHAMENTO", precision=15, scale=3)
    public Double getQuantidadeFechamento() {
        return this.quantidadeFechamento;
    }

    public void setQuantidadeFechamento(Double quantidadeFechamento) {
        this.quantidadeFechamento = quantidadeFechamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

