/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.tasks.EnumConstMentorTaskType;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.MentorTaskParameter;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="MENTOR_TASK")
public class MentorTask
implements InterfaceVO {
    private Long identificador;
    private String intervaloExecucao;
    private String taskClass;
    private String taskName;
    private List<MentorTaskParameter> paramConf = new ArrayList<MentorTaskParameter>();
    private Short ativo = 1;
    private Short enviarEmailStatus = 0;
    private ServidorEmail servidorEmail;
    private String tituloEmail;
    private String destinatarios;
    private Short habilitadaUsoCliente = 0;
    private Short tipoTask = EnumConstMentorTaskType.CLASSE.getValue();
    private SmartComponentPref smartComponentPref;
    private String observacao;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="ID_MENTOR_TASK")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="INTERVALO_EXECUCAO", length=1000)
    public String getIntervaloExecucao() {
        return this.intervaloExecucao;
    }

    public void setIntervaloExecucao(String interval) {
        this.intervaloExecucao = interval;
    }

    @Column(name="TASK_CLASS", length=500)
    public String getTaskClass() {
        return this.taskClass;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    @Column(name="TASK_NAME", length=500)
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="mentorTask", targetEntity=MentorTaskParameter.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @MapKey(name="nomeParametro")
    @Fetch(value=FetchMode.SELECT)
    public List<MentorTaskParameter> getParamConf() {
        return this.paramConf;
    }

    public void setParamConf(List<MentorTaskParameter> paramConf) {
        this.paramConf = paramConf;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getTaskName()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="ENVIAR_EMAIL_STATUS")
    public Short getEnviarEmailStatus() {
        return this.enviarEmailStatus;
    }

    public void setEnviarEmailStatus(Short enviarEmailStatus) {
        this.enviarEmailStatus = enviarEmailStatus;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVIDOR_EMAIL", foreignKey=@ForeignKey(name="FK_MENTOR_TASK_SERV_EMAIL"))
    public ServidorEmail getServidorEmail() {
        return this.servidorEmail;
    }

    public void setServidorEmail(ServidorEmail servidorEmail) {
        this.servidorEmail = servidorEmail;
    }

    @Column(name="TITULO_EMAIL", length=500)
    public String getTituloEmail() {
        return this.tituloEmail;
    }

    public void setTituloEmail(String tituloEmail) {
        this.tituloEmail = tituloEmail;
    }

    @Column(name="DESTINATARIOS", length=2000)
    public String getDestinatarios() {
        return this.destinatarios;
    }

    public void setDestinatarios(String destinatarios) {
        this.destinatarios = destinatarios;
    }

    @Column(name="HABILITADA_USO_CLIENTE")
    public Short getHabilitadaUsoCliente() {
        return this.habilitadaUsoCliente;
    }

    public void setHabilitadaUsoCliente(Short habilitadaUsoCliente) {
        this.habilitadaUsoCliente = habilitadaUsoCliente;
    }

    @Column(name="TIPO_TASK")
    public Short getTipoTask() {
        return this.tipoTask;
    }

    public void setTipoTask(Short tipoTask) {
        this.tipoTask = tipoTask;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SMART_COMPONENT_PREF")
    public SmartComponentPref getSmartComponentPref() {
        return this.smartComponentPref;
    }

    public void setSmartComponentPref(SmartComponentPref smartComponentPref) {
        this.smartComponentPref = smartComponentPref;
    }

    @Column(name="OBSERVACAO")
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

