/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IndiceEconomico;
import com.touchcomp.basementor.model.vo.IntervaloControleCont;
import com.touchcomp.basementor.model.vo.MetaControleContLinha;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="META_CONTROLE_CONTABIL")
public class MetaControleContabil
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private Empresa empresa;
    private List<MetaControleContLinha> metasLinhas = new ArrayList<MetaControleContLinha>();
    private IndiceEconomico indiceEconomico;
    private IntervaloControleCont intervaloControleCont;

    @Id
    @Column(nullable=false, name="ID_META_CONTROLE_CONTABIL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_META_CONTROLE_CONT")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_META_CONTROLE_CONT_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="metaControleContabil")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<MetaControleContLinha> getMetasLinhas() {
        return this.metasLinhas;
    }

    public void setMetasLinhas(List<MetaControleContLinha> metasLinhas) {
        this.metasLinhas = metasLinhas;
    }

    @JoinColumn(name="ID_INDICE_ECONOMICO", foreignKey=@ForeignKey(name="FK_META_CONTROLE_CONT_IND_ECO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IndiceEconomico getIndiceEconomico() {
        return this.indiceEconomico;
    }

    public void setIndiceEconomico(IndiceEconomico indiceEconomico) {
        this.indiceEconomico = indiceEconomico;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_INTERVALO_CONTROLE_CONT", foreignKey=@ForeignKey(name="FK_META_CONTROLE_CONT_INT_CONT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IntervaloControleCont getIntervaloControleCont() {
        return this.intervaloControleCont;
    }

    public void setIntervaloControleCont(IntervaloControleCont intervaloControleCont) {
        this.intervaloControleCont = intervaloControleCont;
    }
}

