/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemModeloDiarias;
import com.touchcomp.basementor.model.vo.ItemRegraCalcValorModDiaria;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MODELO_DIARIAS_CTE")
public class ModeloDiariasCte
implements InterfaceVO {
    private Long identificador;
    private Short ativo = 1;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<Cliente> clientes = new ArrayList<Cliente>();
    private List<ItemModeloDiarias> itemModeloDiarias = new ArrayList<ItemModeloDiarias>();
    private Integer tempoPernoiteCar = 0;
    private Integer tempoPernoiteDesc = 0;
    private Empresa empresa;
    private Short tipoCalculo = 0;
    private List<ItemRegraCalcValorModDiaria> itemRegraCalcValor = new ArrayList<ItemRegraCalcValorModDiaria>();
    private Double carencia = 0.0;

    @Id
    @Column(name="ID_MODELO_DIARIAS_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_DIARIAS_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="DESCRICAO", length=80)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany
    @JoinTable(name="modelo_diarias_cte_clientes", inverseJoinColumns={@JoinColumn(name="id_cliente")}, joinColumns={@JoinColumn(name="id_modelo_diarias_cte")})
    public List<Cliente> getClientes() {
        return this.clientes;
    }

    public void setClientes(List<Cliente> clientes) {
        this.clientes = clientes;
    }

    @OneToMany(mappedBy="modeloDiariaCTe", cascade={CascadeType.ALL}, targetEntity=ItemModeloDiarias.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemModeloDiarias> getItemModeloDiarias() {
        return this.itemModeloDiarias;
    }

    public void setItemModeloDiarias(List<ItemModeloDiarias> itemModeloDiarias) {
        this.itemModeloDiarias = itemModeloDiarias;
    }

    @Column(name="TEMPO_PERNOITE_CAR")
    public Integer getTempoPernoiteCar() {
        return this.tempoPernoiteCar;
    }

    public void setTempoPernoiteCar(Integer tempoPernoiteCar) {
        this.tempoPernoiteCar = tempoPernoiteCar;
    }

    @Column(name="TEMPO_PERNOITE_DESC")
    public Integer getTempoPernoiteDesc() {
        return this.tempoPernoiteDesc;
    }

    public void setTempoPernoiteDesc(Integer tempoPernoiteDesc) {
        this.tempoPernoiteDesc = tempoPernoiteDesc;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MODELO_DIARIAS_CTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="TIPO_CALCULO")
    public Short getTipoCalculo() {
        return this.tipoCalculo;
    }

    public void setTipoCalculo(Short tipoCalculo) {
        this.tipoCalculo = tipoCalculo;
    }

    @OneToMany(mappedBy="modeloDiariasCte")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemRegraCalcValorModDiaria> getItemRegraCalcValor() {
        return this.itemRegraCalcValor;
    }

    public void setItemRegraCalcValor(List<ItemRegraCalcValorModDiaria> itemRegraCalcValor) {
        this.itemRegraCalcValor = itemRegraCalcValor;
    }

    @Column(nullable=false, name="CARENCIA", precision=15, scale=2)
    public Double getCarencia() {
        return this.carencia;
    }

    public void setCarencia(Double carencia) {
        this.carencia = carencia;
    }
}

