/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FichaTecnicaAvaliador;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MODELO_FICHA_TECNICA", uniqueConstraints={@UniqueConstraint(name="UNQ1_MODELO_FICHA_TECNICA_DES", columnNames={"DESCRICAO"})})
public class ModeloFichaTecnica
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private List<ItemModeloFichaTecnica> itensModeloFichaTecnica = new ArrayList<ItemModeloFichaTecnica>();
    private Short ativo = 1;
    private String descricao;
    private List<FichaTecnicaAvaliador> fichasTecnicasAvaliador = new ArrayList<FichaTecnicaAvaliador>();

    @Id
    @Column(nullable=false, unique=true, name="ID_MODELO_FICHA_TECNICA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_FICHA_TECNICA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MODELO_FICHA_TECNICA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="DESCRICAO", length=80)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="modeloFichaTecnica")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @OrderColumn(name="indice")
    public List<ItemModeloFichaTecnica> getItensModeloFichaTecnica() {
        return this.itensModeloFichaTecnica;
    }

    public void setItensModeloFichaTecnica(List<ItemModeloFichaTecnica> itensModeloFichaTecnica) {
        this.itensModeloFichaTecnica = itensModeloFichaTecnica;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="modeloFicha", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<FichaTecnicaAvaliador> getFichasTecnicasAvaliador() {
        return this.fichasTecnicasAvaliador;
    }

    public void setFichasTecnicasAvaliador(List<FichaTecnicaAvaliador> fichasTecnicasAvaliador) {
        this.fichasTecnicasAvaliador = fichasTecnicasAvaliador;
    }
}

