/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoModulo;
import com.touchcomp.basementor.model.vo.ModulosSistemaSub;
import com.touchcomp.basementor.model.vo.NodoModulo;
import com.touchcomp.basementor.model.vo.NodoModuloOrder;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MODULO_SISTEMA")
public class ModuloSistema
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private NodoModulo nodoModChild;
    private String observacao;
    private Double tempoTreinamento = 0.0;
    private ClassificacaoModulo classificacaoModulo;
    private List<ModulosSistemaSub> submodulos;
    private Short desativado = 0;
    private List<NodoModuloOrder> nodoModuloOrder = new ArrayList<NodoModuloOrder>();

    public ModuloSistema() {
        this.submodulos = new LinkedList<ModulosSistemaSub>();
    }

    @Id
    @Column(name="ID_MODULO_SISTEMA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODULO_SISTEMA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NODO_MOD_CHILD", foreignKey=@ForeignKey(name="FK_MODULO_SISTEMA_NOD_MOD_CH"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NodoModulo getNodoModChild() {
        return this.nodoModChild;
    }

    public void setNodoModChild(NodoModulo nodoModChild) {
        this.nodoModChild = nodoModChild;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @JoinColumn(name="ID_CLASSIFICACAO_MODULO", foreignKey=@ForeignKey(name="FK_MODULO_SISTEMA_CLAS_MODULO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ClassificacaoModulo getClassificacaoModulo() {
        return this.classificacaoModulo;
    }

    public void setClassificacaoModulo(ClassificacaoModulo classificacaoModulo) {
        this.classificacaoModulo = classificacaoModulo;
    }

    @OneToMany(mappedBy="moduloSistema")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="indice")
    public List<NodoModuloOrder> getNodoModuloOrder() {
        return this.nodoModuloOrder;
    }

    public void setNodoModuloOrder(List<NodoModuloOrder> nodoModuloOrder) {
        this.nodoModuloOrder = nodoModuloOrder;
    }

    @Column(nullable=false, name="TEMPO_TREINAMENTO", precision=15, scale=2)
    public Double getTempoTreinamento() {
        return this.tempoTreinamento;
    }

    public void setTempoTreinamento(Double tempoTreinamento) {
        this.tempoTreinamento = tempoTreinamento;
    }

    @OneToMany(mappedBy="moduloSistema", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ModulosSistemaSub> getSubmodulos() {
        return this.submodulos;
    }

    public void setSubmodulos(List<ModulosSistemaSub> submodulos) {
        this.submodulos = submodulos;
    }

    @Column(name="DESATIVADO")
    public Short getDesativado() {
        return this.desativado;
    }

    public void setDesativado(Short desativado) {
        this.desativado = desativado;
    }
}

