/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MOTORISTA", uniqueConstraints={@UniqueConstraint(name="UNQ1_MOTORISTA", columnNames={"ID_PESSOA"})})
public class Motorista
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private String tipoSanguineo;
    private String numeroCNH;
    private Date dataEmissaoCNH;
    private String numeroRegistroCNH;
    private Date dataVencimentoCNH;
    private String categoriaCNH;
    private PlanoConta planoConta;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short motoristaProprio = 0;
    private UnidadeFederativa unidadeFederativaCNH;
    private Double percProdMotorista = 0.0;
    private Date dataVencimentoASO;

    @Id
    @Column(nullable=false, unique=true, name="ID_MOTORISTA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MOTORISTA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_MOTORISTA_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Column(name="TIPO_SANGUINEO", length=10)
    public String getTipoSanguineo() {
        return this.tipoSanguineo;
    }

    @Column(name="NUMERO_CNH", length=20)
    public String getNumeroCNH() {
        return this.numeroCNH;
    }

    @Column(name="DATA_EMISSAO_CNH")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissaoCNH() {
        return this.dataEmissaoCNH;
    }

    @Column(name="NUMERO_REGISTRO_CNH", length=20)
    public String getNumeroRegistroCNH() {
        return this.numeroRegistroCNH;
    }

    @Column(name="DATA_VENCIMENTO_CNH")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoCNH() {
        return this.dataVencimentoCNH;
    }

    @Column(name="CATEGORIA_CNH", length=20)
    public String getCategoriaCNH() {
        return this.categoriaCNH;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_MOTORISTA_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MOTORISTA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FEDERATIVA_CNH", foreignKey=@ForeignKey(name="FK_MOTORISTA_UF_CNH"))
    public UnidadeFederativa getUnidadeFederativaCNH() {
        return this.unidadeFederativaCNH;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public void setTipoSanguineo(String tipoSanguineo) {
        this.tipoSanguineo = tipoSanguineo;
    }

    public void setNumeroCNH(String numeroCNH) {
        this.numeroCNH = numeroCNH;
    }

    public void setDataEmissaoCNH(Date dataEmissaoCNH) {
        this.dataEmissaoCNH = dataEmissaoCNH;
    }

    public void setNumeroRegistroCNH(String numeroRegistroCNH) {
        this.numeroRegistroCNH = numeroRegistroCNH;
    }

    public void setDataVencimentoCNH(Date dataVencimentoCNH) {
        this.dataVencimentoCNH = dataVencimentoCNH;
    }

    public void setCategoriaCNH(String categoriaCNH) {
        this.categoriaCNH = categoriaCNH;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setUnidadeFederativaCNH(UnidadeFederativa unidadeFederativaCNH) {
        this.unidadeFederativaCNH = unidadeFederativaCNH;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="MOTORISTA_PROPRIO")
    public Short getMotoristaProprio() {
        return this.motoristaProprio;
    }

    public void setMotoristaProprio(Short motoristaProprio) {
        this.motoristaProprio = motoristaProprio;
    }

    @Column(nullable=false, name="PERC_PROD_MOTORISTA", precision=15, scale=4)
    public Double getPercProdMotorista() {
        return this.percProdMotorista;
    }

    public void setPercProdMotorista(Double percProdMotorista) {
        this.percProdMotorista = percProdMotorista;
    }

    @Column(name="DATA_VENCIMENTO_ASO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoASO() {
        return this.dataVencimentoASO;
    }

    public void setDataVencimentoASO(Date dataVencimentoASO) {
        this.dataVencimentoASO = dataVencimentoASO;
    }
}

