/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaChequeTerceiros;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.IntegracaoMovBancarioMovimento;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.TransferenciaContaValor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="MOVIMENTO_BANCARIO")
public class MovimentoBancario
implements InterfaceVO {
    private static final long serialVersionUID = 1L;
    private Long identificador;
    private Date dataLancamento;
    private Date dataCompensacao;
    private Short debCred;
    private HistoricoPadrao historicoPadrao;
    private Double valor;
    private String historico;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<ContraPartMovimentoBancario> contraPartMovimentoBancario;
    private Cheque cheque;
    private ModeloLancBancario modeloLancamentoBancario;
    private Boolean marcaContabilizacao;
    private ContaValores contaValor;
    private TransferenciaContaValor transferenciaValor;
    private ChequeTerceiros chequeTerceiros;
    private GrupoDeBaixaFormas grupoDeBaixaFormas;
    private BaixaChequeTerceiros baixaChequeTerceiros;
    private Short naoContabilizarMov;
    private Short movimentoConciliacao;
    private CentroResultadoContFin centroResultadoContFin;
    private NFCeControleCaixa nfceControleCaixa;
    private IntegracaoMovBancarioMovimento integracaoMovBancarioMovimento;

    public MovimentoBancario() {
        this.contraPartMovimentoBancario = new ArrayList<ContraPartMovimentoBancario>();
        this.naoContabilizarMov = 0;
        this.debCred = 0;
        this.valor = 0.0;
        this.movimentoConciliacao = 0;
    }

    public MovimentoBancario(Long identificador, Date dataLancamento, Date dataCompensacao, ContaValores conta, Short debCred, Double valor) {
        this.identificador = identificador;
        this.dataLancamento = dataLancamento;
        this.dataCompensacao = dataCompensacao;
        this.contaValor = conta;
        this.debCred = debCred;
        this.valor = valor;
        this.contraPartMovimentoBancario = new ArrayList<ContraPartMovimentoBancario>();
    }

    public MovimentoBancario(Long identificador, Date dataLancamento, Date dataCompensacao, Short debCred, Double valor) {
        this.identificador = identificador;
        this.dataLancamento = dataLancamento;
        this.dataCompensacao = dataCompensacao;
        this.debCred = debCred;
        this.valor = valor;
        this.contraPartMovimentoBancario = new ArrayList<ContraPartMovimentoBancario>();
    }

    @Id
    @Column(nullable=false, name="ID_MOVIMENTO_BANCARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MOVIMENTO_BANCARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="movimentoBancario")
    @Fetch(value=FetchMode.SELECT)
    public List<ContraPartMovimentoBancario> getContraPartMovimentoBancario() {
        return this.contraPartMovimentoBancario;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(name="DATA_COMPENSACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCompensacao() {
        return this.dataCompensacao;
    }

    @Column(nullable=false, name="DATA_LANCAMENTO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataLancamento() {
        return this.dataLancamento;
    }

    @Column(nullable=false, name="DEB_CRED")
    public Short getDebCred() {
        return this.debCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANCARIO_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="HISTORICO", length=1000)
    public String getHistorico() {
        return this.historico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANCARIO_HIST_PADR"))
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_LANC_BANCARIO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANCARIO_MOD_LANC"))
    public ModeloLancBancario getModeloLancamentoBancario() {
        return this.modeloLancamentoBancario;
    }

    @Column(nullable=false, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setContraPartMovimentoBancario(List contraPartMovimentoBancario) {
        this.contraPartMovimentoBancario = contraPartMovimentoBancario;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataCompensacao(Date dataCompensacao) {
        this.dataCompensacao = dataCompensacao;
    }

    public void setDataLancamento(Date dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public void setDebCred(Short debCred) {
        this.debCred = debCred;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public void setModeloLancamentoBancario(ModeloLancBancario modeloLancamentoBancario) {
        this.modeloLancamentoBancario = modeloLancamentoBancario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"MovimentoBancario: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CHEQUE", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANCARIO_CHEQUE"))
    public Cheque getCheque() {
        return this.cheque;
    }

    public void setCheque(Cheque cheque) {
        this.cheque = cheque;
    }

    @Transient
    public Boolean getMarcaContabilizacao() {
        return this.marcaContabilizacao;
    }

    public void setMarcaContabilizacao(Boolean marcaContabilizacao) {
        this.marcaContabilizacao = marcaContabilizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANCARIO_CON_VALOR"))
    public ContaValores getContaValor() {
        return this.contaValor;
    }

    public void setContaValor(ContaValores contaValor) {
        this.contaValor = contaValor;
    }

    @JoinColumn(name="ID_TRANSFERENCIA_VALOR", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANCARIO_TRANSF_VL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TransferenciaContaValor getTransferenciaValor() {
        return this.transferenciaValor;
    }

    public void setTransferenciaValor(TransferenciaContaValor transferenciaValor) {
        this.transferenciaValor = transferenciaValor;
    }

    @JoinColumn(name="ID_CHEQUE_TERCEIROS", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANC_CHEQUE_TERC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ChequeTerceiros getChequeTerceiros() {
        return this.chequeTerceiros;
    }

    public void setChequeTerceiros(ChequeTerceiros chequeTerceiros) {
        this.chequeTerceiros = chequeTerceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_BAIXA_FORMAS", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BANCARIO_GB_FOR"))
    public GrupoDeBaixaFormas getGrupoDeBaixaFormas() {
        return this.grupoDeBaixaFormas;
    }

    public void setGrupoDeBaixaFormas(GrupoDeBaixaFormas grupoDeBaixa) {
        this.grupoDeBaixaFormas = grupoDeBaixa;
    }

    @OneToOne(mappedBy="movimentoFinanceiro")
    public BaixaChequeTerceiros getBaixaChequeTerceiros() {
        return this.baixaChequeTerceiros;
    }

    public void setBaixaChequeTerceiros(BaixaChequeTerceiros baixaChequeTerceiros) {
        this.baixaChequeTerceiros = baixaChequeTerceiros;
    }

    @Column(name="NAO_CONTABILIZAR_MOV")
    public Short getNaoContabilizarMov() {
        return this.naoContabilizarMov;
    }

    public void setNaoContabilizarMov(Short naoContabilizarMov) {
        this.naoContabilizarMov = naoContabilizarMov;
    }

    @Column(name="MOVIMENTO_CONCILIACAO")
    public Short getMovimentoConciliacao() {
        return this.movimentoConciliacao;
    }

    public void setMovimentoConciliacao(Short movimentoConciliacao) {
        this.movimentoConciliacao = movimentoConciliacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_RESULTADO_CONT_FIN", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BAN_CENT_RES_CON_F"))
    public CentroResultadoContFin getCentroResultadoContFin() {
        return this.centroResultadoContFin;
    }

    public void setCentroResultadoContFin(CentroResultadoContFin centroResultadoContFin) {
        this.centroResultadoContFin = centroResultadoContFin;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTROLE_CAIXA_NFCE", foreignKey=@ForeignKey(name="FK_MOVIMENTO_BAN_C_C_NFCE"))
    public NFCeControleCaixa getNfceControleCaixa() {
        return this.nfceControleCaixa;
    }

    public void setNfceControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        this.nfceControleCaixa = nfceControleCaixa;
    }

    @OneToOne(mappedBy="movimentoBancario", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public IntegracaoMovBancarioMovimento getIntegracaoMovBancarioMovimento() {
        return this.integracaoMovBancarioMovimento;
    }

    public void setIntegracaoMovBancarioMovimento(IntegracaoMovBancarioMovimento integracaoMovBancarioMovimento) {
        this.integracaoMovBancarioMovimento = integracaoMovBancarioMovimento;
    }
}

