/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="MOVIMENTO_COLABORADOR_CC")
public class MovimentoColaboradorCentroCusto
implements InterfaceVO {
    private Long identificador;
    private Date dataInicio;
    private Date dataFinal;
    private Colaborador colaborador;
    private CentroCusto centroCusto;
    private MovimentoColaboradorCentroCusto movimentoAnterior;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;

    @Id
    @Column(nullable=false, unique=true, name="ID_MOV_COLABORADOR_CC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MOV_COLABORADOR_CC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIO")
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_MOV_COLABORADOR_CC_COLABORAD"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_MOV_COLABORADOR_CC_CEN_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOV_ANTERIOR", foreignKey=@ForeignKey(name="FK_MOV_COLABORADOR_CC_MOV_ANTER"))
    public MovimentoColaboradorCentroCusto getMovimentoAnterior() {
        return this.movimentoAnterior;
    }

    public void setMovimentoAnterior(MovimentoColaboradorCentroCusto movimentoAnterior) {
        this.movimentoAnterior = movimentoAnterior;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MOV_COLABORADOR_CC_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCentroCusto() != null ? this.getCentroCusto().getCodigo() : this.getCentroCusto(), this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

