/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.BaseInssEscalonada;
import com.touchcomp.basementor.model.vo.BeneficiarioPensaoFolha;
import com.touchcomp.basementor.model.vo.BeneficiarioPlanoSaudeFolha;
import com.touchcomp.basementor.model.vo.CategoriaSefip;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocIndInssMultVinculos;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.ItemIntegracaoAutonomoFolha;
import com.touchcomp.basementor.model.vo.ItemIntegracaoContratoIntermitente;
import com.touchcomp.basementor.model.vo.ItemLancGerencialFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MultiplosVinculosFolha;
import com.touchcomp.basementor.model.vo.PagamentoFolhaCompColaborador;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.StatusFolhaPagamento;
import com.touchcomp.basementor.model.vo.TipoSalario;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MOVIMENTO_FOLHA")
public class MovimentoFolha
implements InterfaceVO {
    private Long identificador;
    private AberturaPeriodo aberturaPeriodo;
    private Colaborador colaborador;
    private Short nrDepIrrf = 0;
    private Short nrQuota = 0;
    private List<ItemMovimentoFolha> itensMovimentoFolha;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Double diasTrabalhados = 0.0;
    private Double diasFaltosos = 0.0;
    private Double diasDescontoDSR = 0.0;
    private Double diasFolgas = 0.0;
    private Double diasFeriados = 0.0;
    private Double diasMes = 0.0;
    private Double diasUteis = 0.0;
    private Double bcIrrfSalario = 0.0;
    private Double vrIrrfSalario = 0.0;
    private Double aliqIrrfSalario = 0.0;
    private Double bcInssSalario = 0.0;
    private Double vrInssSalario = 0.0;
    private Double aliqInssSalario = 0.0;
    private Double bcFgtsSalario = 0.0;
    private Double vrFgtsSalario = 0.0;
    private Double aliqFgtsSalario = 0.0;
    private Double bcIrrfFerias = 0.0;
    private Double vrIrrfFerias = 0.0;
    private Double aliqIrrfFerias = 0.0;
    private Double bcInssFerias = 0.0;
    private Double vrInssFerias = 0.0;
    private Double aliqInssFerias = 0.0;
    private Double bcFgtsFerias = 0.0;
    private Double vrFgtsFerias = 0.0;
    private Double aliqFgtsFerias = 0.0;
    private Double bcIrrf13Sal = 0.0;
    private Double vrIrrf13Sal = 0.0;
    private Double aliqIrrf13Sal = 0.0;
    private Double bcInss13Sal = 0.0;
    private Double vrInss13Sal = 0.0;
    private Double aliqInss13Sal = 0.0;
    private Double bcFgts13Sal = 0.0;
    private Double vrFgts13Sal = 0.0;
    private Double aliqFgts13Sal = 0.0;
    private Double vrSalarioLiquido = 0.0;
    private Short arredondamentoMesSeguinte = 0;
    private LoteContabil lote;
    private Double diasAtestado = 0.0;
    private CentroCusto centroCusto;
    private Short informarImpostosManualmente = 0;
    private String motivo;
    private Short finalizado = 0;
    private Double diasAfastamentoMaternidade = 0.0;
    private Double valorSalarioNominal = 0.0;
    private Double valorDia = 0.0;
    private Double valorHora = 0.0;
    private Double horasAtestado = 0.0;
    private Double horasFaltas = 0.0;
    private List<ItemLancGerencialFolha> lancsGerenciais;
    private Double diasFerias = 0.0;
    private Double diasAfastamentos = 0.0;
    private Short informarAtestadoManual = 0;
    private Date dataInicialFerias;
    private Date dataFinalFerias;
    private Date dataInicialMaternidade;
    private Date dataFinalMaternidade;
    private Date dataInicialAfastamento;
    private Date dataFinalAfastamento;
    private Date dataInicialSegundaFerias;
    private Date dataFinalSegundaFerias;
    private Date dataInicialSegundoAfastamento;
    private Date dataFinalSegundoAfastamento;
    private Date dataInicialTerceiraFerias;
    private Date dataFinalTerceirasFerias;
    private Short gerarFinanceiro = 1;
    private Date dataAfastamento;
    private String tipoAfastamento;
    private List<ItemIntegracaoAutonomoFolha> rps;
    private Double bcAfastamento = 0.0;
    private ArquivamentoDoc arquivoDoc;
    private CategoriaSefip categoriaSefip;
    private Funcao funcao;
    private TipoSalario tipoSalario;
    private StatusFolhaPagamento statusFolha;
    private Double basePis = 0.0;
    private Double baseNaoPis = 0.0;
    private Double aliquotaPis = 0.0;
    private Double valorPis = 0.0;
    private List<MultiplosVinculosFolha> multiplosVinculos;
    private EsocIndInssMultVinculos esocIndInssMv;
    private EsocCadastroEstabelcimento estabelecimento;
    private EsocCadastroLotacaoTributaria lotacaoTributaria;
    private List<BeneficiarioPensaoFolha> beneficiosPensao;
    private List<BeneficiarioPlanoSaudeFolha> beneficiarioPlanoSaude;
    private TransferenciaColaborador transferenciaColaborador;
    private Double valorDeducaoDependenteIrrf = 0.0;
    private Double numeroDiasIntermitente = 0.0;
    private List<Rubricas1200> rubricas1200;
    private List<Rubricas1210> rubricas1210;
    private List<ItemIntegracaoContratoIntermitente> contratoIntermitente;
    private Double diasLincencaRemunerada = 0.0;
    private Double diasLincencaNaoRemunerada = 0.0;
    private PagamentoFolhaCompColaborador pagamentoFolhaComplementar;
    private List<BaseInssEscalonada> basesInss = new ArrayList<BaseInssEscalonada>();
    private Double baseInssRecisao = 0.0;
    private Double inssRecisao = 0.0;
    private Short folhaComBeneficioEmergencial = 0;
    private Short folhaComAtestadoSeguidoAfast = 0;
    private Double diasAtestadoSeguidoAfastamento = 0.0;
    private Double baseEmpresaColaborador = 0.0;
    private Double valorTotalCompras = 0.0;
    private Empresa empresaColaborador;

    public MovimentoFolha() {
        this.itensMovimentoFolha = new ArrayList<ItemMovimentoFolha>();
        this.rubricas1200 = new ArrayList<Rubricas1200>();
        this.rubricas1210 = new ArrayList<Rubricas1210>();
        this.rps = new ArrayList<ItemIntegracaoAutonomoFolha>();
        this.contratoIntermitente = new ArrayList<ItemIntegracaoContratoIntermitente>();
        this.multiplosVinculos = new ArrayList<MultiplosVinculosFolha>();
        this.beneficiosPensao = new ArrayList<BeneficiarioPensaoFolha>();
        this.beneficiarioPlanoSaude = new ArrayList<BeneficiarioPlanoSaudeFolha>();
        this.lancsGerenciais = new ArrayList<ItemLancGerencialFolha>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_MOVIMENTO_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MOVIMENTO_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ABERTURA_PERIODO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_ABERT_PERIOD"))
    public AberturaPeriodo getAberturaPeriodo() {
        return this.aberturaPeriodo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemMovimentoFolha> getItensMovimentoFolha() {
        return this.itensMovimentoFolha;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<MultiplosVinculosFolha> getMultiplosVinculos() {
        return this.multiplosVinculos;
    }

    public void setMultiplosVinculos(List<MultiplosVinculosFolha> multiplosVinculos) {
        this.multiplosVinculos = multiplosVinculos;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<BeneficiarioPensaoFolha> getBeneficiosPensao() {
        return this.beneficiosPensao;
    }

    public void setBeneficiosPensao(List<BeneficiarioPensaoFolha> beneficiosPensao) {
        this.beneficiosPensao = beneficiosPensao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<BeneficiarioPlanoSaudeFolha> getBeneficiarioPlanoSaude() {
        return this.beneficiarioPlanoSaude;
    }

    public void setBeneficiarioPlanoSaude(List<BeneficiarioPlanoSaudeFolha> beneficiarioPlanoSaude) {
        this.beneficiarioPlanoSaude = beneficiarioPlanoSaude;
    }

    @Column(name="NR_DEP_IRRF")
    public Short getNrDepIrrf() {
        return this.nrDepIrrf;
    }

    @Column(name="NR_QUOTA")
    public Short getNrQuota() {
        return this.nrQuota;
    }

    public void setAberturaPeriodo(AberturaPeriodo aberturaPeriodo) {
        this.aberturaPeriodo = aberturaPeriodo;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    public void setItensMovimentoFolha(List<ItemMovimentoFolha> itensMovimentoFolha) {
        this.itensMovimentoFolha = itensMovimentoFolha;
    }

    public void setNrDepIrrf(Short nrDepIrrf) {
        this.nrDepIrrf = nrDepIrrf;
    }

    public void setNrQuota(Short nrQuota) {
        this.nrQuota = nrQuota;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setIdentificador(Long idCor) {
        this.identificador = idCor;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DIAS_TRABALHADOS", precision=5, scale=2)
    public Double getDiasTrabalhados() {
        return this.diasTrabalhados;
    }

    public void setDiasTrabalhados(Double diasTrabalhados) {
        this.diasTrabalhados = diasTrabalhados = Double.valueOf(diasTrabalhados == null ? 0.0 : diasTrabalhados);
    }

    @Column(name="DIAS_FALTOSOS", precision=5, scale=2)
    public Double getDiasFaltosos() {
        return this.diasFaltosos;
    }

    public void setDiasFaltosos(Double diasFaltosos) {
        this.diasFaltosos = diasFaltosos = Double.valueOf(diasFaltosos == null ? 0.0 : diasFaltosos);
    }

    @Column(name="DIAS_DESCONTO_DSR", precision=5, scale=2)
    public Double getDiasDescontoDSR() {
        return this.diasDescontoDSR;
    }

    public void setDiasDescontoDSR(Double diasDescontoDSR) {
        this.diasDescontoDSR = diasDescontoDSR = Double.valueOf(diasDescontoDSR == null ? 0.0 : diasDescontoDSR);
    }

    @Column(name="DIAS_FOLGAS", precision=5, scale=2)
    public Double getDiasFolgas() {
        return this.diasFolgas;
    }

    public void setDiasFolgas(Double diasFolgas) {
        this.diasFolgas = diasFolgas = Double.valueOf(diasFolgas == null ? 0.0 : diasFolgas);
    }

    @Column(name="DIAS_FERIADOS", precision=5, scale=2)
    public Double getDiasFeriados() {
        return this.diasFeriados;
    }

    public void setDiasFeriados(Double diasFeriados) {
        this.diasFeriados = diasFeriados = Double.valueOf(diasFeriados == null ? 0.0 : diasFeriados);
    }

    @Column(name="DIAS_MES", precision=5, scale=2)
    public Double getDiasMes() {
        return this.diasMes;
    }

    public void setDiasMes(Double diasMes) {
        this.diasMes = diasMes = Double.valueOf(diasMes == null ? 0.0 : diasMes);
    }

    @Column(name="BC_IRRF_SALARIO", precision=15, scale=2)
    public Double getBcIrrfSalario() {
        return this.bcIrrfSalario;
    }

    public void setBcIrrfSalario(Double bcIrrfSalario) {
        this.bcIrrfSalario = bcIrrfSalario = Double.valueOf(bcIrrfSalario == null || bcIrrfSalario < 0.0 ? 0.0 : bcIrrfSalario);
    }

    @Column(name="VR_IRRF_SALARIO", precision=15, scale=2)
    public Double getVrIrrfSalario() {
        return this.vrIrrfSalario;
    }

    public void setVrIrrfSalario(Double vrIrrfSalario) {
        this.vrIrrfSalario = vrIrrfSalario = Double.valueOf(vrIrrfSalario == null || vrIrrfSalario < 0.0 ? 0.0 : vrIrrfSalario);
    }

    @Column(name="ALIQ_IRRF_SALARIO", precision=15, scale=2)
    public Double getAliqIrrfSalario() {
        return this.aliqIrrfSalario;
    }

    public void setAliqIrrfSalario(Double aliqIrrfSalario) {
        this.aliqIrrfSalario = aliqIrrfSalario = Double.valueOf(aliqIrrfSalario == null || aliqIrrfSalario < 0.0 ? 0.0 : aliqIrrfSalario);
    }

    @Column(name="BC_INSS_SALARIO", precision=15, scale=2)
    public Double getBcInssSalario() {
        return this.bcInssSalario;
    }

    public void setBcInssSalario(Double bcInssSalario) {
        this.bcInssSalario = bcInssSalario = Double.valueOf(bcInssSalario == null || bcInssSalario < 0.0 ? 0.0 : bcInssSalario);
    }

    @Column(name="VR_INSS_SALARIO", precision=15, scale=2)
    public Double getVrInssSalario() {
        return this.vrInssSalario;
    }

    public void setVrInssSalario(Double vrInssSalario) {
        this.vrInssSalario = vrInssSalario = Double.valueOf(vrInssSalario == null || vrInssSalario < 0.0 ? 0.0 : vrInssSalario);
    }

    @Column(name="ALIQ_INSS_SALARIO", precision=15, scale=2)
    public Double getAliqInssSalario() {
        return this.aliqInssSalario;
    }

    public void setAliqInssSalario(Double aliqInssSalario) {
        this.aliqInssSalario = aliqInssSalario = Double.valueOf(aliqInssSalario == null || aliqInssSalario < 0.0 ? 0.0 : aliqInssSalario);
    }

    @Column(name="BC_FGTS_SALARIO", precision=15, scale=2)
    public Double getBcFgtsSalario() {
        this.bcFgtsSalario = this.bcFgtsSalario == null || this.bcFgtsSalario < 0.0 ? 0.0 : this.bcFgtsSalario;
        return this.bcFgtsSalario;
    }

    public void setBcFgtsSalario(Double bcFgtsSalario) {
        this.bcFgtsSalario = bcFgtsSalario = Double.valueOf(bcFgtsSalario == null || bcFgtsSalario < 0.0 ? 0.0 : bcFgtsSalario);
    }

    @Column(name="VR_FGTS_SALARIO", precision=15, scale=2)
    public Double getVrFgtsSalario() {
        return this.vrFgtsSalario;
    }

    public void setVrFgtsSalario(Double vrFgtsSalario) {
        this.vrFgtsSalario = vrFgtsSalario = Double.valueOf(vrFgtsSalario == null ? 0.0 : vrFgtsSalario);
    }

    @Column(name="ALIQ_FGTS_SALARIO", precision=15, scale=2)
    public Double getAliqFgtsSalario() {
        return this.aliqFgtsSalario;
    }

    public void setAliqFgtsSalario(Double aliqFgtsSalario) {
        this.aliqFgtsSalario = aliqFgtsSalario = Double.valueOf(aliqFgtsSalario == null ? 0.0 : aliqFgtsSalario);
    }

    @Column(name="BC_IRRF_FERIAS", precision=15, scale=2)
    public Double getBcIrrfFerias() {
        this.bcIrrfFerias = this.bcIrrfFerias == null || this.bcIrrfFerias < 0.0 ? 0.0 : this.bcIrrfFerias;
        return this.bcIrrfFerias;
    }

    public void setBcIrrfFerias(Double bcIrrfFerias) {
        this.bcIrrfFerias = bcIrrfFerias = Double.valueOf(bcIrrfFerias == null || bcIrrfFerias < 0.0 ? 0.0 : bcIrrfFerias);
    }

    @Column(name="VR_IRRF_FERIAS", precision=15, scale=2)
    public Double getVrIrrfFerias() {
        return this.vrIrrfFerias;
    }

    public void setVrIrrfFerias(Double vrIrrfFerias) {
        this.vrIrrfFerias = vrIrrfFerias = Double.valueOf(vrIrrfFerias == null ? 0.0 : vrIrrfFerias);
    }

    @Column(name="ALIQ_IRRF_FERIAS", precision=15, scale=2)
    public Double getAliqIrrfFerias() {
        return this.aliqIrrfFerias;
    }

    public void setAliqIrrfFerias(Double aliqIrrfFerias) {
        this.aliqIrrfFerias = aliqIrrfFerias = Double.valueOf(aliqIrrfFerias == null ? 0.0 : aliqIrrfFerias);
    }

    @Column(name="BC_INSS_FERIAS", precision=15, scale=2)
    public Double getBcInssFerias() {
        return this.bcInssFerias;
    }

    public void setBcInssFerias(Double bcInssFerias) {
        this.bcInssFerias = bcInssFerias = Double.valueOf(bcInssFerias == null ? 0.0 : bcInssFerias);
    }

    @Column(name="VR_INSS_FERIAS", precision=15, scale=2)
    public Double getVrInssFerias() {
        return this.vrInssFerias;
    }

    public void setVrInssFerias(Double vrInssFerias) {
        this.vrInssFerias = vrInssFerias;
    }

    @Column(name="ALIQ_INSS_FERIAS", precision=15, scale=2)
    public Double getAliqInssFerias() {
        return this.aliqInssFerias;
    }

    public void setAliqInssFerias(Double aliqInssFerias) {
        this.aliqInssFerias = aliqInssFerias = Double.valueOf(aliqInssFerias == null ? 0.0 : aliqInssFerias);
    }

    @Column(name="BC_FGTS_FERIAS", precision=15, scale=2)
    public Double getBcFgtsFerias() {
        this.bcFgtsFerias = this.bcFgtsFerias == null || this.bcFgtsFerias < 0.0 ? 0.0 : this.bcFgtsFerias;
        return this.bcFgtsFerias;
    }

    public void setBcFgtsFerias(Double bcFgtsFerias) {
        this.bcFgtsFerias = bcFgtsFerias = Double.valueOf(bcFgtsFerias == null || bcFgtsFerias < 0.0 ? 0.0 : bcFgtsFerias);
    }

    @Column(name="VR_FGTS_FERIAS", precision=15, scale=2)
    public Double getVrFgtsFerias() {
        return this.vrFgtsFerias;
    }

    public void setVrFgtsFerias(Double vrFgtsFerias) {
        this.vrFgtsFerias = vrFgtsFerias = Double.valueOf(vrFgtsFerias == null || vrFgtsFerias < 0.0 ? 0.0 : vrFgtsFerias);
    }

    @Column(name="ALIQ_FGTS_FERIAS", precision=15, scale=2)
    public Double getAliqFgtsFerias() {
        return this.aliqFgtsFerias;
    }

    public void setAliqFgtsFerias(Double aliqFgtsFerias) {
        this.aliqFgtsFerias = aliqFgtsFerias = Double.valueOf(aliqFgtsFerias == null ? 0.0 : aliqFgtsFerias);
    }

    @Column(name="BC_IRRF_13SAL", precision=15, scale=2)
    public Double getBcIrrf13Sal() {
        return this.bcIrrf13Sal;
    }

    public void setBcIrrf13Sal(Double bcIrrf13Sal) {
        this.bcIrrf13Sal = bcIrrf13Sal = Double.valueOf(bcIrrf13Sal == null || bcIrrf13Sal < 0.0 ? 0.0 : bcIrrf13Sal);
    }

    @Column(name="VR_IRRF_13SAL", precision=15, scale=2)
    public Double getVrIrrf13Sal() {
        return this.vrIrrf13Sal;
    }

    public void setVrIrrf13Sal(Double vrIrrf13Sal) {
        this.vrIrrf13Sal = vrIrrf13Sal = Double.valueOf(vrIrrf13Sal == null ? 0.0 : vrIrrf13Sal);
    }

    @Column(name="ALIQ_IRRF_13SAL", precision=15, scale=2)
    public Double getAliqIrrf13Sal() {
        return this.aliqIrrf13Sal;
    }

    public void setAliqIrrf13Sal(Double aliqIrrf13Sal) {
        this.aliqIrrf13Sal = aliqIrrf13Sal = Double.valueOf(aliqIrrf13Sal == null ? 0.0 : aliqIrrf13Sal);
    }

    @Column(name="BC_INSS_13SAL", precision=15, scale=2)
    public Double getBcInss13Sal() {
        return this.bcInss13Sal;
    }

    public void setBcInss13Sal(Double bcInss13Sal) {
        this.bcInss13Sal = bcInss13Sal = Double.valueOf(bcInss13Sal == null || bcInss13Sal < 0.0 ? 0.0 : bcInss13Sal);
    }

    @Column(name="VR_INSS_13SAL", precision=15, scale=2)
    public Double getVrInss13Sal() {
        return this.vrInss13Sal;
    }

    public void setVrInss13Sal(Double vrInss13Sal) {
        this.vrInss13Sal = vrInss13Sal = Double.valueOf(vrInss13Sal == null ? 0.0 : vrInss13Sal);
    }

    @Column(name="ALIQ_INSS_13SAL", precision=15, scale=2)
    public Double getAliqInss13Sal() {
        return this.aliqInss13Sal;
    }

    public void setAliqInss13Sal(Double aliqInss13Sal) {
        this.aliqInss13Sal = aliqInss13Sal = Double.valueOf(aliqInss13Sal == null ? 0.0 : aliqInss13Sal);
    }

    @Column(name="BC_FGTS_13SAL", precision=15, scale=2)
    public Double getBcFgts13Sal() {
        this.bcFgts13Sal = this.bcFgts13Sal == null || this.bcFgts13Sal < 0.0 ? 0.0 : this.bcFgts13Sal;
        return this.bcFgts13Sal;
    }

    public void setBcFgts13Sal(Double bcFgts13Sal) {
        this.bcFgts13Sal = bcFgts13Sal = Double.valueOf(bcFgts13Sal == null || bcFgts13Sal < 0.0 ? 0.0 : bcFgts13Sal);
    }

    @Column(name="VR_FGTS_13SAL", precision=15, scale=2)
    public Double getVrFgts13Sal() {
        return this.vrFgts13Sal;
    }

    public void setVrFgts13Sal(Double vrFgts13Sal) {
        this.vrFgts13Sal = vrFgts13Sal = Double.valueOf(vrFgts13Sal == null ? 0.0 : vrFgts13Sal);
    }

    @Column(name="ALIQ_FGTS_13SAL", precision=15, scale=2)
    public Double getAliqFgts13Sal() {
        return this.aliqFgts13Sal;
    }

    public void setAliqFgts13Sal(Double aliqFgts13Sal) {
        this.aliqFgts13Sal = aliqFgts13Sal = Double.valueOf(aliqFgts13Sal == null ? 0.0 : aliqFgts13Sal);
    }

    @Column(name="DIAS_UTEIS", precision=6, scale=2)
    public Double getDiasUteis() {
        return this.diasUteis;
    }

    public void setDiasUteis(Double diasUteis) {
        this.diasUteis = diasUteis = Double.valueOf(diasUteis == null ? 0.0 : diasUteis);
    }

    @Column(name="VR_SALARIO_LIQUIDO", precision=15, scale=4)
    public Double getVrSalarioLiquido() {
        return this.vrSalarioLiquido;
    }

    public void setVrSalarioLiquido(Double vrSalarioLiquido) {
        this.vrSalarioLiquido = vrSalarioLiquido = Double.valueOf(vrSalarioLiquido == null ? 0.0 : vrSalarioLiquido);
    }

    @Column(name="ARRE_MES_SEGUINTE")
    public Short getArredondamentoMesSeguinte() {
        return this.arredondamentoMesSeguinte;
    }

    public void setArredondamentoMesSeguinte(Short arredondamentoMesSeguinte) {
        this.arredondamentoMesSeguinte = arredondamentoMesSeguinte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_LOTE"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LoteContabil getLote() {
        return this.lote;
    }

    public void setLote(LoteContabil lote) {
        this.lote = lote;
    }

    @Column(name="DIAS_ATESTADO", precision=15, scale=4)
    public Double getDiasAtestado() {
        this.diasAtestado = this.diasAtestado == null ? 0.0 : this.diasAtestado;
        return this.diasAtestado;
    }

    public void setDiasAtestado(Double diasAtestado) {
        this.diasAtestado = diasAtestado;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_CENTRO_CUSTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="INF_IMPOSTOS_MANUAL")
    public Short getInformarImpostosManualmente() {
        return this.informarImpostosManualmente;
    }

    public void setInformarImpostosManualmente(Short informarImpostosManualmente) {
        this.informarImpostosManualmente = informarImpostosManualmente;
    }

    @Column(name="MOTIVO", length=250)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Column(name="FINALIZADO")
    public Short getFinalizado() {
        return this.finalizado;
    }

    public void setFinalizado(Short finalizado) {
        this.finalizado = finalizado;
    }

    @Column(name="DIAS_AFASTAMENTO_MATERNIDADE", precision=15, scale=2)
    public Double getDiasAfastamentoMaternidade() {
        return this.diasAfastamentoMaternidade;
    }

    public void setDiasAfastamentoMaternidade(Double diasAfastamentoMaternidade) {
        this.diasAfastamentoMaternidade = diasAfastamentoMaternidade;
    }

    @Column(nullable=false, name="SALARIO_NOMINAL", precision=15, scale=2)
    public Double getValorSalarioNominal() {
        return this.valorSalarioNominal;
    }

    public void setValorSalarioNominal(Double valorSalarioNominal) {
        this.valorSalarioNominal = valorSalarioNominal;
    }

    @Column(name="VALOR_DIA", precision=15, scale=2)
    public Double getValorDia() {
        return this.valorDia;
    }

    public void setValorDia(Double valorDia) {
        this.valorDia = valorDia;
    }

    @Column(name="VALOR_HORA", precision=15, scale=2)
    public Double getValorHora() {
        return this.valorHora;
    }

    public void setValorHora(Double valorHora) {
        this.valorHora = valorHora;
    }

    @Column(name="HORAS_ATESTADO", precision=15, scale=2)
    public Double getHorasAtestado() {
        return this.horasAtestado;
    }

    public void setHorasAtestado(Double horasAtestado) {
        this.horasAtestado = horasAtestado;
    }

    @Column(name="HORAS_FALTAS", precision=15, scale=2)
    public Double getHorasFaltas() {
        return this.horasFaltas;
    }

    public void setHorasFaltas(Double horasFaltas) {
        this.horasFaltas = horasFaltas;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemIntegracaoAutonomoFolha> getRps() {
        return this.rps;
    }

    public void setRps(List<ItemIntegracaoAutonomoFolha> rps) {
        this.rps = rps;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemLancGerencialFolha> getLancsGerenciais() {
        return this.lancsGerenciais;
    }

    public void setLancsGerenciais(List<ItemLancGerencialFolha> lancsGerenciais) {
        this.lancsGerenciais = lancsGerenciais;
    }

    @Column(name="DIAS_FERIAS", precision=15, scale=4)
    public Double getDiasFerias() {
        return this.diasFerias;
    }

    public void setDiasFerias(Double diasFerias) {
        this.diasFerias = diasFerias;
    }

    @Column(nullable=false, name="DIAS_AFASTAMENTO", precision=15, scale=4)
    public Double getDiasAfastamentos() {
        return this.diasAfastamentos;
    }

    public void setDiasAfastamentos(Double diasAfastamentos) {
        this.diasAfastamentos = diasAfastamentos;
    }

    @Column(name="INFORMAR_ATESTADO_MANUAL")
    public Short getInformarAtestadoManual() {
        return this.informarAtestadoManual;
    }

    public void setInformarAtestadoManual(Short informarAtestadoManual) {
        this.informarAtestadoManual = informarAtestadoManual;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL_FERIAS")
    public Date getDataInicialFerias() {
        return this.dataInicialFerias;
    }

    public void setDataInicialFerias(Date dataInicialFerias) {
        this.dataInicialFerias = dataInicialFerias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_FERIAS")
    public Date getDataFinalFerias() {
        return this.dataFinalFerias;
    }

    public void setDataFinalFerias(Date dataFinalFerias) {
        this.dataFinalFerias = dataFinalFerias;
    }

    @Column(name="DATA_INICIAL_MATERNIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicialMaternidade() {
        return this.dataInicialMaternidade;
    }

    public void setDataInicialMaternidade(Date dataInicialMaternidade) {
        this.dataInicialMaternidade = dataInicialMaternidade;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_MATERNIDADE")
    public Date getDataFinalMaternidade() {
        return this.dataFinalMaternidade;
    }

    public void setDataFinalMaternidade(Date dataFinalMaternidade) {
        this.dataFinalMaternidade = dataFinalMaternidade;
    }

    @Column(name="DATA_INICIAL_AFASTAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicialAfastamento() {
        return this.dataInicialAfastamento;
    }

    public void setDataInicialAfastamento(Date dataInicialAfastamento) {
        this.dataInicialAfastamento = dataInicialAfastamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_AFASTAMENTO")
    public Date getDataFinalAfastamento() {
        return this.dataFinalAfastamento;
    }

    public void setDataFinalAfastamento(Date dataFinalAfastamento) {
        this.dataFinalAfastamento = dataFinalAfastamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL_SEGUNDA_FERIAS")
    public Date getDataInicialSegundaFerias() {
        return this.dataInicialSegundaFerias;
    }

    public void setDataInicialSegundaFerias(Date dataInicialSegundaFerias) {
        this.dataInicialSegundaFerias = dataInicialSegundaFerias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_SEGUNDA_FERIAS")
    public Date getDataFinalSegundaFerias() {
        return this.dataFinalSegundaFerias;
    }

    public void setDataFinalSegundaFerias(Date dataFinalSegundaFerias) {
        this.dataFinalSegundaFerias = dataFinalSegundaFerias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL_SEG_AFASTAMENTO")
    public Date getDataInicialSegundoAfastamento() {
        return this.dataInicialSegundoAfastamento;
    }

    public void setDataInicialSegundoAfastamento(Date dataInicialSegundoAfastamento) {
        this.dataInicialSegundoAfastamento = dataInicialSegundoAfastamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_SEGUNDO_AFASTAMENTO")
    public Date getDataFinalSegundoAfastamento() {
        return this.dataFinalSegundoAfastamento;
    }

    public void setDataFinalSegundoAfastamento(Date dataFinalSegundoAfastamento) {
        this.dataFinalSegundoAfastamento = dataFinalSegundoAfastamento;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="DATA_AFASTAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAfastamento() {
        return this.dataAfastamento;
    }

    public void setDataAfastamento(Date dataAfastamento) {
        this.dataAfastamento = dataAfastamento;
    }

    @Column(name="TIPO_AFASTAMENTO_RESCISAO", length=150)
    public String getTipoAfastamento() {
        return this.tipoAfastamento;
    }

    public void setTipoAfastamento(String tipoAfastamento) {
        this.tipoAfastamento = tipoAfastamento;
    }

    @Column(nullable=false, name="BC_AFASTAMENTO", precision=15, scale=2)
    public Double getBcAfastamento() {
        return this.bcAfastamento;
    }

    public void setBcAfastamento(Double bcAfastamento) {
        this.bcAfastamento = bcAfastamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ARQUIVO_DOC", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_DOCUMENTOS"))
    public ArquivamentoDoc getArquivoDoc() {
        return this.arquivoDoc;
    }

    public void setArquivoDoc(ArquivamentoDoc arquivoDoc) {
        this.arquivoDoc = arquivoDoc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_SEFIP", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_CAT_SEFIP"))
    public CategoriaSefip getCategoriaSefip() {
        return this.categoriaSefip;
    }

    public void setCategoriaSefip(CategoriaSefip categoriaSefip) {
        this.categoriaSefip = categoriaSefip;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_FUNCAO"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SALARIO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_FOLHA_TP_SALARIO"))
    public TipoSalario getTipoSalario() {
        return this.tipoSalario;
    }

    public void setTipoSalario(TipoSalario tipoSalario) {
        this.tipoSalario = tipoSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_FOLHA_PAGAMENTO", foreignKey=@ForeignKey(name="FK_STATUS_FOLHA_PAGAMENTO_MOV_F"))
    public StatusFolhaPagamento getStatusFolha() {
        return this.statusFolha;
    }

    public void setStatusFolha(StatusFolhaPagamento statusFolha) {
        this.statusFolha = statusFolha;
    }

    @Column(name="BASE_PIS", precision=15, scale=4)
    public Double getBasePis() {
        return this.basePis;
    }

    public void setBasePis(Double basePis) {
        this.basePis = basePis;
    }

    @Column(name="BASE_NAO_PIS", precision=15, scale=4)
    public Double getBaseNaoPis() {
        return this.baseNaoPis;
    }

    public void setBaseNaoPis(Double baseNaoPis) {
        this.baseNaoPis = baseNaoPis;
    }

    @Column(name="ALIQUOTA_PIS", precision=15, scale=4)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = aliquotaPis;
    }

    @Column(name="VALOR_PIS", precision=15, scale=4)
    public Double getValorPis() {
        return this.valorPis;
    }

    public void setValorPis(Double valorPis) {
        this.valorPis = valorPis;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_IND_INSS_MULT_V", foreignKey=@ForeignKey(name="FK_ESOC_IND_MULT_VINCULOS"))
    public EsocIndInssMultVinculos getEsocIndInssMv() {
        return this.esocIndInssMv;
    }

    public void setEsocIndInssMv(EsocIndInssMultVinculos esocIndInssMv) {
        this.esocIndInssMv = esocIndInssMv;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESTABELECIMENTO", foreignKey=@ForeignKey(name="FK_ESTABELECIMENTO_MOV_FOLHA"))
    public EsocCadastroEstabelcimento getEstabelecimento() {
        return this.estabelecimento;
    }

    public void setEstabelecimento(EsocCadastroEstabelcimento estabelecimento) {
        this.estabelecimento = estabelecimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTACAO_TRIBUTARIA", foreignKey=@ForeignKey(name="FK_LOTACAO_TRIB_MOV_FOLHA"))
    public EsocCadastroLotacaoTributaria getLotacaoTributaria() {
        return this.lotacaoTributaria;
    }

    public void setLotacaoTributaria(EsocCadastroLotacaoTributaria lotacaoTributaria) {
        this.lotacaoTributaria = lotacaoTributaria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSFERENCIA_COLABORADOR", foreignKey=@ForeignKey(name="FK_TRANS_COLABORADOR_MOV_FOLHA"))
    public TransferenciaColaborador getTransferenciaColaborador() {
        return this.transferenciaColaborador;
    }

    public void setTransferenciaColaborador(TransferenciaColaborador transferenciaColaborador) {
        this.transferenciaColaborador = transferenciaColaborador;
    }

    @Column(name="VALOR_DEDUCAO_DEP_IRRF", precision=15, scale=4)
    public Double getValorDeducaoDependenteIrrf() {
        return this.valorDeducaoDependenteIrrf;
    }

    public void setValorDeducaoDependenteIrrf(Double valorDeducaoDependenteIrrf) {
        this.valorDeducaoDependenteIrrf = valorDeducaoDependenteIrrf;
    }

    @Column(name="DIAS_INTERMINTENTE", precision=15, scale=2)
    public Double getNumeroDiasIntermitente() {
        return this.numeroDiasIntermitente;
    }

    public void setNumeroDiasIntermitente(Double numeroDiasIntermitente) {
        this.numeroDiasIntermitente = numeroDiasIntermitente;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Rubricas1200> getRubricas1200() {
        return this.rubricas1200;
    }

    public void setRubricas1200(List<Rubricas1200> rubricas1200) {
        this.rubricas1200 = rubricas1200;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.ALL})
    public List<Rubricas1210> getRubricas1210() {
        return this.rubricas1210;
    }

    public void setRubricas1210(List<Rubricas1210> rubricas1210) {
        this.rubricas1210 = rubricas1210;
    }

    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @OneToMany(mappedBy="movimentoFolha")
    public List<ItemIntegracaoContratoIntermitente> getContratoIntermitente() {
        return this.contratoIntermitente;
    }

    public void setContratoIntermitente(List<ItemIntegracaoContratoIntermitente> contratoIntermitente) {
        this.contratoIntermitente = contratoIntermitente;
    }

    @Column(name="DIAS_LINCENCA_REMUNERADA", precision=15, scale=2)
    public Double getDiasLincencaRemunerada() {
        return this.diasLincencaRemunerada;
    }

    public void setDiasLincencaRemunerada(Double diasLincencaRemunerada) {
        this.diasLincencaRemunerada = diasLincencaRemunerada;
    }

    @Column(name="DIAS_LINCENCA_NAO_REMUNE", precision=15, scale=2)
    public Double getDiasLincencaNaoRemunerada() {
        return this.diasLincencaNaoRemunerada;
    }

    public void setDiasLincencaNaoRemunerada(Double diasLincencaNaoRemunerada) {
        this.diasLincencaNaoRemunerada = diasLincencaNaoRemunerada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PAG_FOLHA_COMPLEMENTAR", foreignKey=@ForeignKey(name="FK_PAG_FOLHA_COMPLEMENTAR"))
    public PagamentoFolhaCompColaborador getPagamentoFolhaComplementar() {
        return this.pagamentoFolhaComplementar;
    }

    public void setPagamentoFolhaComplementar(PagamentoFolhaCompColaborador pagamentoFolhaComplementar) {
        this.pagamentoFolhaComplementar = pagamentoFolhaComplementar;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="movimentoFolha", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<BaseInssEscalonada> getBasesInss() {
        return this.basesInss;
    }

    public void setBasesInss(List<BaseInssEscalonada> basesInss) {
        this.basesInss = basesInss;
    }

    @Column(name="BASE_INSS_RECISAO", precision=15, scale=2)
    public Double getBaseInssRecisao() {
        return this.baseInssRecisao;
    }

    public void setBaseInssRecisao(Double baseInssRecisao) {
        this.baseInssRecisao = baseInssRecisao;
    }

    @Column(name="INSS_RECISAO", precision=15, scale=2)
    public Double getInssRecisao() {
        return this.inssRecisao;
    }

    public void setInssRecisao(Double inssRecisao) {
        this.inssRecisao = inssRecisao;
    }

    @Column(name="FOLHA_COM_BENEFICIO_EMERGENCIAL")
    public Short getFolhaComBeneficioEmergencial() {
        return this.folhaComBeneficioEmergencial;
    }

    public void setFolhaComBeneficioEmergencial(Short folhaComBeneficioEmergencial) {
        this.folhaComBeneficioEmergencial = folhaComBeneficioEmergencial;
    }

    @Column(name="DATA_INICIAL_TER_FERIAS")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicialTerceiraFerias() {
        return this.dataInicialTerceiraFerias;
    }

    public void setDataInicialTerceiraFerias(Date dataInicialTerceiraFerias) {
        this.dataInicialTerceiraFerias = dataInicialTerceiraFerias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_TER_FERIAS")
    public Date getDataFinalTerceirasFerias() {
        return this.dataFinalTerceirasFerias;
    }

    public void setDataFinalTerceirasFerias(Date dataFinalTerceirasFerias) {
        this.dataFinalTerceirasFerias = dataFinalTerceirasFerias;
    }

    @Column(name="folha_com_atestado_seguido_afas")
    public Short getFolhaComAtestadoSeguidoAfast() {
        return this.folhaComAtestadoSeguidoAfast;
    }

    public void setFolhaComAtestadoSeguidoAfast(Short folhaComAtestadoSeguidoAfast) {
        this.folhaComAtestadoSeguidoAfast = folhaComAtestadoSeguidoAfast;
    }

    @Column(name="dias_atestado_seguido_afast", precision=15, scale=2)
    public Double getDiasAtestadoSeguidoAfastamento() {
        return this.diasAtestadoSeguidoAfastamento;
    }

    public void setDiasAtestadoSeguidoAfastamento(Double diasAtestadoSeguidoAfastamento) {
        this.diasAtestadoSeguidoAfastamento = diasAtestadoSeguidoAfastamento;
    }

    @Column(name="base_empresa_colaborador", precision=15, scale=2)
    public Double getBaseEmpresaColaborador() {
        return this.baseEmpresaColaborador;
    }

    public void setBaseEmpresaColaborador(Double baseEmpresaColaborador) {
        this.baseEmpresaColaborador = baseEmpresaColaborador;
    }

    @Column(name="valor_compras", precision=15, scale=2)
    public Double getValorTotalCompras() {
        return this.valorTotalCompras;
    }

    public void setValorTotalCompras(Double valorTotalCompras) {
        this.valorTotalCompras = valorTotalCompras;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa_colaborador")
    public Empresa getEmpresaColaborador() {
        return this.empresaColaborador;
    }

    public void setEmpresaColaborador(Empresa empresaColaborador) {
        this.empresaColaborador = empresaColaborador;
    }
}

