/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.Pneu;
import com.touchcomp.basementor.model.vo.PosicaoTipoVeiculo;
import com.touchcomp.basementor.model.vo.Recap;
import com.touchcomp.basementor.model.vo.TipoMovimentoPneu;
import com.touchcomp.basementor.model.vo.TipoViaVeiculo;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="MOVIMENTO_PNEU")
public class MovimentoPneu
implements InterfaceVO {
    private Long identificador;
    private Date dataMovimento;
    private Empresa empresa;
    private TipoMovimentoPneu tipoMovimentoPneu;
    private Double odometro = 0.0;
    private Veiculo veiculo;
    private Pneu pneu;
    private PosicaoTipoVeiculo posicaoTipoVeiculo;
    private ItemNotaTerceiros itemNotaTerceiros;
    private Double sulco = 0.0;
    private Recap recap;
    private String observacao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private MovimentoPneu movimentoPneuAnterior;
    private Double odometroRodado = 0.0;
    private Fornecedor fornecedorRecap;
    private TipoViaVeiculo tipoViaVeiculo;
    private Double valorInitario;
    private LancamentoCtbGerencial lancamentoRecapagem;

    public MovimentoPneu() {
        this.setValorInitario(0.0);
    }

    @Id
    @Column(name="ID_MOVIMENTO_PNEU")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MOVIMENTO_PNEU")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTO")
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    public void setDataMovimento(Date dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @OneToOne(targetEntity=Empresa.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToOne(targetEntity=TipoMovimentoPneu.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_MOVIMENTO_PNEU", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_TP_MOV_PNEU"))
    public TipoMovimentoPneu getTipoMovimentoPneu() {
        return this.tipoMovimentoPneu;
    }

    public void setTipoMovimentoPneu(TipoMovimentoPneu tipoMovimentoPneu) {
        this.tipoMovimentoPneu = tipoMovimentoPneu;
    }

    @Column(name="ODOMETRO", precision=15, scale=4)
    public Double getOdometro() {
        return this.odometro;
    }

    public void setOdometro(Double odometro) {
        this.odometro = odometro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VEICULO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_VEICULO"))
    public Veiculo getVeiculo() {
        return this.veiculo;
    }

    public void setVeiculo(Veiculo veiculo) {
        this.veiculo = veiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PNEU", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_PNEU"))
    public Pneu getPneu() {
        return this.pneu;
    }

    public void setPneu(Pneu pneu) {
        this.pneu = pneu;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_POSICAO_TIPO_VEIC", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_POS_TIPO_VEIC"))
    public PosicaoTipoVeiculo getPosicaoTipoVeiculo() {
        return this.posicaoTipoVeiculo;
    }

    public void setPosicaoTipoVeiculo(PosicaoTipoVeiculo posicaoTipoVeiculo) {
        this.posicaoTipoVeiculo = posicaoTipoVeiculo;
    }

    @OneToOne(targetEntity=ItemNotaTerceiros.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_ITEM_NOTA_TER"))
    public ItemNotaTerceiros getItemNotaTerceiros() {
        return this.itemNotaTerceiros;
    }

    public void setItemNotaTerceiros(ItemNotaTerceiros itemNotaTerceiros) {
        this.itemNotaTerceiros = itemNotaTerceiros;
    }

    @Column(name="SULCO", precision=15, scale=4)
    public Double getSulco() {
        return this.sulco;
    }

    public void setSulco(Double sulco) {
        this.sulco = sulco;
    }

    @OneToOne(targetEntity=Recap.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RECAP", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_RECAP"))
    public Recap getRecap() {
        return this.recap;
    }

    public void setRecap(Recap recap) {
        this.recap = recap;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(targetEntity=MovimentoPneu.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOVIMENTO_PNEU_ANTERIOR", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_MOV_PNEU_ANTE"))
    public MovimentoPneu getMovimentoPneuAnterior() {
        return this.movimentoPneuAnterior;
    }

    public void setMovimentoPneuAnterior(MovimentoPneu movimentoPneuAnterior) {
        this.movimentoPneuAnterior = movimentoPneuAnterior;
    }

    @Column(nullable=false, name="ODOMETRO_RODADO", precision=15, scale=4)
    public Double getOdometroRodado() {
        return this.odometroRodado;
    }

    public void setOdometroRodado(Double odometroRodado) {
        this.odometroRodado = odometroRodado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR_RECAP", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_8"))
    public Fornecedor getFornecedorRecap() {
        return this.fornecedorRecap;
    }

    public void setFornecedorRecap(Fornecedor fornecedorRecap) {
        this.fornecedorRecap = fornecedorRecap;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_VIA_VEICULO", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_TP_VIA_P"))
    public TipoViaVeiculo getTipoViaVeiculo() {
        return this.tipoViaVeiculo;
    }

    public void setTipoViaVeiculo(TipoViaVeiculo tipoViaVeiculo) {
        this.tipoViaVeiculo = tipoViaVeiculo;
    }

    @Column(name="valor_unitario", precision=15, scale=2)
    public Double getValorInitario() {
        return this.valorInitario;
    }

    public void setValorInitario(Double valorInitario) {
        this.valorInitario = valorInitario;
    }

    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_LANCAMENTO_RECAPAGEM", foreignKey=@ForeignKey(name="FK_MOVIMENTO_PNEU_LANC_RECAPAGEM"))
    public LancamentoCtbGerencial getLancamentoRecapagem() {
        return this.lancamentoRecapagem;
    }

    public void setLancamentoRecapagem(LancamentoCtbGerencial lancamentoRecapagem) {
        this.lancamentoRecapagem = lancamentoRecapagem;
    }
}

