/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeFinalidadeEmissao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.DadosRecAgrNFCe;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntermediadorComercial;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoNFe;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NFCeCaixa;
import com.touchcomp.basementor.model.vo.NFCeCancelamento;
import com.touchcomp.basementor.model.vo.NFCeConsumidor;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCeEnderecoEntrega;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NFCeLogPermissaoUsuario;
import com.touchcomp.basementor.model.vo.NFCeLoteNotas;
import com.touchcomp.basementor.model.vo.NFCeObsContrib;
import com.touchcomp.basementor.model.vo.NFCeObsFisco;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.NFCePeriodoEmissao;
import com.touchcomp.basementor.model.vo.NFCePessoa;
import com.touchcomp.basementor.model.vo.NFCeTotalizadores;
import com.touchcomp.basementor.model.vo.NFCeTransp;
import com.touchcomp.basementor.model.vo.NFCeVolume;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="NFCE")
public class NFCe
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_NFCE", precision=18, scale=0)
    @GeneratedValue(generator="gen", strategy=GenerationType.SEQUENCE)
    @GenericGenerator(name="gen", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="GEN_NFCE")})
    private Long identificador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE_PERIODO_EMISSAO", foreignKey=@ForeignKey(name="FK_NFCE_PER_EMISSAO_NFCE"))
    private NFCePeriodoEmissao periodoEmissaoNFCe;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_EMISSAO_NFE", foreignKey=@ForeignKey(name="FK_NFCE_PER_EMISSAO_NFE"))
    private PeriodoEmissaoNFe periodoEmissaoNFe;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE_CAIXA", foreignKey=@ForeignKey(name="FK_NFCE_NFCE_CAIXA"))
    private NFCeCaixa nfCeCaixa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NFCE_EMPRESA"))
    private Empresa empresa;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_EMISSAO")
    private Date dataEmissao;
    @Version
    @Column(name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @Column(name="INDICADADOR_CONSUMIDOR_FINAL")
    private Short indicadorConsumidorFinal;
    @Column(name="INDICADOR_PRESENCA_CONSUMIDOR")
    private Short indicadorPresencaConsumidor;
    @Column(name="SERIE", length=3)
    private String serie;
    @Column(name="NUMERO")
    private Long numero = 0L;
    @Column(name="NUMERO_RANDOMICO")
    private Integer numeroRandomico = 0;
    @Column(name="DIGITO_VERIFICADOR")
    private Integer digitoVerificador = 0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_NFCE_UNID_FAT_CLIENTE"))
    private UnidadeFatCliente unidadeFatCliente;
    @Column(name="TIPO_ENT_SAI")
    private Short tipoEntSai = 1;
    @Column(name="FINALIDADE_EMISSAO")
    private Short finalidadeEmissao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VERSAO_NFE", foreignKey=@ForeignKey(name="FK_NFCE_VERSAO_NFE"))
    private VersaoNFe versaoNfe;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_DOCUMENTO", foreignKey=@ForeignKey(name="FK_NFCE_SIT_DOCUMENTO"))
    private SituacaoDocumento situacaoDocumento;
    @Column(name="FORMATO_IMPRESSAO")
    private String formatoImpressao;
    @Column(name="AMBIENTE")
    private Short ambiente;
    @Column(name="STATUS")
    private Integer status = 0;
    @Column(name="NR_PROTOCOLO", length=100)
    private String nrProtocolo;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(unique=true, name="ID_TOTALIZADORES", foreignKey=@ForeignKey(name="FK_NFCE_TOTALIZADORES"))
    private NFCeTotalizadores totalizadores;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(unique=true, name="ID_DADOS_TRANSPORTE", foreignKey=@ForeignKey(name="FK_NFCE_DADOS_TRANSPORTE"))
    private NFCeTransp dadosTransporte;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_ENDERECO_ENTREGA", foreignKey=@ForeignKey(name="FK_NFCE_NFCE_END_ENTREGA"))
    private NFCeEnderecoEntrega enderecoEntrega;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_NFCE_MOD_DOC_FISCAL"))
    private ModeloDocFiscal modeloDocFiscal;
    @Column(name="VERSAO_APLICATIVO", length=50)
    private String versaoAplicativo;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="nfce", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<NFCeItem> itens = new LinkedList<NFCeItem>();
    @OneToMany(mappedBy="nfce", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<NFCePagamento> pagamentos;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CONTROLE_CAIXA", foreignKey=@ForeignKey(name="FK_NFCE_NFCE_CONTROLE_CAIXA"))
    private NFCeControleCaixa nfCeControleCaixa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_NFCE_REPRESENTANTE"))
    private Representante representante;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="ID_LOTE_NOTAS", foreignKey=@ForeignKey(name="FK_NFCE_NFCE_LOTE_NOTAS"))
    private NFCeLoteNotas loteNotas;
    @Column(name="CHAVE_NFCE", length=44)
    private String chaveNFCe;
    @Column(name="IDENTIFICADOR_CSC_CONTRIBUINTE", length=50)
    private String identificadorCSCContribuinte;
    @Column(name="CODIGO_CSC_CONTRIBUINTE", length=100)
    private String codigoCSCContribuinte;
    @Column(name="URL_QR_CODE", length=2000)
    private String urlQrCode;
    @Column(name="URL_CONSULTA", length=2000)
    private String urlConsulta;
    @Column(name="TIPO_EMISSAO")
    private Integer tipoEmissao = 0;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_NFCE_CANCELAMENTO", foreignKey=@ForeignKey(name="FK_NFCE_CANCELAMENTO"))
    private NFCeCancelamento nfCeCancelamento;
    @Column(name="DIGEST_VALUE", length=200)
    private String digestValue;
    @Column(nullable=false, name="SERIAL_FOR_SINC", length=100)
    private String serialForSinc;
    @Column(name="MOTIVO", length=500)
    private String motivo;
    @Column(name="TIPO_AMBIENTE")
    private Integer tipoAmbiente = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_AUTORIZACAO")
    private Date dataAutorizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBS_GERAL_CONTRIB", foreignKey=@ForeignKey(name="FK_NFCE_OBS_GERAL_CONTRIB"))
    private ObjectObsDinamica objObsGeralContrib;
    @Column(name="OBS_GERAL_CONTRIB", length=5000)
    private String obsGeralContrib;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBS_GERAL_FISCO", foreignKey=@ForeignKey(name="FK_NFCE_OBS_GERAL_FISCO"))
    private ObjectObsDinamica objObsGeralFisco;
    @Column(name="OBS_GERAL_FISCO", length=5000)
    private String obsGeralFisco;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE_CONSUMIDOR", foreignKey=@ForeignKey(name="FK_NFCE_NFCE_CONSUMIDOR"))
    private NFCeConsumidor nfCeConsumidor;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_NFCE_NFCE_NAT_OPERACAO"))
    private NaturezaOperacao naturezaOperacao;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="nfce", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private InutilizacaoNumeracaoNFe inutilizacaoNFe;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="ID_NFCE_CANC_ANTERIOR", foreignKey=@ForeignKey(name="FK_NFCE_NFCE_NFCE_CANC_ANT"))
    private NFCeCancelamento nfceCancelamentoAnterior;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_AUTORIZADA", foreignKey=@ForeignKey(name="FK_NFCE_PESSOA_AUTORIZADA"))
    private Pessoa pessoaAutorizada;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREV_SAIDA")
    private Date dataPrevSaida;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_NFCE_PESSOA", foreignKey=@ForeignKey(name="FK_NFCE_PESSOA"))
    private NFCePessoa nfcePessoa;
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="NFCE_LV_FISCAL", joinColumns={@JoinColumn(name="ID_NFCE")}, inverseJoinColumns={@JoinColumn(name="ID_LIVRO_FISCAL")})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<LivroFiscal> livrosFiscais;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_NFCE_COND_PAGAMENTO"))
    private CondicoesPagamento condicoesPagamento;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="nfce", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<NFCeLogPermissaoUsuario> liberacoes = new LinkedList<NFCeLogPermissaoUsuario>();
    @OneToMany(mappedBy="nfce", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<NFCeObsContrib> obsContribuinte;
    @OneToMany(mappedBy="nfce", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<NFCeObsFisco> obsFisco;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_NFCE_PEDIDO"))
    private Pedido pedido;
    @Transient
    @Column(name="xml")
    private byte[] xml;
    @Transient
    @Column(name="xml_autorizacao")
    private byte[] xmlAutorizacao;
    @OneToMany(mappedBy="nfCe", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<NFCeVolume> volumes;
    @Column(name="PLACA_VEICULO", length=10)
    private String placaVeiculo;
    @Column(name="KM_VEICULO")
    private Long km = 0L;
    @Column(name="REPROCESSADO")
    private Short reprocessado = 9999;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_CLIENTE", foreignKey=@ForeignKey(name="FK_NFCE_UNID_FAT_CLIENTE"))
    private ClassificacaoClientes classificacaoCliente;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_NFCE_VERSAO_NFE"))
    private CategoriaPessoa categoriaPessoa;
    @Column(name="TIPO_INTERMEDIADOR_COMERCIAL")
    private Short tipoIntermediadorComercial;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTERMEDIADOR_COMERCIAL")
    private IntermediadorComercial intermediadorComercial;
    @Column(name="VERSAO_PDV")
    private String versaoPdv;
    @OneToMany(mappedBy="nfce", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private List<DadosRecAgrNFCe> receitasAgronomicas;

    public NFCe() {
        this.pagamentos = new LinkedList<NFCePagamento>();
        this.obsContribuinte = new LinkedList<NFCeObsContrib>();
        this.obsFisco = new LinkedList<NFCeObsFisco>();
        this.tipoIntermediadorComercial = EnumConstNFeIndIntermediador.NAO_SE_APLICA.getValue();
        this.finalidadeEmissao = EnumConstNFeFinalidadeEmissao.NORMAL.getValue();
        this.ambiente = Short.valueOf(ConstAmbiente.PRODUCAO.getCodigo());
        this.indicadorConsumidorFinal = EnumConstantsMentorSimNao.SIM.getValue();
        this.indicadorPresencaConsumidor = EnumConstNFeIndicadorPresConsumidor.OPERACAO_PRESENCIAL.getValue();
        this.dataEmissao = new Date();
        this.livrosFiscais = new ArrayList<LivroFiscal>();
        this.volumes = new ArrayList<NFCeVolume>();
        this.receitasAgronomicas = new ArrayList<DadosRecAgrNFCe>();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Serie: {0} Nr.:{1}", (Object[])new Object[]{this.getSerie(), this.getNumero()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidade) {
        this.unidadeFatCliente = unidade;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public NFCePeriodoEmissao getPeriodoEmissaoNFCe() {
        return this.periodoEmissaoNFCe;
    }

    @Generated
    public PeriodoEmissaoNFe getPeriodoEmissaoNFe() {
        return this.periodoEmissaoNFe;
    }

    @Generated
    public NFCeCaixa getNfCeCaixa() {
        return this.nfCeCaixa;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Short getIndicadorConsumidorFinal() {
        return this.indicadorConsumidorFinal;
    }

    @Generated
    public Short getIndicadorPresencaConsumidor() {
        return this.indicadorPresencaConsumidor;
    }

    @Generated
    public String getSerie() {
        return this.serie;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public Integer getNumeroRandomico() {
        return this.numeroRandomico;
    }

    @Generated
    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    @Generated
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    @Generated
    public Short getTipoEntSai() {
        return this.tipoEntSai;
    }

    @Generated
    public Short getFinalidadeEmissao() {
        return this.finalidadeEmissao;
    }

    @Generated
    public VersaoNFe getVersaoNfe() {
        return this.versaoNfe;
    }

    @Generated
    public SituacaoDocumento getSituacaoDocumento() {
        return this.situacaoDocumento;
    }

    @Generated
    public String getFormatoImpressao() {
        return this.formatoImpressao;
    }

    @Generated
    public Short getAmbiente() {
        return this.ambiente;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getNrProtocolo() {
        return this.nrProtocolo;
    }

    @Generated
    public NFCeTotalizadores getTotalizadores() {
        return this.totalizadores;
    }

    @Generated
    public NFCeTransp getDadosTransporte() {
        return this.dadosTransporte;
    }

    @Generated
    public NFCeEnderecoEntrega getEnderecoEntrega() {
        return this.enderecoEntrega;
    }

    @Generated
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    @Generated
    public String getVersaoAplicativo() {
        return this.versaoAplicativo;
    }

    @Generated
    public List<NFCeItem> getItens() {
        return this.itens;
    }

    @Generated
    public List<NFCePagamento> getPagamentos() {
        return this.pagamentos;
    }

    @Generated
    public NFCeControleCaixa getNfCeControleCaixa() {
        return this.nfCeControleCaixa;
    }

    @Generated
    public Representante getRepresentante() {
        return this.representante;
    }

    @Generated
    public NFCeLoteNotas getLoteNotas() {
        return this.loteNotas;
    }

    @Generated
    public String getChaveNFCe() {
        return this.chaveNFCe;
    }

    @Generated
    public String getIdentificadorCSCContribuinte() {
        return this.identificadorCSCContribuinte;
    }

    @Generated
    public String getCodigoCSCContribuinte() {
        return this.codigoCSCContribuinte;
    }

    @Generated
    public String getUrlQrCode() {
        return this.urlQrCode;
    }

    @Generated
    public String getUrlConsulta() {
        return this.urlConsulta;
    }

    @Generated
    public Integer getTipoEmissao() {
        return this.tipoEmissao;
    }

    @Generated
    public NFCeCancelamento getNfCeCancelamento() {
        return this.nfCeCancelamento;
    }

    @Generated
    public String getDigestValue() {
        return this.digestValue;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public Integer getTipoAmbiente() {
        return this.tipoAmbiente;
    }

    @Generated
    public Date getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    @Generated
    public ObjectObsDinamica getObjObsGeralContrib() {
        return this.objObsGeralContrib;
    }

    @Generated
    public String getObsGeralContrib() {
        return this.obsGeralContrib;
    }

    @Generated
    public ObjectObsDinamica getObjObsGeralFisco() {
        return this.objObsGeralFisco;
    }

    @Generated
    public String getObsGeralFisco() {
        return this.obsGeralFisco;
    }

    @Generated
    public NFCeConsumidor getNfCeConsumidor() {
        return this.nfCeConsumidor;
    }

    @Generated
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @Generated
    public InutilizacaoNumeracaoNFe getInutilizacaoNFe() {
        return this.inutilizacaoNFe;
    }

    @Generated
    public NFCeCancelamento getNfceCancelamentoAnterior() {
        return this.nfceCancelamentoAnterior;
    }

    @Generated
    public Pessoa getPessoaAutorizada() {
        return this.pessoaAutorizada;
    }

    @Generated
    public Date getDataPrevSaida() {
        return this.dataPrevSaida;
    }

    @Generated
    public NFCePessoa getNfcePessoa() {
        return this.nfcePessoa;
    }

    @Generated
    public List<LivroFiscal> getLivrosFiscais() {
        return this.livrosFiscais;
    }

    @Generated
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    @Generated
    public List<NFCeLogPermissaoUsuario> getLiberacoes() {
        return this.liberacoes;
    }

    @Generated
    public List<NFCeObsContrib> getObsContribuinte() {
        return this.obsContribuinte;
    }

    @Generated
    public List<NFCeObsFisco> getObsFisco() {
        return this.obsFisco;
    }

    @Generated
    public Pedido getPedido() {
        return this.pedido;
    }

    @Generated
    public byte[] getXml() {
        return this.xml;
    }

    @Generated
    public byte[] getXmlAutorizacao() {
        return this.xmlAutorizacao;
    }

    @Generated
    public List<NFCeVolume> getVolumes() {
        return this.volumes;
    }

    @Generated
    public String getPlacaVeiculo() {
        return this.placaVeiculo;
    }

    @Generated
    public Long getKm() {
        return this.km;
    }

    @Generated
    public Short getReprocessado() {
        return this.reprocessado;
    }

    @Generated
    public ClassificacaoClientes getClassificacaoCliente() {
        return this.classificacaoCliente;
    }

    @Generated
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    @Generated
    public Short getTipoIntermediadorComercial() {
        return this.tipoIntermediadorComercial;
    }

    @Generated
    public IntermediadorComercial getIntermediadorComercial() {
        return this.intermediadorComercial;
    }

    @Generated
    public String getVersaoPdv() {
        return this.versaoPdv;
    }

    @Generated
    public List<DadosRecAgrNFCe> getReceitasAgronomicas() {
        return this.receitasAgronomicas;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setPeriodoEmissaoNFCe(NFCePeriodoEmissao periodoEmissaoNFCe) {
        this.periodoEmissaoNFCe = periodoEmissaoNFCe;
    }

    @Generated
    public void setPeriodoEmissaoNFe(PeriodoEmissaoNFe periodoEmissaoNFe) {
        this.periodoEmissaoNFe = periodoEmissaoNFe;
    }

    @Generated
    public void setNfCeCaixa(NFCeCaixa nfCeCaixa) {
        this.nfCeCaixa = nfCeCaixa;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setIndicadorConsumidorFinal(Short indicadorConsumidorFinal) {
        this.indicadorConsumidorFinal = indicadorConsumidorFinal;
    }

    @Generated
    public void setIndicadorPresencaConsumidor(Short indicadorPresencaConsumidor) {
        this.indicadorPresencaConsumidor = indicadorPresencaConsumidor;
    }

    @Generated
    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setNumeroRandomico(Integer numeroRandomico) {
        this.numeroRandomico = numeroRandomico;
    }

    @Generated
    public void setDigitoVerificador(Integer digitoVerificador) {
        this.digitoVerificador = digitoVerificador;
    }

    @Generated
    public void setTipoEntSai(Short tipoEntSai) {
        this.tipoEntSai = tipoEntSai;
    }

    @Generated
    public void setFinalidadeEmissao(Short finalidadeEmissao) {
        this.finalidadeEmissao = finalidadeEmissao;
    }

    @Generated
    public void setVersaoNfe(VersaoNFe versaoNfe) {
        this.versaoNfe = versaoNfe;
    }

    @Generated
    public void setSituacaoDocumento(SituacaoDocumento situacaoDocumento) {
        this.situacaoDocumento = situacaoDocumento;
    }

    @Generated
    public void setFormatoImpressao(String formatoImpressao) {
        this.formatoImpressao = formatoImpressao;
    }

    @Generated
    public void setAmbiente(Short ambiente) {
        this.ambiente = ambiente;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setNrProtocolo(String nrProtocolo) {
        this.nrProtocolo = nrProtocolo;
    }

    @Generated
    public void setTotalizadores(NFCeTotalizadores totalizadores) {
        this.totalizadores = totalizadores;
    }

    @Generated
    public void setDadosTransporte(NFCeTransp dadosTransporte) {
        this.dadosTransporte = dadosTransporte;
    }

    @Generated
    public void setEnderecoEntrega(NFCeEnderecoEntrega enderecoEntrega) {
        this.enderecoEntrega = enderecoEntrega;
    }

    @Generated
    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Generated
    public void setVersaoAplicativo(String versaoAplicativo) {
        this.versaoAplicativo = versaoAplicativo;
    }

    @Generated
    public void setItens(List<NFCeItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setPagamentos(List<NFCePagamento> pagamentos) {
        this.pagamentos = pagamentos;
    }

    @Generated
    public void setNfCeControleCaixa(NFCeControleCaixa nfCeControleCaixa) {
        this.nfCeControleCaixa = nfCeControleCaixa;
    }

    @Generated
    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @Generated
    public void setLoteNotas(NFCeLoteNotas loteNotas) {
        this.loteNotas = loteNotas;
    }

    @Generated
    public void setChaveNFCe(String chaveNFCe) {
        this.chaveNFCe = chaveNFCe;
    }

    @Generated
    public void setIdentificadorCSCContribuinte(String identificadorCSCContribuinte) {
        this.identificadorCSCContribuinte = identificadorCSCContribuinte;
    }

    @Generated
    public void setCodigoCSCContribuinte(String codigoCSCContribuinte) {
        this.codigoCSCContribuinte = codigoCSCContribuinte;
    }

    @Generated
    public void setUrlQrCode(String urlQrCode) {
        this.urlQrCode = urlQrCode;
    }

    @Generated
    public void setUrlConsulta(String urlConsulta) {
        this.urlConsulta = urlConsulta;
    }

    @Generated
    public void setTipoEmissao(Integer tipoEmissao) {
        this.tipoEmissao = tipoEmissao;
    }

    @Generated
    public void setNfCeCancelamento(NFCeCancelamento nfCeCancelamento) {
        this.nfCeCancelamento = nfCeCancelamento;
    }

    @Generated
    public void setDigestValue(String digestValue) {
        this.digestValue = digestValue;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setTipoAmbiente(Integer tipoAmbiente) {
        this.tipoAmbiente = tipoAmbiente;
    }

    @Generated
    public void setDataAutorizacao(Date dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    @Generated
    public void setObjObsGeralContrib(ObjectObsDinamica objObsGeralContrib) {
        this.objObsGeralContrib = objObsGeralContrib;
    }

    @Generated
    public void setObsGeralContrib(String obsGeralContrib) {
        this.obsGeralContrib = obsGeralContrib;
    }

    @Generated
    public void setObjObsGeralFisco(ObjectObsDinamica objObsGeralFisco) {
        this.objObsGeralFisco = objObsGeralFisco;
    }

    @Generated
    public void setObsGeralFisco(String obsGeralFisco) {
        this.obsGeralFisco = obsGeralFisco;
    }

    @Generated
    public void setNfCeConsumidor(NFCeConsumidor nfCeConsumidor) {
        this.nfCeConsumidor = nfCeConsumidor;
    }

    @Generated
    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @Generated
    public void setInutilizacaoNFe(InutilizacaoNumeracaoNFe inutilizacaoNFe) {
        this.inutilizacaoNFe = inutilizacaoNFe;
    }

    @Generated
    public void setNfceCancelamentoAnterior(NFCeCancelamento nfceCancelamentoAnterior) {
        this.nfceCancelamentoAnterior = nfceCancelamentoAnterior;
    }

    @Generated
    public void setPessoaAutorizada(Pessoa pessoaAutorizada) {
        this.pessoaAutorizada = pessoaAutorizada;
    }

    @Generated
    public void setDataPrevSaida(Date dataPrevSaida) {
        this.dataPrevSaida = dataPrevSaida;
    }

    @Generated
    public void setNfcePessoa(NFCePessoa nfcePessoa) {
        this.nfcePessoa = nfcePessoa;
    }

    @Generated
    public void setLivrosFiscais(List<LivroFiscal> livrosFiscais) {
        this.livrosFiscais = livrosFiscais;
    }

    @Generated
    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Generated
    public void setLiberacoes(List<NFCeLogPermissaoUsuario> liberacoes) {
        this.liberacoes = liberacoes;
    }

    @Generated
    public void setObsContribuinte(List<NFCeObsContrib> obsContribuinte) {
        this.obsContribuinte = obsContribuinte;
    }

    @Generated
    public void setObsFisco(List<NFCeObsFisco> obsFisco) {
        this.obsFisco = obsFisco;
    }

    @Generated
    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @Generated
    public void setXml(byte[] xml) {
        this.xml = xml;
    }

    @Generated
    public void setXmlAutorizacao(byte[] xmlAutorizacao) {
        this.xmlAutorizacao = xmlAutorizacao;
    }

    @Generated
    public void setVolumes(List<NFCeVolume> volumes) {
        this.volumes = volumes;
    }

    @Generated
    public void setPlacaVeiculo(String placaVeiculo) {
        this.placaVeiculo = placaVeiculo;
    }

    @Generated
    public void setKm(Long km) {
        this.km = km;
    }

    @Generated
    public void setReprocessado(Short reprocessado) {
        this.reprocessado = reprocessado;
    }

    @Generated
    public void setClassificacaoCliente(ClassificacaoClientes classificacaoCliente) {
        this.classificacaoCliente = classificacaoCliente;
    }

    @Generated
    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @Generated
    public void setTipoIntermediadorComercial(Short tipoIntermediadorComercial) {
        this.tipoIntermediadorComercial = tipoIntermediadorComercial;
    }

    @Generated
    public void setIntermediadorComercial(IntermediadorComercial intermediadorComercial) {
        this.intermediadorComercial = intermediadorComercial;
    }

    @Generated
    public void setVersaoPdv(String versaoPdv) {
        this.versaoPdv = versaoPdv;
    }

    @Generated
    public void setReceitasAgronomicas(List<DadosRecAgrNFCe> receitasAgronomicas) {
        this.receitasAgronomicas = receitasAgronomicas;
    }
}

