/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.QueryWeb;
import com.touchcomp.basementor.annotations.QueryWebFields;
import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoRecursoNodo;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemaWEB;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoModulo;
import com.touchcomp.basementor.model.vo.SearchClassFieldNodo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="NODO")
@QueryWeb(idField="identificador", mask="{0} - {1}", fields={@QueryWebFields(fieldName="descricao")})
public class Nodo
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String singleReport;
    private String frameClass;
    private String listReport;
    private Short principal = EnumConstantsMentorSimNao.NAO.getValue();
    private Short bloqueado = EnumConstantsMentorSimNao.NAO.getValue();
    private Short bloqueadoDesktop;
    private Timestamp dataAtualizacao;
    private Integer indice = 0;
    private Long idChild;
    private List<Nodo> childrens;
    private Short possuiFilhos;
    private String pathWeb;
    private String voClasses;
    private ClassificacaoModulo classificacaoModulo;
    private Short permiteInserir;
    private Short permiteEditar;
    private Short permiteExcluir;
    private Short permiteExcluirTodos;
    private Short permiteClonar;
    private Short permitePesquisar;
    private Short possuiFiltrosFixos = EnumConstantsMentorSimNao.NAO.getValue();
    private List<SearchClassFieldNodo> filtrosFixos = new ArrayList<SearchClassFieldNodo>();
    private Date dataLiberacaoWeb;
    private Short tipoNodo;
    private Short tipoAcessoSistema;
    private Short utilizaCertificadoDigital;
    private Date dataUltimaModificacao;

    public Nodo() {
        this.childrens = new ArrayList<Nodo>();
        this.possuiFilhos = EnumConstantsMentorSimNao.NAO.getValue();
        this.permiteEditar = EnumConstantsMentorSimNao.SIM.getValue();
        this.permiteExcluir = EnumConstantsMentorSimNao.SIM.getValue();
        this.permiteExcluirTodos = EnumConstantsMentorSimNao.SIM.getValue();
        this.permiteClonar = EnumConstantsMentorSimNao.SIM.getValue();
        this.permitePesquisar = EnumConstantsMentorSimNao.SIM.getValue();
        this.permiteInserir = EnumConstantsMentorSimNao.SIM.getValue();
        this.bloqueadoDesktop = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoNodo = EnumConstTipoRecursoNodo.CRUD.getValue();
        this.tipoAcessoSistema = EnumConstTipoSistemaWEB.WEB.getValue();
        this.utilizaCertificadoDigital = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(name="ID_NODO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NODO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="REL_INDIVIDUAL", length=300)
    public String getSingleReport() {
        return this.singleReport;
    }

    public void setSingleReport(String relatorioIndividual) {
        this.singleReport = relatorioIndividual;
    }

    @Column(name="FRAME_CLASS", length=300)
    public String getFrameClass() {
        return this.frameClass;
    }

    public void setFrameClass(String frameClass) {
        this.frameClass = frameClass;
    }

    public String toString() {
        if (this.possuiFilhos != null && this.possuiFilhos == 1) {
            return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
        }
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public boolean equals(Object other) {
        if (!(other instanceof Nodo)) {
            return false;
        }
        Nodo castOther = (Nodo)other;
        if (castOther == null) {
            return false;
        }
        if (this.getIdentificador() == null || castOther.getIdentificador() == null) {
            return super.equals(other);
        }
        return new EqualsBuilder().append((Object)this.getIdentificador(), (Object)castOther.getIdentificador()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getIdentificador()).toHashCode();
    }

    @Column(name="LIST_REPORT", length=200)
    public String getListReport() {
        return this.listReport;
    }

    public void setListReport(String listReport) {
        this.listReport = listReport;
    }

    @Column(name="PRINCIPAL")
    public Short getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Short principal) {
        this.principal = principal;
    }

    @Column(name="BLOQUEADO")
    public Short getBloqueado() {
        return this.bloqueado;
    }

    public void setBloqueado(Short bloqueado) {
        this.bloqueado = bloqueado;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="INDICE")
    public Integer getIndice() {
        return this.indice;
    }

    public void setIndice(Integer indice) {
        this.indice = indice;
    }

    @Ignore
    @Column(updatable=false, name="ID_CHILD")
    public Long getIdChild() {
        return this.idChild;
    }

    public void setIdChild(Long idChild) {
        this.idChild = idChild;
    }

    @OneToMany(targetEntity=Nodo.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="ID_CHILD", foreignKey=@ForeignKey(name="FK_NODO_NODO"))
    public List<Nodo> getChildrens() {
        return this.childrens;
    }

    public void setChildrens(List<Nodo> childrens) {
        this.childrens = childrens;
    }

    @Column(name="POSSUI_FILHOS")
    public Short getPossuiFilhos() {
        return this.possuiFilhos;
    }

    public void setPossuiFilhos(Short possuiFilhos) {
        this.possuiFilhos = possuiFilhos;
    }

    @Column(name="PATH_WEB", length=500)
    public String getPathWeb() {
        return this.pathWeb;
    }

    public void setPathWeb(String pathWeb) {
        this.pathWeb = pathWeb;
    }

    @Column(name="VO_CLASSES", length=2000)
    public String getVoClasses() {
        return this.voClasses;
    }

    public void setVoClasses(String voClasses) {
        this.voClasses = voClasses;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_MODULO", foreignKey=@ForeignKey(name="FK_NODO_CLASS_MOD"))
    public ClassificacaoModulo getClassificacaoModulo() {
        return this.classificacaoModulo;
    }

    public void setClassificacaoModulo(ClassificacaoModulo classificacaoModulo) {
        this.classificacaoModulo = classificacaoModulo;
    }

    @Column(name="PERMITE_EDITAR")
    public Short getPermiteEditar() {
        return this.permiteEditar;
    }

    public void setPermiteEditar(Short permiteEditar) {
        this.permiteEditar = permiteEditar;
    }

    @Column(name="PERMITE_EXCLUIR")
    public Short getPermiteExcluir() {
        return this.permiteExcluir;
    }

    public void setPermiteExcluir(Short permiteExcluir) {
        this.permiteExcluir = permiteExcluir;
    }

    @Column(name="PERMITE_EXCLUIR_TODOS")
    public Short getPermiteExcluirTodos() {
        return this.permiteExcluirTodos;
    }

    public void setPermiteExcluirTodos(Short permiteExcluirTodos) {
        this.permiteExcluirTodos = permiteExcluirTodos;
    }

    @Column(name="PERMITE_CLONAR")
    public Short getPermiteClonar() {
        return this.permiteClonar;
    }

    public void setPermiteClonar(Short permiteClonar) {
        this.permiteClonar = permiteClonar;
    }

    @Column(name="PERMITE_PESQUISAR")
    public Short getPermitePesquisar() {
        return this.permitePesquisar;
    }

    public void setPermitePesquisar(Short permitePesquisar) {
        this.permitePesquisar = permitePesquisar;
    }

    @Column(name="PERMITE_INSERIR")
    public Short getPermiteInserir() {
        return this.permiteInserir;
    }

    public void setPermiteInserir(Short permiteInserir) {
        this.permiteInserir = permiteInserir;
    }

    @Column(name="possui_filtros_fixos")
    public Short getPossuiFiltrosFixos() {
        return this.possuiFiltrosFixos;
    }

    public void setPossuiFiltrosFixos(Short possuiFiltrosFixos) {
        this.possuiFiltrosFixos = possuiFiltrosFixos;
    }

    @OneToMany(mappedBy="nodo", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<SearchClassFieldNodo> getFiltrosFixos() {
        return this.filtrosFixos;
    }

    public void setFiltrosFixos(List<SearchClassFieldNodo> filtrosFixos) {
        this.filtrosFixos = filtrosFixos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIBERACAO_WEB")
    public Date getDataLiberacaoWeb() {
        return this.dataLiberacaoWeb;
    }

    public void setDataLiberacaoWeb(Date dataLiberacaoWeb) {
        this.dataLiberacaoWeb = dataLiberacaoWeb;
    }

    @Column(name="BLOQUEADO_DESKTOP")
    public Short getBloqueadoDesktop() {
        return this.bloqueadoDesktop;
    }

    public void setBloqueadoDesktop(Short bloqueadoDesktop) {
        this.bloqueadoDesktop = bloqueadoDesktop;
    }

    @Column(name="TIPO_NODO")
    public Short getTipoNodo() {
        return this.tipoNodo;
    }

    public void setTipoNodo(Short tipoNodo) {
        this.tipoNodo = tipoNodo;
    }

    @Column(name="UTILIZA_CERTIFICADO_DIGITAL")
    public Short getUtilizaCertificadoDigital() {
        return this.utilizaCertificadoDigital;
    }

    public void setUtilizaCertificadoDigital(Short utilizaCertificadoDigital) {
        this.utilizaCertificadoDigital = utilizaCertificadoDigital;
    }

    @Column(name="TIPO_ACESSO_SISTEMA")
    public Short getTipoAcessoSistema() {
        return this.tipoAcessoSistema;
    }

    public void setTipoAcessoSistema(Short tipoAcessoSistema) {
        this.tipoAcessoSistema = tipoAcessoSistema;
    }

    @Column(name="data_ultima_modificacao")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataUltimaModificacao() {
        return this.dataUltimaModificacao;
    }

    public void setDataUltimaModificacao(Date dataUltimaModificacao) {
        this.dataUltimaModificacao = dataUltimaModificacao;
    }
}

