/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.obsfaturamento.EnumConstObsFaturamentoTipo;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="OBS_FATURAMENTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_OBS_FATURAMENTO", columnNames={"NOME"})})
public class ObsFaturamento
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private String observacao;
    private Empresa empresa;
    private Date dataCadastro;
    private Short ativo = 1;
    private Timestamp dataAtualizacao;
    private Short tipoObsNormalDinamica = EnumConstObsFaturamentoTipo.OBS_NORMAL.getValue();
    private ObjectObsDinamica observacaoDinamica;
    private String chave;

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{ToolMethods.isStrWithData((String)this.getChave()) ? this.getChave() : this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="NOME", length=100)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @Column(nullable=false, name="CONTEUDO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OBS_FATURAMENTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Id
    @Column(name="ID_OBS_FATURAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OBS_FATURAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="TIPO_OBS_NORMAL_DINAMICA")
    public Short getTipoObsNormalDinamica() {
        return this.tipoObsNormalDinamica;
    }

    public void setTipoObsNormalDinamica(Short tipoObsNormalDinamica) {
        this.tipoObsNormalDinamica = tipoObsNormalDinamica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBSERVACAO_DINAMICA", foreignKey=@ForeignKey(name="FK_OBS_FATURAMENTO_OBJ_OB_DIN"))
    public ObjectObsDinamica getObservacaoDinamica() {
        return this.observacaoDinamica;
    }

    public void setObservacaoDinamica(ObjectObsDinamica observacaoDinamica) {
        this.observacaoDinamica = observacaoDinamica;
    }

    @Column(name="chave", length=20)
    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }
}

