/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="OPCOES_CTF", uniqueConstraints={@UniqueConstraint(name="UNQ1_OPCOES_CTF", columnNames={"ID_EMPRESA"})})
public class OpcoesCtf
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private CategoriaPessoa categoriaPessoaFornec;
    private Short sincronizarCtf = 0;
    private String login;
    private String senha;
    private Long codigoCopiaAbastecimento = 0L;
    private Long ponteiroAbastecimento = 0L;
    private Long quantRegistroAbastecimento = 0L;
    private Long codigoCopiaPosto = 0L;
    private Long ponteiroPosto = 0L;
    private Long quantRegistroPosto = 0L;
    private ServidorEmail servidorEmail;
    private String destinatariosEmail;
    private Short criarColeta = 0;
    private TipoPontoControle tipoPontoControleColeta;

    @Id
    @Column(name="ID_OPCOES_CTF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_CTF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_CTF_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA_FORNEC", foreignKey=@ForeignKey(name="FK_OPCOES_CTF_CAT_PES_FORN"))
    public CategoriaPessoa getCategoriaPessoaFornec() {
        return this.categoriaPessoaFornec;
    }

    public void setCategoriaPessoaFornec(CategoriaPessoa categoriaPessoaFornec) {
        this.categoriaPessoaFornec = categoriaPessoaFornec;
    }

    @Column(name="SINCRONIZAR_CTF")
    public Short getSincronizarCtf() {
        return this.sincronizarCtf;
    }

    public void setSincronizarCtf(Short sincronizarCtf) {
        this.sincronizarCtf = sincronizarCtf;
    }

    @Column(name="LOGIN", length=50)
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Column(name="SENHA", length=50)
    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Column(name="CODIGO_COPIA_ABASTECIMENTO")
    public Long getCodigoCopiaAbastecimento() {
        return this.codigoCopiaAbastecimento;
    }

    public void setCodigoCopiaAbastecimento(Long codigoCopiaAbastecimento) {
        this.codigoCopiaAbastecimento = codigoCopiaAbastecimento;
    }

    @Column(name="PONTEIRO_ABASTECIMENTO")
    public Long getPonteiroAbastecimento() {
        return this.ponteiroAbastecimento;
    }

    public void setPonteiroAbastecimento(Long ponteiroAbastecimento) {
        this.ponteiroAbastecimento = ponteiroAbastecimento;
    }

    @Column(name="QUANT_REGISTRO_ABASTECIMENTO")
    public Long getQuantRegistroAbastecimento() {
        return this.quantRegistroAbastecimento;
    }

    public void setQuantRegistroAbastecimento(Long quantRegistroAbastecimento) {
        this.quantRegistroAbastecimento = quantRegistroAbastecimento;
    }

    @Column(name="CODIGO_COPIA_POSTO")
    public Long getCodigoCopiaPosto() {
        return this.codigoCopiaPosto;
    }

    public void setCodigoCopiaPosto(Long codigoCopiaPosto) {
        this.codigoCopiaPosto = codigoCopiaPosto;
    }

    @Column(name="PONTEIRO_POSTO")
    public Long getPonteiroPosto() {
        return this.ponteiroPosto;
    }

    public void setPonteiroPosto(Long ponteiroPosto) {
        this.ponteiroPosto = ponteiroPosto;
    }

    @Column(name="QUANT_REGISTRO_POSTO")
    public Long getQuantRegistroPosto() {
        return this.quantRegistroPosto;
    }

    public void setQuantRegistroPosto(Long quantRegistroPosto) {
        this.quantRegistroPosto = quantRegistroPosto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVIDOR_EMAIL", foreignKey=@ForeignKey(name="FK_OPCOES_CTF_SERV_EMAIL"))
    public ServidorEmail getServidorEmail() {
        return this.servidorEmail;
    }

    public void setServidorEmail(ServidorEmail servidorEmail) {
        this.servidorEmail = servidorEmail;
    }

    @Column(name="DESTINATARIOS_EMAIL", length=500)
    public String getDestinatariosEmail() {
        return this.destinatariosEmail;
    }

    public void setDestinatariosEmail(String destinatariosEmail) {
        this.destinatariosEmail = destinatariosEmail;
    }

    @Column(name="CRIAR_COLETA")
    public Short getCriarColeta() {
        return this.criarColeta;
    }

    public void setCriarColeta(Short criarColeta) {
        this.criarColeta = criarColeta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PONTO_CONTROLE", foreignKey=@ForeignKey(name="FK_OPCOES_CTF_TIPO_PONTO_CON"))
    public TipoPontoControle getTipoPontoControleColeta() {
        return this.tipoPontoControleColeta;
    }

    public void setTipoPontoControleColeta(TipoPontoControle tipoPontoControleColeta) {
        this.tipoPontoControleColeta = tipoPontoControleColeta;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

