/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.RamoAtividade;
import com.touchcomp.basementor.model.vo.Regiao;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="OPCOES_E_COMMERCE")
public class OpcoesECommerce
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private RamoAtividade ramoAtividade;
    private Regiao regiao;
    private CategoriaPessoa categoriaPessoa;
    private ClassificacaoClientes classificacaoClientes;
    private Transportador transportador;
    private TipoFrete tipoFrete;
    private CondicoesPagamento condicoesPagamento;
    private Representante representante;
    private NaturezaOperacao naturezaOperacaoPref;
    private MeioPagamento meioPagamentoPadrao;
    private Short gerarTitulosImportacaoPedidos = 0;
    private Usuario usuario;
    private SituacaoPedidos situacaoPedido;
    private NaturezaOperacao naturezaOperacaoNF;
    private CondicoesPagamento condicoesPagamentoNF;
    private CentroEstoque centroEstoqueNF;
    private Short respeitarImpostosXML = 0;
    private ObsFaturamento obsFaturamentoNF;
    private NaturezaOperacao naturezaOperacaoDevNF;

    @Id
    @Column(nullable=false, unique=true, name="ID_OPCOES_E_COMMERCE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_E_COMMERCE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_E_COMMERCE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RAMO_ATIVIDADE", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_RAMO_ATIV"))
    public RamoAtividade getRamoAtividade() {
        return this.ramoAtividade;
    }

    public void setRamoAtividade(RamoAtividade ramoAtividade) {
        this.ramoAtividade = ramoAtividade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIAO", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_REGIAO"))
    public Regiao getRegiao() {
        return this.regiao;
    }

    public void setRegiao(Regiao regiao) {
        this.regiao = regiao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIF_CLIENTES", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_CLASSIF_CLI"))
    public ClassificacaoClientes getClassificacaoClientes() {
        return this.classificacaoClientes;
    }

    public void setClassificacaoClientes(ClassificacaoClientes classificacaoClientes) {
        this.classificacaoClientes = classificacaoClientes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_TRANSPORTADOR"))
    public Transportador getTransportador() {
        return this.transportador;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_TIPO_FRETE"))
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_REPRESENTANTE"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NAT_OPERACAO_PREF", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_NAT_OPER"))
    public NaturezaOperacao getNaturezaOperacaoPref() {
        return this.naturezaOperacaoPref;
    }

    public void setNaturezaOperacaoPref(NaturezaOperacao naturezaOperacaoPref) {
        this.naturezaOperacaoPref = naturezaOperacaoPref;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO_PADRAO", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_MEIO_PAG"))
    public MeioPagamento getMeioPagamentoPadrao() {
        return this.meioPagamentoPadrao;
    }

    public void setMeioPagamentoPadrao(MeioPagamento meioPagamentoPadrao) {
        this.meioPagamentoPadrao = meioPagamentoPadrao;
    }

    @Column(name="GERAR_TITULO_IMP_PEDIDO")
    public Short getGerarTitulosImportacaoPedidos() {
        return this.gerarTitulosImportacaoPedidos;
    }

    public void setGerarTitulosImportacaoPedidos(Short gerarTitulosImportacaoPedidos) {
        this.gerarTitulosImportacaoPedidos = gerarTitulosImportacaoPedidos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_PEDIDO", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_SIT_PEDIDO"))
    public SituacaoPedidos getSituacaoPedido() {
        return this.situacaoPedido;
    }

    public void setSituacaoPedido(SituacaoPedidos situacaoPedido) {
        this.situacaoPedido = situacaoPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NAT_OPERACAO_NF", foreignKey=@ForeignKey(name="FK_OPCOES_E_COMMERCE_NAT_OP_NF"))
    public NaturezaOperacao getNaturezaOperacaoNF() {
        return this.naturezaOperacaoNF;
    }

    public void setNaturezaOperacaoNF(NaturezaOperacao naturezaOperacaoNF) {
        this.naturezaOperacaoNF = naturezaOperacaoNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COND_PAGAMENTO_NF", foreignKey=@ForeignKey(name="FK_OPCOES_E_COMMERCE_CON_PAG_NF"))
    public CondicoesPagamento getCondicoesPagamentoNF() {
        return this.condicoesPagamentoNF;
    }

    public void setCondicoesPagamentoNF(CondicoesPagamento condicoesPagamentoNF) {
        this.condicoesPagamentoNF = condicoesPagamentoNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE_NF", foreignKey=@ForeignKey(name="FK_OPCOES_E_COMMERCE_CEN_EST_NF"))
    public CentroEstoque getCentroEstoqueNF() {
        return this.centroEstoqueNF;
    }

    public void setCentroEstoqueNF(CentroEstoque centroEstoqueNF) {
        this.centroEstoqueNF = centroEstoqueNF;
    }

    @Column(name="RESPEITAR_IMPOSTOS_XML")
    public Short getRespeitarImpostosXML() {
        return this.respeitarImpostosXML;
    }

    public void setRespeitarImpostosXML(Short respeitarImpostosXML) {
        this.respeitarImpostosXML = respeitarImpostosXML;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBS_FATURAMENTO_NF", foreignKey=@ForeignKey(name="FK_OPCOES_E_COMMERCE_OBS_FAT_NF"))
    public ObsFaturamento getObsFaturamentoNF() {
        return this.obsFaturamentoNF;
    }

    public void setObsFaturamentoNF(ObsFaturamento obsFaturamentoNF) {
        this.obsFaturamentoNF = obsFaturamentoNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NAT_OPERACAO_DEV_NF", foreignKey=@ForeignKey(name="FK_OP_E_COMMERCE_NAT_OP_DEV"))
    public NaturezaOperacao getNaturezaOperacaoDevNF() {
        return this.naturezaOperacaoDevNF;
    }

    public void setNaturezaOperacaoDevNF(NaturezaOperacao naturezaOperacaoDevNF) {
        this.naturezaOperacaoDevNF = naturezaOperacaoDevNF;
    }
}

