/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasOp;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="OPCOES_FINANCEIRAS", uniqueConstraints={@UniqueConstraint(name="UNQ1_OPCOES_FINANCEIRAS", columnNames={"ID_EMPRESA"})})
public class OpcoesFinanceiras
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Short bloquearBaixaPAgMaior;
    private Short bloquearBaixaDescMaior;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short incluirChequeAnCred;
    private Short incluirPedAbertoAnCred;
    private Short verificaLimitePedido;
    private Short verificaLimiteExpedicao;
    private Short verificaLimiteSaida;
    private Short verificaLimiteNFPropria;
    private Short verificaLimiteFaturamento;
    private Short verificaLimiteCte;
    private Short verificaLimitePlanProd;
    private Short verificaLimiteSitPed;
    private Short verificaLimiteLibPed;
    private TipoDoc tipoDocFinanceiroGuiaGnre;
    private TipoDoc tipoDocFinanceiro;
    private TipoDoc tipoDocFinanceiroFolhaPagamento;
    private TipoDoc tipoDocFinanceiroTituloCartao;
    private CarteiraCobranca carteiraCobranca;
    private CarteiraCobranca carteiraCobrancaTitPag;
    private CarteiraCobranca carteiraCobrancaChequeDev;
    private CarteiraCobranca carteiraCobrancaDestino;
    private Double percJurosMes = 0.0;
    private Double percDescMes = 0.0;
    private Double valorDespesaBancaria = 0.0;
    private Short bloquearTitulos;
    private Short visualizarTitulosOutrasEmpresas;
    private Short visualizarTitulosOutrasEmpRec;
    private Short agruparBaixaCnab;
    private BusinessIntelligence biVincBaixa;
    private Double percMulta = 0.0;
    private Short gerarTitulosEventosFolha;
    private ModeloEmail modeloEmailEnvioMassa;
    private ServidorEmail servidorEmailEnvioMassa;
    private Short enviarCopiaEmail;
    private String emailCopia;
    private Short liberarBaixasCartao;
    private Short editarBaixaPorCnab;
    private Short tipoDataAnaliseCredito;
    private Short verificaLimiteCotacaoVendas;
    private Short gerarTitChequeDev;
    private Short sugerirTitulosDiaBaixa;
    private Short permitirVendaComDebito;
    private Short tipoAnaliseCreditoCliente = 0;
    private Integer diasToleranciaAnaliseCredito = 0;
    private Short tipoNumeroTitulo;
    private Short tipoAtualizacaoBoleto = 0;
    private Short gerarLogCnabAtBoleto;
    private MeioPagamento meioPagamento;
    private MeioPagamento meioPagamentoFolha;
    private Short bloqPagamentoOutrosBancos;
    private Short bloquearAlterarTituloBaixado;
    private Short permitirRenegociacaoValorTituloDiferente;
    private Short permitirAlterarTitulo;
    private Short permitirAlterarPlanoContaTitulo;
    private Short infomarParcelaTituloNotaFiscal;
    private Short salvarLogDadosFinCli;
    private Short exibirTotalizadorBaixa;
    private Short tipoAlteracaoBaixa = 0;
    private Short visualizarSaldosMovFinancOutEmp;
    private List<OpcoesFinanceirasTaxas> taxas;
    private Short validarCartTitContaVlrBaixaPag;
    private Short validarCartTitContaVlrBaixaRec;
    private Short exibirBaixaNrDoc;
    private Short exibirBaixaNrTitulo;
    private Short exibirBaixaPessoa;
    private Short exibirBaixaDataEmissao;
    private Short exibirBaixaDataVencimento;
    private Short exibirBaixaValorTitulo;
    private Short exibirBaixaSaldo;
    private Short exibirBaixaValorJuros;
    private Short exibirBaixaValorMulta;
    private Short exibirBaixaValorDesconto;
    private Short exibirTipoDocFinanceiro;
    private MeioPagamento meioPagamentoTituloRetido;
    private Short pesqTodosTitAntBaixaIndPessoa;
    private Short bloquearLancTitDtEmiVenc;
    private MeioPagamento meioPagamentoChequeDev;
    private TipoDoc tipoDocFinanceiroChequeDev;
    private Double toleranciaValorMovimentoFinanceiro = 0.0;
    private ClassificacaoClientes classificacaoClientes;
    private Short enviarBoletoJuntoNFe;
    private Short naoDescBaixaComRepres;
    private Short permEditarCenResultMovFin;
    private Short descontarIcmsDesoneradoComissao = EnumConstantsMentorSimNao.NAO.getValue();
    private Short verificaLimitePreVenda;
    private Short gerarCupomDescontoDevolucaoVenda;
    private Short gerarEstornoComissaoApuracaoCooperado;
    private Short incluirValoresAcessoriosBCComissaoTitulo;
    private Short incluirValoresDescontosBCComissaoTitulo;
    private Short bloquearCampoEstornoComissaoDevolucaoVendas;
    private List<OpcoesFinanceirasOp> opcoesFinanceirasOp;

    public OpcoesFinanceiras() {
        this.exibirTipoDocFinanceiro = EnumConstantsMentorSimNao.NAO.getValue();
        this.incluirPedAbertoAnCred = EnumConstantsMentorSimNao.NAO.getValue();
        this.agruparBaixaCnab = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteSitPed = EnumConstantsMentorSimNao.NAO.getValue();
        this.permitirAlterarTitulo = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarTitulosEventosFolha = EnumConstantsMentorSimNao.NAO.getValue();
        this.liberarBaixasCartao = EnumConstantsMentorSimNao.NAO.getValue();
        this.pesqTodosTitAntBaixaIndPessoa = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoDataAnaliseCredito = EnumConstantsMentorSimNao.NAO.getValue();
        this.sugerirTitulosDiaBaixa = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimitePlanProd = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteLibPed = EnumConstantsMentorSimNao.NAO.getValue();
        this.bloquearBaixaPAgMaior = EnumConstantsMentorSimNao.NAO.getValue();
        this.bloquearBaixaDescMaior = EnumConstantsMentorSimNao.NAO.getValue();
        this.incluirChequeAnCred = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimitePedido = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteExpedicao = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteSaida = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteNFPropria = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteFaturamento = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteCte = EnumConstantsMentorSimNao.NAO.getValue();
        this.bloquearTitulos = EnumConstantsMentorSimNao.NAO.getValue();
        this.visualizarTitulosOutrasEmpresas = EnumConstantsMentorSimNao.NAO.getValue();
        this.visualizarTitulosOutrasEmpRec = EnumConstantsMentorSimNao.NAO.getValue();
        this.enviarCopiaEmail = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimiteCotacaoVendas = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarTitChequeDev = EnumConstantsMentorSimNao.NAO.getValue();
        this.permitirVendaComDebito = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoNumeroTitulo = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarLogCnabAtBoleto = EnumConstantsMentorSimNao.NAO.getValue();
        this.bloquearAlterarTituloBaixado = EnumConstantsMentorSimNao.SIM.getValue();
        this.bloqPagamentoOutrosBancos = EnumConstantsMentorSimNao.SIM.getValue();
        this.permitirRenegociacaoValorTituloDiferente = EnumConstantsMentorSimNao.SIM.getValue();
        this.permitirAlterarPlanoContaTitulo = EnumConstantsMentorSimNao.NAO.getValue();
        this.infomarParcelaTituloNotaFiscal = EnumConstantsMentorSimNao.NAO.getValue();
        this.salvarLogDadosFinCli = EnumConstantsMentorSimNao.NAO.getValue();
        this.exibirTotalizadorBaixa = EnumConstantsMentorSimNao.NAO.getValue();
        this.visualizarSaldosMovFinancOutEmp = EnumConstantsMentorSimNao.NAO.getValue();
        this.validarCartTitContaVlrBaixaRec = EnumConstantsMentorSimNao.NAO.getValue();
        this.validarCartTitContaVlrBaixaPag = EnumConstantsMentorSimNao.NAO.getValue();
        this.taxas = new ArrayList<OpcoesFinanceirasTaxas>();
        this.exibirBaixaNrDoc = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaNrTitulo = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaPessoa = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaDataEmissao = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaDataVencimento = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaValorTitulo = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaSaldo = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaValorJuros = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaValorMulta = EnumConstantsMentorSimNao.SIM.getValue();
        this.exibirBaixaValorDesconto = EnumConstantsMentorSimNao.SIM.getValue();
        this.bloquearLancTitDtEmiVenc = EnumConstantsMentorSimNao.SIM.getValue();
        this.editarBaixaPorCnab = EnumConstantsMentorSimNao.NAO.getValue();
        this.exibirTipoDocFinanceiro = EnumConstantsMentorSimNao.NAO.getValue();
        this.enviarBoletoJuntoNFe = EnumConstantsMentorSimNao.NAO.getValue();
        this.naoDescBaixaComRepres = EnumConstantsMentorSimNao.NAO.getValue();
        this.permEditarCenResultMovFin = EnumConstantsMentorSimNao.NAO.getValue();
        this.verificaLimitePreVenda = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarCupomDescontoDevolucaoVenda = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarEstornoComissaoApuracaoCooperado = EnumConstantsMentorSimNao.NAO.getValue();
        this.incluirValoresAcessoriosBCComissaoTitulo = EnumConstantsMentorSimNao.NAO.getValue();
        this.incluirValoresDescontosBCComissaoTitulo = EnumConstantsMentorSimNao.NAO.getValue();
        this.bloquearCampoEstornoComissaoDevolucaoVendas = EnumConstantsMentorSimNao.NAO.getValue();
        this.opcoesFinanceirasOp = new ArrayList<OpcoesFinanceirasOp>();
    }

    @Id
    @Column(nullable=false, name="ID_OPCAO_FINANCEIRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCAO_FINANCEIRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="BLOQUEAR_BAIXA_DESC_MAIOR")
    public Short getBloquearBaixaDescMaior() {
        return this.bloquearBaixaDescMaior;
    }

    public void setBloquearBaixaDescMaior(Short bloquearBaixaDescMaior) {
        this.bloquearBaixaDescMaior = bloquearBaixaDescMaior;
    }

    @Column(name="BLOQUEAR_BAIXA_PAG_MAIOR")
    public Short getBloquearBaixaPAgMaior() {
        return this.bloquearBaixaPAgMaior;
    }

    public void setBloquearBaixaPAgMaior(Short bloquearBaixaPAgMaior) {
        this.bloquearBaixaPAgMaior = bloquearBaixaPAgMaior;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="INCLUIR_CHEQUE_AN_CRED")
    public Short getIncluirChequeAnCred() {
        return this.incluirChequeAnCred;
    }

    public void setIncluirChequeAnCred(Short incluirChequeAnCred) {
        this.incluirChequeAnCred = incluirChequeAnCred;
    }

    @Column(name="VERIFICA_LIMITE_PEDIDO")
    public Short getVerificaLimitePedido() {
        return this.verificaLimitePedido;
    }

    public void setVerificaLimitePedido(Short verificaLimitePedido) {
        this.verificaLimitePedido = verificaLimitePedido;
    }

    @Column(name="VERIFICA_LIMITE_EXPEDICAO")
    public Short getVerificaLimiteExpedicao() {
        return this.verificaLimiteExpedicao;
    }

    public void setVerificaLimiteExpedicao(Short verificaLimiteExpedicao) {
        this.verificaLimiteExpedicao = verificaLimiteExpedicao;
    }

    @Column(name="VERIFICA_LIMITE_SAIDA")
    public Short getVerificaLimiteSaida() {
        return this.verificaLimiteSaida;
    }

    public void setVerificaLimiteSaida(Short verificaLimiteSaida) {
        this.verificaLimiteSaida = verificaLimiteSaida;
    }

    @Column(name="VERIFICA_LIMITE_NF_PROPRIA")
    public Short getVerificaLimiteNFPropria() {
        return this.verificaLimiteNFPropria;
    }

    public void setVerificaLimiteNFPropria(Short verificaLimiteNFPropria) {
        this.verificaLimiteNFPropria = verificaLimiteNFPropria;
    }

    @JoinColumn(name="ID_TIPO_DOC_FIN_GNRE", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_TP_D_GNRE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoDoc getTipoDocFinanceiroGuiaGnre() {
        return this.tipoDocFinanceiroGuiaGnre;
    }

    public void setTipoDocFinanceiroGuiaGnre(TipoDoc tipoDocFinanceiroGuiaGnre) {
        this.tipoDocFinanceiroGuiaGnre = tipoDocFinanceiroGuiaGnre;
    }

    @JoinColumn(name="ID_TIPO_DOC_FINANCEIRO", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_TP_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoDoc getTipoDocFinanceiro() {
        return this.tipoDocFinanceiro;
    }

    public void setTipoDocFinanceiro(TipoDoc tipoDocFinanceiro) {
        this.tipoDocFinanceiro = tipoDocFinanceiro;
    }

    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_CART_COBR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @Column(nullable=false, name="PERC_JUROS_MES", precision=15, scale=2)
    public Double getPercJurosMes() {
        return this.percJurosMes;
    }

    public void setPercJurosMes(Double percJurosMes) {
        this.percJurosMes = percJurosMes;
    }

    @Column(name="PERC_DESC_MES", precision=15, scale=2)
    public Double getPercDescMes() {
        return this.percDescMes;
    }

    public void setPercDescMes(Double percDescMes) {
        this.percDescMes = percDescMes;
    }

    @Column(name="VERIFICA_LIMITE_FATURAMENTO")
    public Short getVerificaLimiteFaturamento() {
        return this.verificaLimiteFaturamento;
    }

    public void setVerificaLimiteFaturamento(Short verificaLimiteFaturamento) {
        this.verificaLimiteFaturamento = verificaLimiteFaturamento;
    }

    @Column(name="VERIFICA_LIMITE_CTE")
    public Short getVerificaLimiteCte() {
        return this.verificaLimiteCte;
    }

    public void setVerificaLimiteCte(Short verificaLimiteCte) {
        this.verificaLimiteCte = verificaLimiteCte;
    }

    @Column(name="BLOQUEAR_TITULOS")
    public Short getBloquearTitulos() {
        return this.bloquearTitulos;
    }

    public void setBloquearTitulos(Short bloquearTitulos) {
        this.bloquearTitulos = bloquearTitulos;
    }

    @Column(name="VISUALIZAR_TITULO_OUTRA_EMPRESA")
    public Short getVisualizarTitulosOutrasEmpresas() {
        return this.visualizarTitulosOutrasEmpresas;
    }

    public void setVisualizarTitulosOutrasEmpresas(Short visualizarTitulosOutrasEmpresas) {
        this.visualizarTitulosOutrasEmpresas = visualizarTitulosOutrasEmpresas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC_FOLHA", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_TP_D_FOLH"))
    public TipoDoc getTipoDocFinanceiroFolhaPagamento() {
        return this.tipoDocFinanceiroFolhaPagamento;
    }

    public void setTipoDocFinanceiroFolhaPagamento(TipoDoc tipoDocFinanceiroFolhaPagamento) {
        this.tipoDocFinanceiroFolhaPagamento = tipoDocFinanceiroFolhaPagamento;
    }

    @Column(name="AGRUPAR_BAIXA_CNAB")
    public Short getAgruparBaixaCnab() {
        return this.agruparBaixaCnab;
    }

    public void setAgruparBaixaCnab(Short agruparBaixaCnab) {
        this.agruparBaixaCnab = agruparBaixaCnab;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BI_VINC_BAIXA", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_BI"))
    public BusinessIntelligence getBiVincBaixa() {
        return this.biVincBaixa;
    }

    public void setBiVincBaixa(BusinessIntelligence biVincBaixa) {
        this.biVincBaixa = biVincBaixa;
    }

    @Column(nullable=false, name="PERC_MULTA", precision=15, scale=2)
    public Double getPercMulta() {
        return this.percMulta;
    }

    public void setPercMulta(Double percMulta) {
        this.percMulta = percMulta;
    }

    @Column(name="GERAR_TITULOS_EVENTO_FOLHA")
    public Short getGerarTitulosEventosFolha() {
        return this.gerarTitulosEventosFolha;
    }

    public void setGerarTitulosEventosFolha(Short gerarTitulosEventosFolha) {
        this.gerarTitulosEventosFolha = gerarTitulosEventosFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_EMAIL_ENVIO_MASSA", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_MOD_EMAIL"))
    public ModeloEmail getModeloEmailEnvioMassa() {
        return this.modeloEmailEnvioMassa;
    }

    public void setModeloEmailEnvioMassa(ModeloEmail modeloEmailEnvioMassa) {
        this.modeloEmailEnvioMassa = modeloEmailEnvioMassa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVIDOR_EMAIL_ENVIO_MASSA", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_SER_EMAIL"))
    public ServidorEmail getServidorEmailEnvioMassa() {
        return this.servidorEmailEnvioMassa;
    }

    public void setServidorEmailEnvioMassa(ServidorEmail servidorEmailEnvioMassa) {
        this.servidorEmailEnvioMassa = servidorEmailEnvioMassa;
    }

    @Column(name="ENVIAR_COPIA_EMAIL")
    public Short getEnviarCopiaEmail() {
        return this.enviarCopiaEmail;
    }

    public void setEnviarCopiaEmail(Short enviarCopiaEmail) {
        this.enviarCopiaEmail = enviarCopiaEmail;
    }

    @Column(name="EMAIL_COPIA", length=200)
    public String getEmailCopia() {
        return this.emailCopia;
    }

    public void setEmailCopia(String emailCopia) {
        this.emailCopia = emailCopia;
    }

    @Column(name="LIBERAR_BAIXAS_CARTAO")
    public Short getLiberarBaixasCartao() {
        return this.liberarBaixasCartao;
    }

    public void setLiberarBaixasCartao(Short liberarBaixasCartao) {
        this.liberarBaixasCartao = liberarBaixasCartao;
    }

    @Column(name="EDITAR_BAIXA_POR_CNAB")
    public Short getEditarBaixaPorCnab() {
        return this.editarBaixaPorCnab;
    }

    public void setEditarBaixaPorCnab(Short editarBaixaPorCnab) {
        this.editarBaixaPorCnab = editarBaixaPorCnab;
    }

    @Column(name="TIPO_DATA_ANALISE_CRED")
    public Short getTipoDataAnaliseCredito() {
        return this.tipoDataAnaliseCredito;
    }

    public void setTipoDataAnaliseCredito(Short tipoDataAnaliseCredito) {
        this.tipoDataAnaliseCredito = tipoDataAnaliseCredito;
    }

    @Column(nullable=false, name="VALOR_DESPESA_BANCARIA", precision=15, scale=2)
    public Double getValorDespesaBancaria() {
        return this.valorDespesaBancaria;
    }

    public void setValorDespesaBancaria(Double valorDespesaBancaria) {
        this.valorDespesaBancaria = valorDespesaBancaria;
    }

    @Column(name="VERIFICA_LIMITE_COTACAO_VENDAS")
    public Short getVerificaLimiteCotacaoVendas() {
        return this.verificaLimiteCotacaoVendas;
    }

    public void setVerificaLimiteCotacaoVendas(Short verificaLimiteCotacaoVendas) {
        this.verificaLimiteCotacaoVendas = verificaLimiteCotacaoVendas;
    }

    @Column(name="GERAR_TIT_CHEQUE_DEV")
    public Short getGerarTitChequeDev() {
        return this.gerarTitChequeDev;
    }

    public void setGerarTitChequeDev(Short gerarTitChequeDev) {
        this.gerarTitChequeDev = gerarTitChequeDev;
    }

    @Column(name="SUGERIR_TITULOS_DIA_BAIXA")
    public Short getSugerirTitulosDiaBaixa() {
        return this.sugerirTitulosDiaBaixa;
    }

    public void setSugerirTitulosDiaBaixa(Short sugerirTitulosDiaBaixa) {
        this.sugerirTitulosDiaBaixa = sugerirTitulosDiaBaixa;
    }

    @Column(name="PERMITIR_VENDA_COM_DEBITO")
    public Short getPermitirVendaComDebito() {
        return this.permitirVendaComDebito;
    }

    public void setPermitirVendaComDebito(Short permitirVendaComDebito) {
        this.permitirVendaComDebito = permitirVendaComDebito;
    }

    @Column(name="TIPO_ANALISE_CRED_CLIENTE")
    public Short getTipoAnaliseCreditoCliente() {
        return this.tipoAnaliseCreditoCliente;
    }

    public void setTipoAnaliseCreditoCliente(Short tipoAnaliseCreditoCliente) {
        this.tipoAnaliseCreditoCliente = tipoAnaliseCreditoCliente;
    }

    @Column(name="TIPO_NUMERO_TITULO")
    public Short getTipoNumeroTitulo() {
        return this.tipoNumeroTitulo;
    }

    public void setTipoNumeroTitulo(Short tipoNumeroTitulo) {
        this.tipoNumeroTitulo = tipoNumeroTitulo;
    }

    @Column(name="DIAS_TOLERANCIA_ANALISE_CRED")
    public Integer getDiasToleranciaAnaliseCredito() {
        return this.diasToleranciaAnaliseCredito;
    }

    public void setDiasToleranciaAnaliseCredito(Integer diasToleranciaAnaliseCredito) {
        this.diasToleranciaAnaliseCredito = diasToleranciaAnaliseCredito;
    }

    @Column(name="TIPO_ATUALIZACAO_BOLETO")
    public Short getTipoAtualizacaoBoleto() {
        return this.tipoAtualizacaoBoleto;
    }

    public void setTipoAtualizacaoBoleto(Short tipoAtualizacaoBoleto) {
        this.tipoAtualizacaoBoleto = tipoAtualizacaoBoleto;
    }

    @Column(name="GERAR_LOG_CNAB_AT_BOLETO")
    public Short getGerarLogCnabAtBoleto() {
        return this.gerarLogCnabAtBoleto;
    }

    public void setGerarLogCnabAtBoleto(Short gerarLogCnabAtBoleto) {
        this.gerarLogCnabAtBoleto = gerarLogCnabAtBoleto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_OPCOES_FINANC_MEIO_PAGAMENTO"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO_FOLHA", foreignKey=@ForeignKey(name="FK_OPCOES_FINANC_MEIO_PAG_FOLHA"))
    public MeioPagamento getMeioPagamentoFolha() {
        return this.meioPagamentoFolha;
    }

    public void setMeioPagamentoFolha(MeioPagamento meioPagamentoFolha) {
        this.meioPagamentoFolha = meioPagamentoFolha;
    }

    @Column(name="VERIFICA_LIMITE_PLAN")
    public Short getVerificaLimitePlanProd() {
        return this.verificaLimitePlanProd;
    }

    public void setVerificaLimitePlanProd(Short verificaLimitePlanProd) {
        this.verificaLimitePlanProd = verificaLimitePlanProd;
    }

    @Column(name="VERIFICA_LIMITE_SIT_PED")
    public Short getVerificaLimiteSitPed() {
        return this.verificaLimiteSitPed;
    }

    public void setVerificaLimiteSitPed(Short verificaLimiteSitPed) {
        this.verificaLimiteSitPed = verificaLimiteSitPed;
    }

    @Column(name="BLOQUEAR_ALTERAR_TITULO_BAIXADO")
    public Short getBloquearAlterarTituloBaixado() {
        return this.bloquearAlterarTituloBaixado;
    }

    public void setBloquearAlterarTituloBaixado(Short bloquearAlterarTituloBaixado) {
        this.bloquearAlterarTituloBaixado = bloquearAlterarTituloBaixado;
    }

    @Column(name="PERMITIR_RENEG_VR_TIT_DIFERENTE")
    public Short getPermitirRenegociacaoValorTituloDiferente() {
        return this.permitirRenegociacaoValorTituloDiferente;
    }

    @Column(name="BLOQ_PAGAMENTO_OUTROS_BANCOS")
    public Short getBloqPagamentoOutrosBancos() {
        return this.bloqPagamentoOutrosBancos;
    }

    public void setBloqPagamentoOutrosBancos(Short bloqPagamentoOutrosBancos) {
        this.bloqPagamentoOutrosBancos = bloqPagamentoOutrosBancos;
    }

    public void setPermitirRenegociacaoValorTituloDiferente(Short permitirRenegociacaoValorTituloDiferente) {
        this.permitirRenegociacaoValorTituloDiferente = permitirRenegociacaoValorTituloDiferente;
    }

    @Column(name="PERMITIR_ALTERAR_TITULO")
    public Short getPermitirAlterarTitulo() {
        return this.permitirAlterarTitulo;
    }

    public void setPermitirAlterarTitulo(Short permitirAlterarTitulo) {
        this.permitirAlterarTitulo = permitirAlterarTitulo;
    }

    @Column(name="PERMITIR_ALTERAR_PC_TITULO")
    public Short getPermitirAlterarPlanoContaTitulo() {
        return this.permitirAlterarPlanoContaTitulo;
    }

    public void setPermitirAlterarPlanoContaTitulo(Short permitirAlterarPlanoContaTitulo) {
        this.permitirAlterarPlanoContaTitulo = permitirAlterarPlanoContaTitulo;
    }

    @Column(name="INFORMAR_PARCELA_TITULO_NF")
    public Short getInfomarParcelaTituloNotaFiscal() {
        return this.infomarParcelaTituloNotaFiscal;
    }

    public void setInfomarParcelaTituloNotaFiscal(Short infomarParcelaTituloNotaFiscal) {
        this.infomarParcelaTituloNotaFiscal = infomarParcelaTituloNotaFiscal;
    }

    @Column(name="VERIFICA_LIMITE_LIB_PED")
    public Short getVerificaLimiteLibPed() {
        return this.verificaLimiteLibPed;
    }

    public void setVerificaLimiteLibPed(Short verificaLimiteLibPed) {
        this.verificaLimiteLibPed = verificaLimiteLibPed;
    }

    @Column(name="SALVAR_LOG_DADOS_FIN_CLI")
    public Short getSalvarLogDadosFinCli() {
        return this.salvarLogDadosFinCli;
    }

    public void setSalvarLogDadosFinCli(Short salvarLogDadosFinCli) {
        this.salvarLogDadosFinCli = salvarLogDadosFinCli;
    }

    @Column(name="EXIBIR_TOTALIZADOR_BAIXA")
    public Short getExibirTotalizadorBaixa() {
        return this.exibirTotalizadorBaixa;
    }

    public void setExibirTotalizadorBaixa(Short exibirTotalizadorBaixa) {
        this.exibirTotalizadorBaixa = exibirTotalizadorBaixa;
    }

    @Column(name="TIPO_ALTERACAO_BAIXA")
    public Short getTipoAlteracaoBaixa() {
        return this.tipoAlteracaoBaixa;
    }

    public void setTipoAlteracaoBaixa(Short tipoAlteracaoBaixa) {
        this.tipoAlteracaoBaixa = tipoAlteracaoBaixa;
    }

    @Column(name="VISUALIZAR_SALD_MV_F_OUT_EMP")
    public Short getVisualizarSaldosMovFinancOutEmp() {
        return this.visualizarSaldosMovFinancOutEmp;
    }

    public void setVisualizarSaldosMovFinancOutEmp(Short visualizarSaldosMovFinancOutEmp) {
        this.visualizarSaldosMovFinancOutEmp = visualizarSaldosMovFinancOutEmp;
    }

    @OneToMany(mappedBy="opcoesFinanceiras", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<OpcoesFinanceirasTaxas> getTaxas() {
        return this.taxas;
    }

    public void setTaxas(List<OpcoesFinanceirasTaxas> taxas) {
        this.taxas = taxas;
    }

    @Column(name="VAL_CART_TIT_CONTA_VLR_B_PAG")
    public Short getValidarCartTitContaVlrBaixaPag() {
        return this.validarCartTitContaVlrBaixaPag;
    }

    public void setValidarCartTitContaVlrBaixaPag(Short validarCartTitContaVlrBaixaPag) {
        this.validarCartTitContaVlrBaixaPag = validarCartTitContaVlrBaixaPag;
    }

    @Column(name="VAL_CART_TIT_CONTA_VLR_B_REC")
    public Short getValidarCartTitContaVlrBaixaRec() {
        return this.validarCartTitContaVlrBaixaRec;
    }

    public void setValidarCartTitContaVlrBaixaRec(Short validarCartTitContaVlrBaixaRec) {
        this.validarCartTitContaVlrBaixaRec = validarCartTitContaVlrBaixaRec;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_TIT_PAG", foreignKey=@ForeignKey(name="FK_OPCOES_FINANC_CART_COB_TIT_P"))
    public CarteiraCobranca getCarteiraCobrancaTitPag() {
        return this.carteiraCobrancaTitPag;
    }

    public void setCarteiraCobrancaTitPag(CarteiraCobranca carteiraCobrancaTitPag) {
        this.carteiraCobrancaTitPag = carteiraCobrancaTitPag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_CHEQ_DEV", foreignKey=@ForeignKey(name="FK_OPCOES_FINANC_CART_COB_TIT_C"))
    public CarteiraCobranca getCarteiraCobrancaChequeDev() {
        return this.carteiraCobrancaChequeDev;
    }

    public void setCarteiraCobrancaChequeDev(CarteiraCobranca carteiraCobrancaChequeDev) {
        this.carteiraCobrancaChequeDev = carteiraCobrancaChequeDev;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_DESTINO", foreignKey=@ForeignKey(name="FK_OPCOES_FINANC_CART_COB_DEST"))
    public CarteiraCobranca getCarteiraCobrancaDestino() {
        return this.carteiraCobrancaDestino;
    }

    public void setCarteiraCobrancaDestino(CarteiraCobranca carteiraCobrancaDestino) {
        this.carteiraCobrancaDestino = carteiraCobrancaDestino;
    }

    @Column(name="VISUALIZAR_TIT_OUTRAS_EMP_REC")
    public Short getVisualizarTitulosOutrasEmpRec() {
        return this.visualizarTitulosOutrasEmpRec;
    }

    public void setVisualizarTitulosOutrasEmpRec(Short visualizarTitulosOutrasEmpRec) {
        this.visualizarTitulosOutrasEmpRec = visualizarTitulosOutrasEmpRec;
    }

    @Column(name="EXIBIR_BAIXA_NR_DOC")
    public Short getExibirBaixaNrDoc() {
        return this.exibirBaixaNrDoc;
    }

    public void setExibirBaixaNrDoc(Short exibirBaixaNrDoc) {
        this.exibirBaixaNrDoc = exibirBaixaNrDoc;
    }

    @Column(name="EXIBIR_BAIXA_NR_TITULO")
    public Short getExibirBaixaNrTitulo() {
        return this.exibirBaixaNrTitulo;
    }

    public void setExibirBaixaNrTitulo(Short exibirBaixaNrTitulo) {
        this.exibirBaixaNrTitulo = exibirBaixaNrTitulo;
    }

    @Column(name="EXIBIR_BAIXA_PESSOA")
    public Short getExibirBaixaPessoa() {
        return this.exibirBaixaPessoa;
    }

    public void setExibirBaixaPessoa(Short exibirBaixaPessoa) {
        this.exibirBaixaPessoa = exibirBaixaPessoa;
    }

    @Column(name="EXIBIR_BAIXA_DATA_EMISSAO")
    public Short getExibirBaixaDataEmissao() {
        return this.exibirBaixaDataEmissao;
    }

    public void setExibirBaixaDataEmissao(Short exibirBaixaDataEmissao) {
        this.exibirBaixaDataEmissao = exibirBaixaDataEmissao;
    }

    @Column(name="EXIBIR_BAIXA_DATA_VENCIMENTO")
    public Short getExibirBaixaDataVencimento() {
        return this.exibirBaixaDataVencimento;
    }

    public void setExibirBaixaDataVencimento(Short exibirBaixaDataVencimento) {
        this.exibirBaixaDataVencimento = exibirBaixaDataVencimento;
    }

    @Column(name="EXIBIR_BAIXA_VALOR_TITULO")
    public Short getExibirBaixaValorTitulo() {
        return this.exibirBaixaValorTitulo;
    }

    public void setExibirBaixaValorTitulo(Short exibirBaixaValorTitulo) {
        this.exibirBaixaValorTitulo = exibirBaixaValorTitulo;
    }

    @Column(name="EXIBIR_BAIXA_SALDO")
    public Short getExibirBaixaSaldo() {
        return this.exibirBaixaSaldo;
    }

    public void setExibirBaixaSaldo(Short exibirBaixaSaldo) {
        this.exibirBaixaSaldo = exibirBaixaSaldo;
    }

    @Column(name="EXIBIR_BAIXA_VALOR_JUROS")
    public Short getExibirBaixaValorJuros() {
        return this.exibirBaixaValorJuros;
    }

    public void setExibirBaixaValorJuros(Short exibirBaixaValorJuros) {
        this.exibirBaixaValorJuros = exibirBaixaValorJuros;
    }

    @Column(name="EXIBIR_BAIXA_VALOR_MULTA")
    public Short getExibirBaixaValorMulta() {
        return this.exibirBaixaValorMulta;
    }

    public void setExibirBaixaValorMulta(Short exibirBaixaValorMulta) {
        this.exibirBaixaValorMulta = exibirBaixaValorMulta;
    }

    @Column(name="EXIBIR_BAIXA_VALOR_DESCONTO")
    public Short getExibirBaixaValorDesconto() {
        return this.exibirBaixaValorDesconto;
    }

    public void setExibirBaixaValorDesconto(Short exibirBaixaValorDesconto) {
        this.exibirBaixaValorDesconto = exibirBaixaValorDesconto;
    }

    @JoinColumn(name="ID_TIPO_DOC_FIN_TIT_CARTAO", foreignKey=@ForeignKey(name="FK_OPCOES_FINANCEIRAS_1"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoDoc getTipoDocFinanceiroTituloCartao() {
        return this.tipoDocFinanceiroTituloCartao;
    }

    public void setTipoDocFinanceiroTituloCartao(TipoDoc tipoDocFinanceiroTituloCartao) {
        this.tipoDocFinanceiroTituloCartao = tipoDocFinanceiroTituloCartao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO_TIT_RETIDO", foreignKey=@ForeignKey(name="FK_OPCOES_FINANC_MEIO_PAG_TIT_R"))
    public MeioPagamento getMeioPagamentoTituloRetido() {
        return this.meioPagamentoTituloRetido;
    }

    public void setMeioPagamentoTituloRetido(MeioPagamento meioPagamentoTituloRetido) {
        this.meioPagamentoTituloRetido = meioPagamentoTituloRetido;
    }

    @Column(name="PESQ_TODOS_TIT_ANT_BAI_IND_PES")
    public Short getPesqTodosTitAntBaixaIndPessoa() {
        return this.pesqTodosTitAntBaixaIndPessoa;
    }

    public void setPesqTodosTitAntBaixaIndPessoa(Short pesqTodosTitAntBaixaIndPessoa) {
        this.pesqTodosTitAntBaixaIndPessoa = pesqTodosTitAntBaixaIndPessoa;
    }

    @Column(name="BLOQUEAR_LANC_TIT_DT_EMI_VENC")
    public Short getBloquearLancTitDtEmiVenc() {
        return this.bloquearLancTitDtEmiVenc;
    }

    public void setBloquearLancTitDtEmiVenc(Short bloquearLancTitDtEmiVenc) {
        this.bloquearLancTitDtEmiVenc = bloquearLancTitDtEmiVenc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO_CHEQUE_DEV", foreignKey=@ForeignKey(name="FK_OPCOES_FIN_MEIO_PAG_CH_DEV"))
    public MeioPagamento getMeioPagamentoChequeDev() {
        return this.meioPagamentoChequeDev;
    }

    public void setMeioPagamentoChequeDev(MeioPagamento meioPagamentoChequeDev) {
        this.meioPagamentoChequeDev = meioPagamentoChequeDev;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FIN_DOC_CHEQUE_DEV", foreignKey=@ForeignKey(name="FK_OPCOES_FIN_TIPO_DOC_CH_DEV"))
    public TipoDoc getTipoDocFinanceiroChequeDev() {
        return this.tipoDocFinanceiroChequeDev;
    }

    public void setTipoDocFinanceiroChequeDev(TipoDoc tipoDocFinanceiroChequeDev) {
        this.tipoDocFinanceiroChequeDev = tipoDocFinanceiroChequeDev;
    }

    @Column(name="TOLERANCIA_VLR_MOV_FINANCEIRO")
    public Double getToleranciaValorMovimentoFinanceiro() {
        return this.toleranciaValorMovimentoFinanceiro;
    }

    public void setToleranciaValorMovimentoFinanceiro(Double toleranciaValoresMovimentoFinanceiro) {
        this.toleranciaValorMovimentoFinanceiro = toleranciaValoresMovimentoFinanceiro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_CLIENTES", foreignKey=@ForeignKey(name="FK_OPCOES_FIN_CLASS_CLIENTES"))
    public ClassificacaoClientes getClassificacaoClientes() {
        return this.classificacaoClientes;
    }

    public void setClassificacaoClientes(ClassificacaoClientes classificacaoClientes) {
        this.classificacaoClientes = classificacaoClientes;
    }

    @Column(name="EXIBIR_TIPO_DOC_FINANCEIRO")
    public Short getExibirTipoDocFinanceiro() {
        return this.exibirTipoDocFinanceiro;
    }

    public void setExibirTipoDocFinanceiro(Short exibirTipoDocFinanceiro) {
        this.exibirTipoDocFinanceiro = exibirTipoDocFinanceiro;
    }

    @Column(name="ENVIAR_BOLETO_JUNTO_NFE")
    public Short getEnviarBoletoJuntoNFe() {
        return this.enviarBoletoJuntoNFe;
    }

    public void setEnviarBoletoJuntoNFe(Short enviarBoletoJuntoNFe) {
        this.enviarBoletoJuntoNFe = enviarBoletoJuntoNFe;
    }

    @Column(name="INCLUIR_PED_ABERTO_AN_CRED")
    public Short getIncluirPedAbertoAnCred() {
        return this.incluirPedAbertoAnCred;
    }

    public void setIncluirPedAbertoAnCred(Short incluirPedAbertoAnCred) {
        this.incluirPedAbertoAnCred = incluirPedAbertoAnCred;
    }

    @Column(name="NAO_DESC_BAIXA_COM_REPRES")
    public Short getNaoDescBaixaComRepres() {
        return this.naoDescBaixaComRepres;
    }

    public void setNaoDescBaixaComRepres(Short naoDescBaixaComRepres) {
        this.naoDescBaixaComRepres = naoDescBaixaComRepres;
    }

    @Column(name="PERM_EDITAR_CEN_RESULT_MOV_FIN")
    public Short getPermEditarCenResultMovFin() {
        return this.permEditarCenResultMovFin;
    }

    public void setPermEditarCenResultMovFin(Short permEditarCenResultMovFin) {
        this.permEditarCenResultMovFin = permEditarCenResultMovFin;
    }

    @Column(name="descontar_icms_deso_comissao")
    public Short getDescontarIcmsDesoneradoComissao() {
        return this.descontarIcmsDesoneradoComissao;
    }

    public void setDescontarIcmsDesoneradoComissao(Short descontarIcmsDesoneradoComissao) {
        this.descontarIcmsDesoneradoComissao = descontarIcmsDesoneradoComissao;
    }

    @Column(name="verifica_limite_pre_venda")
    public Short getVerificaLimitePreVenda() {
        return this.verificaLimitePreVenda;
    }

    public void setVerificaLimitePreVenda(Short verificaLimitePreVenda) {
        this.verificaLimitePreVenda = verificaLimitePreVenda;
    }

    @Column(name="GERAR_CUPOM_DESCONTO_DEV_VENDAS")
    public Short getGerarCupomDescontoDevolucaoVenda() {
        return this.gerarCupomDescontoDevolucaoVenda;
    }

    public void setGerarCupomDescontoDevolucaoVenda(Short gerarCupomDescontoDevolucaoVenda) {
        this.gerarCupomDescontoDevolucaoVenda = gerarCupomDescontoDevolucaoVenda;
    }

    @Column(name="GERAR_ESTORNO_COMISS_APUR_COOP")
    public Short getGerarEstornoComissaoApuracaoCooperado() {
        return this.gerarEstornoComissaoApuracaoCooperado;
    }

    public void setGerarEstornoComissaoApuracaoCooperado(Short gerarEstornoComissaoApuracaoCooperado) {
        this.gerarEstornoComissaoApuracaoCooperado = gerarEstornoComissaoApuracaoCooperado;
    }

    @Column(name="INCLUIR_VAL_ACESS_BC_COMIS_TIT")
    public Short getIncluirValoresAcessoriosBCComissaoTitulo() {
        return this.incluirValoresAcessoriosBCComissaoTitulo;
    }

    public void setIncluirValoresAcessoriosBCComissaoTitulo(Short incluirValoresAcessoriosBCComissaoTitulo) {
        this.incluirValoresAcessoriosBCComissaoTitulo = incluirValoresAcessoriosBCComissaoTitulo;
    }

    @Column(name="INCLUIR_VAL_DESC_BC_COMIS_TIT")
    public Short getIncluirValoresDescontosBCComissaoTitulo() {
        return this.incluirValoresDescontosBCComissaoTitulo;
    }

    public void setIncluirValoresDescontosBCComissaoTitulo(Short incluirValoresDescontosBCComissaoTitulo) {
        this.incluirValoresDescontosBCComissaoTitulo = incluirValoresDescontosBCComissaoTitulo;
    }

    @Column(name="BLOQ_ESTORNO_COMIS_DEV_VENDA")
    public Short getBloquearCampoEstornoComissaoDevolucaoVendas() {
        return this.bloquearCampoEstornoComissaoDevolucaoVendas;
    }

    public void setBloquearCampoEstornoComissaoDevolucaoVendas(Short bloquearCampoEstornoComissaoDevolucaoVendas) {
        this.bloquearCampoEstornoComissaoDevolucaoVendas = bloquearCampoEstornoComissaoDevolucaoVendas;
    }

    @OneToMany(mappedBy="opcoesFinanceiras", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<OpcoesFinanceirasOp> getOpcoesFinanceirasOp() {
        return this.opcoesFinanceirasOp;
    }

    public void setOpcoesFinanceirasOp(List<OpcoesFinanceirasOp> opcoesFinanceirasOp) {
        this.opcoesFinanceirasOp = opcoesFinanceirasOp;
    }
}

