/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="OPCOES_GERENCIAIS", uniqueConstraints={@UniqueConstraint(name="UNQ1_OPCOES_GERENCIAIS", columnNames={"ID_EMPRESA"})})
public class OpcoesGerenciais
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short lancarCentroCusto = 0;
    private CentroCusto centroCustoApurComisRepr;
    private CentroCusto centroCustoAdiantViagem;
    private Short obrigarInfCCTitNota = 0;
    private Short obrigarInfCCCotCompraOrdCompra = 0;
    private CentroCusto centroCustoTituloNFCeControleCaixa;
    private Short gerarLancGerencialTituloNFCeControleCaixa = 0;
    private Short utilizaContabilidadeGerencial = 1;
    private Short gerarLancamentosGerenciaisComo;
    private Short gerarlancamentoGerencialRecapagem = 0;
    private PlanoContaGerencial planoContaRecapagem;
    private Short alterarLancGeradoMentor = 0;
    private Short gerarLancamentosGerenciais = EnumConstantsMentorSimNao.NAO.getValue();
    private Short gerarLancamentosGerenciaisAnaliseOrcamentaria;

    public OpcoesGerenciais() {
        this.gerarLancamentosGerenciaisComo = EnumTipoLancamentoCTBGerencial.LIQUIDACAO.getValue();
        this.gerarLancamentosGerenciaisAnaliseOrcamentaria = EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_OPCOES_GERENCIAIS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_GERENCIAIS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_GERENCIAIS_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="LANCAR_CENTRO_CUSTO")
    public Short getLancarCentroCusto() {
        return this.lancarCentroCusto;
    }

    public void setLancarCentroCusto(Short lancarCentroCusto) {
        this.lancarCentroCusto = lancarCentroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO_APUR_COMIS_REPR", foreignKey=@ForeignKey(name="FK_OPCOES_GER_CC_APUR_COM_REPR"))
    public CentroCusto getCentroCustoApurComisRepr() {
        return this.centroCustoApurComisRepr;
    }

    public void setCentroCustoApurComisRepr(CentroCusto centroCustoApurComisRepr) {
        this.centroCustoApurComisRepr = centroCustoApurComisRepr;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO_ADIANT_VIAGEM", foreignKey=@ForeignKey(name="FK_OPCOES_GER_ADIANT_VIAGEM"))
    public CentroCusto getCentroCustoAdiantViagem() {
        return this.centroCustoAdiantViagem;
    }

    public void setCentroCustoAdiantViagem(CentroCusto centroCustoAdiantViagem) {
        this.centroCustoAdiantViagem = centroCustoAdiantViagem;
    }

    public void setAlterarLancGeradoMentor(Short alterarLancGeradoMentor) {
        this.alterarLancGeradoMentor = alterarLancGeradoMentor;
    }

    @Column(name="ALTERAR_LANC_GERADO_MENTOR")
    public Short getAlterarLancGeradoMentor() {
        return this.alterarLancGeradoMentor;
    }

    @Column(name="OBRIGAR_INF_CC_TIT_NOTA")
    public Short getObrigarInfCCTitNota() {
        return this.obrigarInfCCTitNota;
    }

    @Column(name="OBRIGAR_INF_CC_OC_COT_COMPRAS")
    public Short getObrigarInfCCCotCompraOrdCompra() {
        return this.obrigarInfCCCotCompraOrdCompra;
    }

    public void setObrigarInfCCCotCompraOrdCompra(Short obrigarInfCCCotCompraOrdCompra) {
        this.obrigarInfCCCotCompraOrdCompra = obrigarInfCCCotCompraOrdCompra;
    }

    public void setObrigarInfCCTitNota(Short obrigarInfCCTitNota) {
        this.obrigarInfCCTitNota = obrigarInfCCTitNota;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO_TIT_NFCE_C_CAIX", foreignKey=@ForeignKey(name="FK_OPCOES_GER_TIT_NFCE_C_CUSTO"))
    public CentroCusto getCentroCustoTituloNFCeControleCaixa() {
        return this.centroCustoTituloNFCeControleCaixa;
    }

    public void setCentroCustoTituloNFCeControleCaixa(CentroCusto centroCustoTituloNFCeControleCaixa) {
        this.centroCustoTituloNFCeControleCaixa = centroCustoTituloNFCeControleCaixa;
    }

    @Column(name="GERAR_LANC_GER_TIT_NFCE_C_CAIXA")
    public Short getGerarLancGerencialTituloNFCeControleCaixa() {
        return this.gerarLancGerencialTituloNFCeControleCaixa;
    }

    public void setGerarLancGerencialTituloNFCeControleCaixa(Short gerarLancGerencialTituloNFCeControleCaixa) {
        this.gerarLancGerencialTituloNFCeControleCaixa = gerarLancGerencialTituloNFCeControleCaixa;
    }

    @Column(name="utiliza_Contab_Gerencial")
    public Short getUtilizaContabilidadeGerencial() {
        return this.utilizaContabilidadeGerencial;
    }

    public void setUtilizaContabilidadeGerencial(Short utilizaContabilidadeGerencial) {
        this.utilizaContabilidadeGerencial = utilizaContabilidadeGerencial;
    }

    @Column(name="gerar_lanc_gerenc_como")
    public Short getGerarLancamentosGerenciaisComo() {
        return this.gerarLancamentosGerenciaisComo;
    }

    public void setGerarLancamentosGerenciaisComo(Short gerarLancamentosGerenciaisComo) {
        this.gerarLancamentosGerenciaisComo = gerarLancamentosGerenciaisComo;
    }

    @Column(name="GERAR_LANC_RECAPAGEM")
    public Short getGerarlancamentoGerencialRecapagem() {
        return this.gerarlancamentoGerencialRecapagem;
    }

    public void setGerarlancamentoGerencialRecapagem(Short gerarlancamentoGerencialRecapagem) {
        this.gerarlancamentoGerencialRecapagem = gerarlancamentoGerencialRecapagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_RECAPAGEM", foreignKey=@ForeignKey(name="FK_OPCOES_GER_PLANO_RECAPAGEM"))
    public PlanoContaGerencial getPlanoContaRecapagem() {
        return this.planoContaRecapagem;
    }

    public void setPlanoContaRecapagem(PlanoContaGerencial planoContaRecapagem) {
        this.planoContaRecapagem = planoContaRecapagem;
    }

    @Column(name="GERAR_LANCAMENTOS_GERENCIAIS")
    public Short getGerarLancamentosGerenciais() {
        return this.gerarLancamentosGerenciais;
    }

    public void setGerarLancamentosGerenciais(Short gerarLancamentosGerenciais) {
        this.gerarLancamentosGerenciais = gerarLancamentosGerenciais;
    }

    @Column(name="GER_LANC_GERENC_ANALISE_ORCAMEN")
    public Short getGerarLancamentosGerenciaisAnaliseOrcamentaria() {
        return this.gerarLancamentosGerenciaisAnaliseOrcamentaria;
    }

    public void setGerarLancamentosGerenciaisAnaliseOrcamentaria(Short gerarLancamentosGerenciaisAnaliseOrcamentaria) {
        this.gerarLancamentosGerenciaisAnaliseOrcamentaria = gerarLancamentosGerenciaisAnaliseOrcamentaria;
    }
}

