/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConfigArquivosFiscais;
import com.touchcomp.basementor.model.vo.ContasPisCofinsSpedCont;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ParamReceitaPisCofins;
import com.touchcomp.basementor.model.vo.ParametrizacaoEcd;
import com.touchcomp.basementor.model.vo.ParametrizacaoEcf;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="OPCOES_IMPOSTOS")
public class OpcoesImpostos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private GrupoEmpresa grupoEmpresa;
    private Short gerarParamReceitaPisCofinsProduto = 0;
    private Short permiteAlterarApuracaoReal = EnumConstantsMentorSimNao.NAO.getValue();
    private ParamReceitaPisCofins paramReceitaPisCofins;
    private ConfigArquivosFiscais configArqFiscaisReg1400ProdAgropecuarios;
    private ConfigArquivosFiscais configArqFiscaisReg1400OutrasEntradas;
    private ConfigArquivosFiscais configArqFiscaisReg1400ServicosTransporte;
    private String expressaoAnaliseVrTransfNFP;
    private String expressaoAnaliseVrTransfNFT;
    private List<ContasPisCofinsSpedCont> contasPisCofinsSpedCont = new ArrayList<ContasPisCofinsSpedCont>();
    private List<ParametrizacaoEcf> parametrizacaoECF = new ArrayList<ParametrizacaoEcf>();
    private ParametrizacaoEcd parametrizacaoEcd;

    @Id
    @Column(name="ID_OPCOES_IMPOSTOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_IMPOSTOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_IMPOSTOS_GRUPO_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @Column(name="GERAR_PARAM_REC_PIS_COFINS_PROD")
    public Short getGerarParamReceitaPisCofinsProduto() {
        return this.gerarParamReceitaPisCofinsProduto;
    }

    public void setGerarParamReceitaPisCofinsProduto(Short gerarParamReceitaPisCofinsProduto) {
        this.gerarParamReceitaPisCofinsProduto = gerarParamReceitaPisCofinsProduto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_PARAM_RECEITA_PIS_COFINS", foreignKey=@ForeignKey(name="FK_OPCOES_IMPOSTOS_PAR_REC_P_C"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ParamReceitaPisCofins getParamReceitaPisCofins() {
        return this.paramReceitaPisCofins;
    }

    public void setParamReceitaPisCofins(ParamReceitaPisCofins paramReceitaPisCofins) {
        this.paramReceitaPisCofins = paramReceitaPisCofins;
    }

    @JoinColumn(name="ID_CONF_ARQ_FISC_R1400_PROD_AGR", foreignKey=@ForeignKey(name="FK_OP_IMP_CONF_ARQ_PROD_AGROP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ConfigArquivosFiscais getConfigArqFiscaisReg1400ProdAgropecuarios() {
        return this.configArqFiscaisReg1400ProdAgropecuarios;
    }

    public void setConfigArqFiscaisReg1400ProdAgropecuarios(ConfigArquivosFiscais configArqFiscaisReg1400ProdAgropecuarios) {
        this.configArqFiscaisReg1400ProdAgropecuarios = configArqFiscaisReg1400ProdAgropecuarios;
    }

    @JoinColumn(name="ID_CONF_ARQ_FISC_R1400_OUT_ENTR", foreignKey=@ForeignKey(name="FK_OP_IMP_CONF_ARQ_OUT_ENTR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ConfigArquivosFiscais getConfigArqFiscaisReg1400OutrasEntradas() {
        return this.configArqFiscaisReg1400OutrasEntradas;
    }

    public void setConfigArqFiscaisReg1400OutrasEntradas(ConfigArquivosFiscais configArqFiscaisReg1400OutrasEntradas) {
        this.configArqFiscaisReg1400OutrasEntradas = configArqFiscaisReg1400OutrasEntradas;
    }

    @JoinColumn(name="ID_CONF_ARQ_FISC_R1400_SER_TRAN", foreignKey=@ForeignKey(name="FK_OP_IMP_CONF_ARQ_SERV_TRANSP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ConfigArquivosFiscais getConfigArqFiscaisReg1400ServicosTransporte() {
        return this.configArqFiscaisReg1400ServicosTransporte;
    }

    public void setConfigArqFiscaisReg1400ServicosTransporte(ConfigArquivosFiscais configArqFiscaisReg1400ServicosTransporte) {
        this.configArqFiscaisReg1400ServicosTransporte = configArqFiscaisReg1400ServicosTransporte;
    }

    @Column(name="EXPRESSAO_ANA_VR_TRANSF_NFP")
    public String getExpressaoAnaliseVrTransfNFP() {
        return this.expressaoAnaliseVrTransfNFP;
    }

    public void setExpressaoAnaliseVrTransfNFP(String expressaoAnaliseVrTransfNFP) {
        this.expressaoAnaliseVrTransfNFP = expressaoAnaliseVrTransfNFP;
    }

    @Column(name="EXPRESSAO_ANA_VR_TRANSF_NFT")
    public String getExpressaoAnaliseVrTransfNFT() {
        return this.expressaoAnaliseVrTransfNFT;
    }

    public void setExpressaoAnaliseVrTransfNFT(String expressaoAnaliseVrTransfNFT) {
        this.expressaoAnaliseVrTransfNFT = expressaoAnaliseVrTransfNFT;
    }

    @OneToMany(mappedBy="opcoesImpostos", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<ContasPisCofinsSpedCont> getContasPisCofinsSpedCont() {
        return this.contasPisCofinsSpedCont;
    }

    public void setContasPisCofinsSpedCont(List<ContasPisCofinsSpedCont> contasPisCofinsSpedCont) {
        this.contasPisCofinsSpedCont = contasPisCofinsSpedCont;
    }

    @OneToMany(mappedBy="opcoesImpostos", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ParametrizacaoEcf> getParametrizacaoECF() {
        return this.parametrizacaoECF;
    }

    public void setParametrizacaoECF(List<ParametrizacaoEcf> parametrizacaoECF) {
        this.parametrizacaoECF = parametrizacaoECF;
    }

    @Column(name="PERMITE_ALTERAR_APURACAO_REAL")
    public Short getPermiteAlterarApuracaoReal() {
        return this.permiteAlterarApuracaoReal;
    }

    public void setPermiteAlterarApuracaoReal(Short permiteAlterarApuracaoReal) {
        this.permiteAlterarApuracaoReal = permiteAlterarApuracaoReal;
    }

    @OneToOne(mappedBy="opcoesImpostos", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public ParametrizacaoEcd getParametrizacaoEcd() {
        return this.parametrizacaoEcd;
    }

    public void setParametrizacaoEcd(ParametrizacaoEcd parametrizacaoEcd) {
        this.parametrizacaoEcd = parametrizacaoEcd;
    }
}

