/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoeslocacao.EnumGerTituloApuracao;
import com.touchcomp.basementor.constants.enums.opcoeslocacao.EnumPessoaContrato;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoItemContratoLocacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="OPCOES_LOCACAO")
public class OpcoesLocacao
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private PlanoConta planoContaCred;
    private PlanoContaGerencial planoContaGerencial;
    private Short gerarFinanceiro;
    private Short gerarContabil;
    private String observacao;
    private Long diaPreferencialApuracao = 1L;
    private Short editarData = EnumConstantsMentorSimNao.NAO.getValue();
    private List<HistoricoPadrao> historico;
    private Double percBCComissaoRepresentante = 0.0;
    private Short validarAtivos;
    private Short informarNumeroContrato;
    private Short gerarRequisicao;
    private Short gerarTransferencia;
    private Short opcoesAvisoCapacidade;
    private Short tipoCentroCustoLancGerencial;
    private TipoItemContratoLocacao tipoItemContratoLocacao;
    private Short tipoPessoaContrato;
    private Timestamp dataAtualizacao;

    public OpcoesLocacao() {
        this.gerarFinanceiro = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarContabil = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarTransferencia = EnumConstantsMentorSimNao.NAO.getValue();
        this.gerarRequisicao = EnumConstantsMentorSimNao.NAO.getValue();
        this.historico = new ArrayList<HistoricoPadrao>();
        this.validarAtivos = EnumConstantsMentorSimNao.NAO.getValue();
        this.informarNumeroContrato = EnumConstantsMentorSimNao.NAO.getValue();
        this.opcoesAvisoCapacidade = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoCentroCustoLancGerencial = EnumGerTituloApuracao.CENTRO_CUSTO_SERVICO_RPS.getValue();
        this.tipoPessoaContrato = EnumPessoaContrato.TIPO_PESSOA_CLIENTE.getValue();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_OPCOES_LOCACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_LOCACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_LOCACAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CRED", foreignKey=@ForeignKey(name="FK_OPCOES_LOCACAO_PC_CRED"))
    public PlanoConta getPlanoContaCred() {
        return this.planoContaCred;
    }

    public void setPlanoContaCred(PlanoConta planoContaCred) {
        this.planoContaCred = planoContaCred;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GER", foreignKey=@ForeignKey(name="FK_OPCOES_LOCACAO_PC_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="GERAR_CONTABIL")
    public Short getGerarContabil() {
        return this.gerarContabil;
    }

    public void setGerarContabil(Short gerarContabil) {
        this.gerarContabil = gerarContabil;
    }

    @Column(name="OBSERVACAO_PADRAO", length=800)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DIA_PREFERENCIAL")
    public Long getDiaPreferencialApuracao() {
        return this.diaPreferencialApuracao;
    }

    public void setDiaPreferencialApuracao(Long diaPreferencialApuracao) {
        this.diaPreferencialApuracao = diaPreferencialApuracao;
    }

    @Column(name="EDITAR_DATA")
    public Short getEditarData() {
        return this.editarData;
    }

    public void setEditarData(Short editarData) {
        this.editarData = editarData;
    }

    @OneToMany(targetEntity=HistoricoPadrao.class, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.PERSIST, CascadeType.SAVE_UPDATE})
    @JoinTable(name="OPCOES_LOCACAO_HISTORICO", joinColumns={@JoinColumn(name="ID_OPCOES_LOCACAO")}, inverseJoinColumns={@JoinColumn(name="ID_HISTORICO_PADRAO")})
    public List<HistoricoPadrao> getHistorico() {
        return this.historico;
    }

    public void setHistorico(List<HistoricoPadrao> historico) {
        this.historico = historico;
    }

    @Column(nullable=false, name="PERC_BC_COMISSAO_REPRES", precision=15, scale=2)
    public Double getPercBCComissaoRepresentante() {
        return this.percBCComissaoRepresentante;
    }

    public void setPercBCComissaoRepresentante(Double percBCComissaoRepresentante) {
        this.percBCComissaoRepresentante = percBCComissaoRepresentante;
    }

    @Column(name="VALIDAR_ATIVOS")
    public Short getValidarAtivos() {
        return this.validarAtivos;
    }

    public void setValidarAtivos(Short validarAtivos) {
        this.validarAtivos = validarAtivos;
    }

    @Column(name="INFORMAR_NUMERO_CONTRATO")
    public Short getInformarNumeroContrato() {
        return this.informarNumeroContrato;
    }

    public void setInformarNumeroContrato(Short informarNumeroContrato) {
        this.informarNumeroContrato = informarNumeroContrato;
    }

    @Column(name="GERAR_REQUISICAO")
    public Short getGerarRequisicao() {
        return this.gerarRequisicao;
    }

    public void setGerarRequisicao(Short gerarRequisicao) {
        this.gerarRequisicao = gerarRequisicao;
    }

    @Column(name="GERAR_TRANSFERENCIA")
    public Short getGerarTransferencia() {
        return this.gerarTransferencia;
    }

    public void setGerarTransferencia(Short gerarTransferencia) {
        this.gerarTransferencia = gerarTransferencia;
    }

    @Column(name="OPCOES_AVISO_CAPACIDADE")
    public Short getOpcoesAvisoCapacidade() {
        return this.opcoesAvisoCapacidade;
    }

    public void setOpcoesAvisoCapacidade(Short opcoesAvisoCapacidade) {
        this.opcoesAvisoCapacidade = opcoesAvisoCapacidade;
    }

    @Column(name="TIPO_CENTRO_CUSTO_LANC_GER")
    public Short getTipoCentroCustoLancGerencial() {
        return this.tipoCentroCustoLancGerencial;
    }

    public void setTipoCentroCustoLancGerencial(Short tipoCentroCustoLancGerencial) {
        this.tipoCentroCustoLancGerencial = tipoCentroCustoLancGerencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ITEM_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_OPCOES_LOCACAO_TIPO_ITEM_CON"))
    public TipoItemContratoLocacao getTipoItemContratoLocacao() {
        return this.tipoItemContratoLocacao;
    }

    public void setTipoItemContratoLocacao(TipoItemContratoLocacao tipoItemContratoLocacao) {
        this.tipoItemContratoLocacao = tipoItemContratoLocacao;
    }

    @Column(name="TIPO_PESSOA_CONTRATO")
    public Short getTipoPessoaContrato() {
        return this.tipoPessoaContrato;
    }

    public void setTipoPessoaContrato(Short tipoPessoaContrato) {
        this.tipoPessoaContrato = tipoPessoaContrato;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }
}

