/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FichaTecOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemPlanProducaoOSLinProd;
import com.touchcomp.basementor.model.vo.PeriodoProducao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="OS_PRODUCAO_LINHA_PROD")
public class OrdemServicoProdLinhaProd
implements InterfaceVO {
    private Long identificador;
    private Long codigo;
    private Long codigoManual;
    private GradeCor gradeCor;
    private Double quantidadePrevProd = 0.0;
    private Double quantidadeRefPrevProd = 0.0;
    private Double totalHoras = 0.0;
    private List<FichaTecOSProdLinhaProd> fichasTecnicas;
    private List<SubdivisaoOSProdLinhaProd> subDivisoesOS = new ArrayList<SubdivisaoOSProdLinhaProd>();
    private Empresa empresa;
    private Date dataCadastro;
    private Date dataEmissao;
    private Date dataPrevisao;
    private Date dataPrevisaoInicio;
    private Timestamp dataAtualizacao;
    private String descricaoServico;
    private String observacoesPedidos;
    private RoteiroProducao roteiroProducao;
    private GradeFormulaProduto gradeFormulaProduto;
    private Integer nrSeqPlanejamento = 0;
    private ItemPlanProducaoOSLinProd itemPlanProducaoOSLinProd;
    private Short naoGerarSubOS = 0;
    private PeriodoProducao periodoProducao;
    private Pessoa pessoaParceiro;
    private TipoProducaoSped tipoProducaoSped;
    private GradeItemNotaTerceiros gradeItemNotaTerceiros;
    private Produto produtoVendavel;

    public OrdemServicoProdLinhaProd() {
        this.fichasTecnicas = new ArrayList<FichaTecOSProdLinhaProd>();
    }

    @Id
    @Column(nullable=false, name="ID_OS_PRODUCAO_LINHA_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OS_PRODUCAO_LINHA_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREV_FINALIZACAO")
    public Date getDataPrevisao() {
        return this.dataPrevisao;
    }

    public void setDataPrevisao(Date dataPrevisao) {
        this.dataPrevisao = dataPrevisao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(insertable=false, updatable=false, name="CODIGO")
    @Generated(value=GenerationTime.INSERT)
    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Id.:{0} Codigo: {1}", (Object[])new Object[]{this.getIdentificador(), this.getCodigo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_GRCOR"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor grade) {
        this.gradeCor = grade;
    }

    @Column(name="QUANTIDADE_PREV_PROD", precision=15, scale=6)
    public Double getQuantidadePrevProd() {
        return this.quantidadePrevProd;
    }

    public void setQuantidadePrevProd(Double quantidadePrevProd) {
        this.quantidadePrevProd = quantidadePrevProd;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="ordemServicoProdLinhaProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FichaTecOSProdLinhaProd> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<FichaTecOSProdLinhaProd> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }

    @OneToMany(mappedBy="ordemServicoProdLinhaProd", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<SubdivisaoOSProdLinhaProd> getSubDivisoesOS() {
        return this.subDivisoesOS;
    }

    public void setSubDivisoesOS(List<SubdivisaoOSProdLinhaProd> subDivisoesOS) {
        this.subDivisoesOS = subDivisoesOS;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=1000)
    public String getDescricaoServico() {
        return this.descricaoServico;
    }

    public void setDescricaoServico(String descricaoServico) {
        this.descricaoServico = descricaoServico;
    }

    @JoinColumn(name="ID_ROTEIRO_PRODUCAO", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_ROTPROD"))
    @ManyToOne(fetch=FetchType.LAZY)
    public RoteiroProducao getRoteiroProducao() {
        return this.roteiroProducao;
    }

    public void setRoteiroProducao(RoteiroProducao roteiroProducao) {
        this.roteiroProducao = roteiroProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_FORM_PRODUTO", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_GRFORM"))
    public GradeFormulaProduto getGradeFormulaProduto() {
        return this.gradeFormulaProduto;
    }

    public void setGradeFormulaProduto(GradeFormulaProduto gradeFormulaProduto) {
        this.gradeFormulaProduto = gradeFormulaProduto;
    }

    @Column(nullable=false, name="TOTAL_HORAS", precision=15, scale=4)
    public Double getTotalHoras() {
        return this.totalHoras;
    }

    public void setTotalHoras(Double totalHoras) {
        this.totalHoras = totalHoras;
    }

    @Transient
    public Integer getNrSeqPlanejamento() {
        return this.nrSeqPlanejamento;
    }

    public void setNrSeqPlanejamento(Integer nrSeqPlanejamento) {
        this.nrSeqPlanejamento = nrSeqPlanejamento;
    }

    @Ignore
    @Column(name="CODIGO_MANUAL")
    public Long getCodigoManual() {
        return this.codigoManual;
    }

    public void setCodigoManual(Long codigoManual) {
        this.codigoManual = codigoManual;
    }

    @OneToOne(mappedBy="ordemServicoProdLinProd")
    public ItemPlanProducaoOSLinProd getItemPlanProducaoOSLinProd() {
        return this.itemPlanProducaoOSLinProd;
    }

    public void setItemPlanProducaoOSLinProd(ItemPlanProducaoOSLinProd itemPlanProducaoOSLinProd) {
        this.itemPlanProducaoOSLinProd = itemPlanProducaoOSLinProd;
    }

    @Column(name="NAO_GERAR_SUBOS")
    public Short getNaoGerarSubOS() {
        return this.naoGerarSubOS;
    }

    public void setNaoGerarSubOS(Short naoExplodirSubOS) {
        this.naoGerarSubOS = naoExplodirSubOS;
    }

    @JoinColumn(name="ID_PERIODO_PRODUCAO", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_PER_PROD"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PeriodoProducao getPeriodoProducao() {
        return this.periodoProducao;
    }

    public void setPeriodoProducao(PeriodoProducao periodoProducao) {
        this.periodoProducao = periodoProducao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREV_INICIO")
    public Date getDataPrevisaoInicio() {
        return this.dataPrevisaoInicio;
    }

    public void setDataPrevisaoInicio(Date dataPrevisaoInicio) {
        this.dataPrevisaoInicio = dataPrevisaoInicio;
    }

    @JoinColumn(name="ID_PESSOA_PARCEIRO", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoaParceiro() {
        return this.pessoaParceiro;
    }

    public void setPessoaParceiro(Pessoa pessoaParceiro) {
        this.pessoaParceiro = pessoaParceiro;
    }

    @Column(nullable=false, name="QUANTIDADE_REF_PREV_PROD", precision=15, scale=6)
    public Double getQuantidadeRefPrevProd() {
        return this.quantidadeRefPrevProd;
    }

    public void setQuantidadeRefPrevProd(Double quantidadeRefPrevProd) {
        this.quantidadeRefPrevProd = quantidadeRefPrevProd;
    }

    @Column(name="OBSERVACOES_PEDIDOS", length=5000)
    public String getObservacoesPedidos() {
        return this.observacoesPedidos;
    }

    public void setObservacoesPedidos(String observacoesPedidos) {
        this.observacoesPedidos = observacoesPedidos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PRODUCAO_SPED", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_TP_PROD_S"))
    public TipoProducaoSped getTipoProducaoSped() {
        return this.tipoProducaoSped;
    }

    public void setTipoProducaoSped(TipoProducaoSped tipoProducaoSped) {
        this.tipoProducaoSped = tipoProducaoSped;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_ITEM_NOTA_T_IND_ENC", foreignKey=@ForeignKey(name="FK_OS_PROD_LIN_P_GR_IT_NF_T_IND"))
    public GradeItemNotaTerceiros getGradeItemNotaTerceiros() {
        return this.gradeItemNotaTerceiros;
    }

    public void setGradeItemNotaTerceiros(GradeItemNotaTerceiros gradeItemNotaTerceiros) {
        this.gradeItemNotaTerceiros = gradeItemNotaTerceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO_VENDAVEL", foreignKey=@ForeignKey(name="FK_OS_PROD_LINHA_PROD_PROD_VEND"))
    public Produto getProdutoVendavel() {
        return this.produtoVendavel;
    }

    public void setProdutoVendavel(Produto produtoVendavel) {
        this.produtoVendavel = produtoVendavel;
    }
}

