/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.DiagnosticoOS;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FichaTecOSProdSobEnc;
import com.touchcomp.basementor.model.vo.FormulacaoFases;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemPlanProducaoOSSobEnc;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.PeriodoProducao;
import com.touchcomp.basementor.model.vo.ProjetoPCP;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="OS_PRODUCAO_SOB_ENC")
public class OrdemServicoProdSobEnc
implements InterfaceVO {
    private Long identificador;
    private Long codigo;
    private Long codigoManual;
    private GradeCor gradeCor;
    private Double quantidadePrevProd = 0.0;
    private List<FichaTecOSProdSobEnc> fichasTecnicas = new ArrayList<FichaTecOSProdSobEnc>();
    private List<SubdivisaoOSProdSobEnc> subDivisoesOS = new ArrayList<SubdivisaoOSProdSobEnc>();
    private Empresa empresa;
    private Date dataCadastro;
    private Date dataPrevInicio;
    private Date dataFechamento;
    private Timestamp dataAtualizacao;
    private String descricaoServico;
    private RoteiroProducao roteiroProducao;
    private FormulacaoFases formulacaoFases;
    private LoteFabricacao loteFabricacao;
    private Double totalHoras = 0.0;
    private Short gerarComProd = 0;
    private ComunicadoProducao comunicadoProducao;
    private CentroCusto centroCusto;
    private Date dataPrevFechamento;
    private ItemPlanProducaoOSSobEnc itemPlanProducaoOSSobEnc;
    private DiagnosticoOS diagnosticoOS;
    private CentroEstoque centroEstoque;
    private PeriodoProducao periodoProducao;
    private ProjetoPCP projetoPCP;
    private String observacoesPedidos;
    private TipoProducaoSped tipoProducaoSped;

    @Id
    @Column(nullable=false, name="ID_OS_SOB_ENC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OS_PRODUCAO_SOB_ENC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(insertable=false, updatable=false, name="CODIGO")
    @Generated(value=GenerationTime.INSERT)
    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.codigo != null && this.getGradeCor() != null) {
            return ToolBaseMethodsVO.toString((String)"Codigo: {0} {1}", (Object[])new Object[]{this.getCodigo(), this.getGradeCor()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_GR_COR"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor grade) {
        this.gradeCor = grade;
    }

    @Column(name="QUANTIDADE_PREV_PROD", precision=15, scale=6)
    public Double getQuantidadePrevProd() {
        return this.quantidadePrevProd;
    }

    public void setQuantidadePrevProd(Double quantidadePrevProd) {
        this.quantidadePrevProd = quantidadePrevProd;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="ordemServicoProdSobEnc")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FichaTecOSProdSobEnc> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<FichaTecOSProdSobEnc> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }

    @OneToMany(mappedBy="ordemServicoProdSobEnc")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<SubdivisaoOSProdSobEnc> getSubDivisoesOS() {
        return this.subDivisoesOS;
    }

    public void setSubDivisoesOS(List<SubdivisaoOSProdSobEnc> subDivisoesOS) {
        this.subDivisoesOS = subDivisoesOS;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FECHAMENTO")
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=1000)
    public String getDescricaoServico() {
        return this.descricaoServico;
    }

    public void setDescricaoServico(String descricaoServico) {
        this.descricaoServico = descricaoServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTEIRO_PRODUCAO", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_ROT_PROD"))
    public RoteiroProducao getRoteiroProducao() {
        return this.roteiroProducao;
    }

    public void setRoteiroProducao(RoteiroProducao roteiroProducao) {
        this.roteiroProducao = roteiroProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMULACAO_FASE", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_FORM_FAS"))
    public FormulacaoFases getFormulacaoFases() {
        return this.formulacaoFases;
    }

    public void setFormulacaoFases(FormulacaoFases formulacaoFases) {
        this.formulacaoFases = formulacaoFases;
    }

    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_LOTE_FAB"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @Column(nullable=false, name="TOTAL_HORAS", precision=15, scale=4)
    public Double getTotalHoras() {
        return this.totalHoras;
    }

    public void setTotalHoras(Double totalHoras) {
        this.totalHoras = totalHoras;
    }

    @Ignore
    @Column(name="CODIGO_MANUAL")
    public Long getCodigoManual() {
        return this.codigoManual;
    }

    public void setCodigoManual(Long codigoManual) {
        this.codigoManual = codigoManual;
    }

    @Column(name="GERAR_COM_PROD")
    public Short getGerarComProd() {
        return this.gerarComProd;
    }

    public void setGerarComProd(Short gerarComProd) {
        this.gerarComProd = gerarComProd;
    }

    @OneToOne(optional=true)
    @JoinColumn(name="ID_COMUNICADO_PROD", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_COM_P"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ComunicadoProducao getComunicadoProducao() {
        return this.comunicadoProducao;
    }

    public void setComunicadoProducao(ComunicadoProducao comunicadoProducao) {
        this.comunicadoProducao = comunicadoProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_CENT_CUS"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PREV_FECHAMENTO")
    public Date getDataPrevFechamento() {
        return this.dataPrevFechamento;
    }

    public void setDataPrevFechamento(Date dataPrevFechamento) {
        this.dataPrevFechamento = dataPrevFechamento;
    }

    @OneToOne(mappedBy="ordemServicoProdSobEnc")
    public ItemPlanProducaoOSSobEnc getItemPlanProducaoOSSobEnc() {
        return this.itemPlanProducaoOSSobEnc;
    }

    public void setItemPlanProducaoOSSobEnc(ItemPlanProducaoOSSobEnc itemPlanProducaoOSSobEnc) {
        this.itemPlanProducaoOSSobEnc = itemPlanProducaoOSSobEnc;
    }

    @Column(name="DATA_PREV_INICIO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataPrevInicio() {
        return this.dataPrevInicio;
    }

    public void setDataPrevInicio(Date dataPrevInicio) {
        this.dataPrevInicio = dataPrevInicio;
    }

    @OneToOne(mappedBy="ordemServProdSobEnc", fetch=FetchType.LAZY)
    public DiagnosticoOS getDiagnosticoOS() {
        return this.diagnosticoOS;
    }

    public void setDiagnosticoOS(DiagnosticoOS diagnosticoOS) {
        this.diagnosticoOS = diagnosticoOS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_SOB_ENC"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PERIODO_PRODUCAO", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_PER_PROD"))
    public PeriodoProducao getPeriodoProducao() {
        return this.periodoProducao;
    }

    public void setPeriodoProducao(PeriodoProducao periodoProducao) {
        this.periodoProducao = periodoProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROJETO_PCP", foreignKey=@ForeignKey(name="FK_OS_PRODUCAO_SOB_ENC_PROJETO"))
    public ProjetoPCP getProjetoPCP() {
        return this.projetoPCP;
    }

    public void setProjetoPCP(ProjetoPCP projetoPCP) {
        this.projetoPCP = projetoPCP;
    }

    @Column(name="OBSERVACOES_PEDIDOS", length=5000)
    public String getObservacoesPedidos() {
        return this.observacoesPedidos;
    }

    public void setObservacoesPedidos(String observacoesPedidos) {
        this.observacoesPedidos = observacoesPedidos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PRODUCAO_SPED", foreignKey=@ForeignKey(name="FK_OS_PROD_ENC_TP_PROD_SPED"))
    public TipoProducaoSped getTipoProducaoSped() {
        return this.tipoProducaoSped;
    }

    public void setTipoProducaoSped(TipoProducaoSped tipoProducaoSped) {
        this.tipoProducaoSped = tipoProducaoSped;
    }
}

