/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.LocalCheckinout;
import com.touchcomp.basementor.model.vo.OrigemCheckListChList;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="ORIGEM_CHECK_LIST")
public class OrigemCheckList
implements InterfaceVO {
    private Long identificador;
    private ContratoLocacao contratoLocacao;
    private Pessoa pessoa;
    private LocalCheckinout localCheckinout;
    private List<OrigemCheckListChList> modelosCheckList = new ArrayList<OrigemCheckListChList>();
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();
    private Timestamp dataAtualizacao;

    @Id
    @Column(nullable=false, unique=true, name="ID_ORIGEM_CHECK_LIST")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ORIGEM_CHECK_LIST")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_ORIG_CHECK_LIST_CONT_LOCACAO"))
    public ContratoLocacao getContratoLocacao() {
        return this.contratoLocacao;
    }

    public void setContratoLocacao(ContratoLocacao contratoLocacao) {
        this.contratoLocacao = contratoLocacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getContratoLocacao() != null) {
            return ToolBaseMethodsVO.toString((String)"Contrato: {0} {1} {2}", (Object[])new Object[]{this.getContratoLocacao().getNumeroContrato(), this.getContratoLocacao().getCliente().getPessoa().getNome(), this.getLocalCheckinout()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getLocalCheckinout()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCAL_CHECK_INOUT", foreignKey=@ForeignKey(name="FK_OR_CHECK_LIST_LOC_CHECKINOUT"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public LocalCheckinout getLocalCheckinout() {
        return this.localCheckinout;
    }

    public void setLocalCheckinout(LocalCheckinout localCheckinout) {
        this.localCheckinout = localCheckinout;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="origemCheckList")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<OrigemCheckListChList> getModelosCheckList() {
        return this.modelosCheckList;
    }

    public void setModelosCheckList(List<OrigemCheckListChList> modelosCheckList) {
        this.modelosCheckList = modelosCheckList;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_ORIGEM_CHECK_LIST_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }
}

