/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="OUTRO_DEVEDOR", uniqueConstraints={@UniqueConstraint(name="UNQ1_OUTRO_DEVEDOR", columnNames={"ID_PESSOA"})})
public class OutroDevedor
implements InterfaceVO {
    private Empresa empresa;
    private PlanoConta planoConta;
    private Date dataCadastro;
    private Long identificador;
    private Pessoa pessoa;
    private Timestamp dataAtualizacao;

    @Id
    @Column(nullable=false, unique=true, name="ID_OUTRO_DEVEDOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long Identificador) {
        this.identificador = Identificador;
    }

    public OutroDevedor(Long i, Pessoa p) {
        this.setIdentificador(i);
        this.setPessoa(p);
    }

    public OutroDevedor() {
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OUTRO_DEVEDOR_2"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_OUTRO_DEVEDOR_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    public void setEmpresa(Empresa emp) {
        this.empresa = emp;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPessoa() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_OUTRO_DEVEDOR_1"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }
}

