/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.inject.InjectActualCompany;
import com.touchcomp.basementor.annotations.inject.InjectActualDate;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PacoteOrcamentarioPCGer;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PACOTE_ORCAMENTARIO", uniqueConstraints={@UniqueConstraint(name="UNQ1_PACOTE_ORCAMENTARIO", columnNames={"DESCRICAO"})})
public class PacoteOrcamentario
implements InterfaceVO {
    @Id
    @Column(name="ID_PACOTE_ORCAMENTARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PACOTE_ORCAMENTARIO")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    @InjectActualDate
    private Date dataCadastro;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Version
    @Column(name="DATA_ATUALIZACAO")
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PACOTE_ORCAMENTARIO_EMP"))
    @InjectActualCompany
    private Empresa empresa;
    @Column(name="DESCRICAO", length=250)
    private String descricao;
    @Column(name="OBSERVACAO", length=1000)
    private String observacao;
    @Column(name="ATIVO")
    private Short ativo = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_PACOTE_ORCAMENTARIO_USUA"))
    private Usuario usuario;
    @OneToMany(mappedBy="pacoteOrcamentario")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    private List<PacoteOrcamentarioPCGer> planosConta = new LinkedList<PacoteOrcamentarioPCGer>();
    @Column(name="DATA_ULT_MODIFICACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataUltModificacao;

    public PacoteOrcamentario() {
        this.dataCadastro = new Date();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Short getAtivo() {
        return this.ativo;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public List<PacoteOrcamentarioPCGer> getPlanosConta() {
        return this.planosConta;
    }

    @Generated
    public Date getDataUltModificacao() {
        return this.dataUltModificacao;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setPlanosConta(List<PacoteOrcamentarioPCGer> planosConta) {
        this.planosConta = planosConta;
    }

    @Generated
    public void setDataUltModificacao(Date dataUltModificacao) {
        this.dataUltModificacao = dataUltModificacao;
    }
}

