/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.paramcentroestoque.EnumConstParamCenEstEntSai;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ParamCentroEstoqueCliente;
import com.touchcomp.basementor.model.vo.ParamCentroEstoqueEspecie;
import com.touchcomp.basementor.model.vo.ParamCentroEstoqueFornecedores;
import com.touchcomp.basementor.model.vo.ParamCentroEstoqueNatOperacao;
import com.touchcomp.basementor.model.vo.ParamCentroEstoqueSubespecie;
import com.touchcomp.basementor.model.vo.ParamCentroEstoqueUsuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="PARAM_CENTRO_ESTOQUE")
public class ParamCentroEstoque
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private CentroEstoque centroEstoque;
    private Empresa empresa;
    private List<ParamCentroEstoqueEspecie> especies = new LinkedList<ParamCentroEstoqueEspecie>();
    private List<ParamCentroEstoqueSubespecie> subespecies = new LinkedList<ParamCentroEstoqueSubespecie>();
    private List<ParamCentroEstoqueUsuario> usuarios = new LinkedList<ParamCentroEstoqueUsuario>();
    private List<ParamCentroEstoqueFornecedores> fornecedores = new LinkedList<ParamCentroEstoqueFornecedores>();
    private List<ParamCentroEstoqueCliente> clientes = new LinkedList<ParamCentroEstoqueCliente>();
    private List<ParamCentroEstoqueNatOperacao> natOperacao = new LinkedList<ParamCentroEstoqueNatOperacao>();
    private Short tipoParamEntSai;

    public ParamCentroEstoque() {
        this.tipoParamEntSai = EnumConstParamCenEstEntSai.AMBOS.value;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_PARAM_CENTRO_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAM_CENTRO_ESTOQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="paramCentroEstoque", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ParamCentroEstoqueEspecie> getEspecies() {
        return this.especies;
    }

    public void setEspecies(List<ParamCentroEstoqueEspecie> especies) {
        this.especies = especies;
    }

    @OneToMany(mappedBy="paramCentroEstoque", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ParamCentroEstoqueSubespecie> getSubespecies() {
        return this.subespecies;
    }

    public void setSubespecies(List<ParamCentroEstoqueSubespecie> subespecies) {
        this.subespecies = subespecies;
    }

    @OneToMany(mappedBy="paramCentroEstoque", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ParamCentroEstoqueUsuario> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<ParamCentroEstoqueUsuario> usuarios) {
        this.usuarios = usuarios;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_PARAM_CENTRO_ESTOQUE_CEN_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAM_CENTRO_ESTOQUE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="paramCentroEstoque", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ParamCentroEstoqueFornecedores> getFornecedores() {
        return this.fornecedores;
    }

    public void setFornecedores(List<ParamCentroEstoqueFornecedores> fornecedores) {
        this.fornecedores = fornecedores;
    }

    @OneToMany(mappedBy="paramCentroEstoque", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ParamCentroEstoqueCliente> getClientes() {
        return this.clientes;
    }

    public void setClientes(List<ParamCentroEstoqueCliente> clientes) {
        this.clientes = clientes;
    }

    @OneToMany(mappedBy="paramCentroEstoque", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ParamCentroEstoqueNatOperacao> getNatOperacao() {
        return this.natOperacao;
    }

    public void setNatOperacao(List<ParamCentroEstoqueNatOperacao> natOperacao) {
        this.natOperacao = natOperacao;
    }

    @Column(name="TIPO_PARAM_ENT_SAI")
    public Short getTipoParamEntSai() {
        return this.tipoParamEntSai;
    }

    public void setTipoParamEntSai(Short tipoParamEntSai) {
        this.tipoParamEntSai = tipoParamEntSai;
    }
}

