/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ParamCnabCartCobranca;
import com.touchcomp.basementor.model.vo.ParamCnabTipoDocFinanceiro;
import com.touchcomp.basementor.model.vo.TipoCnab;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PARAMETRIZACAO_CNAB")
public class ParametrizacaoCnab
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private ConfiguracaoCnab configuracaoCnab;
    private List<ParamCnabCartCobranca> carteirasFinanceiras = new ArrayList<ParamCnabCartCobranca>();
    private List<ParamCnabTipoDocFinanceiro> docsFinanceiros = new ArrayList<ParamCnabTipoDocFinanceiro>();
    private TipoCnab tipoCnab;

    @Id
    @Column(nullable=false, unique=true, name="ID_PARAMETRIZACAO_CNAB")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAMETRIZACAO_CNAB")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAMETRIZACAO_CNAB_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONFIGURACAO_CNAB", foreignKey=@ForeignKey(name="FK_PARAMETRIZACAO_CNAB_CONF_CNA"))
    public ConfiguracaoCnab getConfiguracaoCnab() {
        return this.configuracaoCnab;
    }

    public void setConfiguracaoCnab(ConfiguracaoCnab configuracaoCnab) {
        this.configuracaoCnab = configuracaoCnab;
    }

    @OneToMany(mappedBy="parametrizacaoCnab", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ParamCnabCartCobranca> getCarteirasFinanceiras() {
        return this.carteirasFinanceiras;
    }

    public void setCarteirasFinanceiras(List<ParamCnabCartCobranca> carteirasFinanceiras) {
        this.carteirasFinanceiras = carteirasFinanceiras;
    }

    @OneToMany(mappedBy="parametrizacaoCnab", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ParamCnabTipoDocFinanceiro> getDocsFinanceiros() {
        return this.docsFinanceiros;
    }

    public void setDocsFinanceiros(List<ParamCnabTipoDocFinanceiro> docsFinanceiros) {
        this.docsFinanceiros = docsFinanceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CNAB", foreignKey=@ForeignKey(name="FK_PARAMETRIZ_CNAB_TIPO_CNAB"))
    public TipoCnab getTipoCnab() {
        return this.tipoCnab;
    }

    public void setTipoCnab(TipoCnab tipoCnab) {
        this.tipoCnab = tipoCnab;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getConfiguracaoCnab()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

