/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemEquipamento;
import com.touchcomp.basementor.model.vo.ParamEquipFuncao;
import com.touchcomp.basementor.model.vo.ParamEquipSegurancaEmpresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PARAM_EQUIP_SEG")
public class ParametrizacaoEquipamentoSeguranca
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private String descricao;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private List<ParamEquipFuncao> funcao;
    private List<ItemEquipamento> itemEquipamento = new ArrayList<ItemEquipamento>();
    private CentroEstoque centroEstoque;
    private List<ParamEquipSegurancaEmpresa> paramEquipSegurancaEmpresa;

    public ParametrizacaoEquipamentoSeguranca() {
        this.funcao = new ArrayList<ParamEquipFuncao>();
        this.paramEquipSegurancaEmpresa = new ArrayList<ParamEquipSegurancaEmpresa>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_PARAM_EQUIP_SEG")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAMETRIZACAO_EQUIPAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_CADASTR0")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAM_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="parametrizacaoEquipamentoSeguranca", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ParamEquipFuncao> getFuncao() {
        return this.funcao;
    }

    public void setFuncao(List<ParamEquipFuncao> funcao) {
        this.funcao = funcao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="parametrizacaoEquipamentoSeguranca")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ItemEquipamento> getItemEquipamento() {
        return this.itemEquipamento;
    }

    public void setItemEquipamento(List<ItemEquipamento> itemEquipamento) {
        this.itemEquipamento = itemEquipamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_PARAM_EQUIP_SEG_CENTRO_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="paramEquipSeguranca")
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ParamEquipSegurancaEmpresa> getParamEquipSegurancaEmpresa() {
        return this.paramEquipSegurancaEmpresa;
    }

    public void setParamEquipSegurancaEmpresa(List<ParamEquipSegurancaEmpresa> paramEquipSegurancaEmpresa) {
        this.paramEquipSegurancaEmpresa = paramEquipSegurancaEmpresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

