/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ParamFinanFolhaCentroCusto;
import com.touchcomp.basementor.model.vo.ParamFinanFolhaTipoFolha;
import com.touchcomp.basementor.model.vo.ParamFinanTipoColaborador;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PARAMETRIZACAO_FINANCEIRA_FOLHA")
public class ParametrizacaoFinanceiraFolha
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private PlanoConta planoContaContabil;
    private PlanoContaGerencial planoContaGerencial;
    private HistoricoPadrao historicoPadrao;
    private List<ParamFinanFolhaCentroCusto> centroCustos = new ArrayList<ParamFinanFolhaCentroCusto>();
    private List<ParamFinanFolhaTipoFolha> tipoFolhas = new ArrayList<ParamFinanFolhaTipoFolha>();
    private List<ParamFinanTipoColaborador> tipoColaboradores = new ArrayList<ParamFinanTipoColaborador>();
    private String descricao;

    @Id
    @Column(nullable=false, unique=true, name="ID_PARAM_FINANCEIRA_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAMETRIZACAO_FINANCEIRA_F")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAMETRIZACAO_FINAN_EM"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CONTABIL", foreignKey=@ForeignKey(name="FK_PARAMETRIZACAO_FINAN_CONTABI"))
    public PlanoConta getPlanoContaContabil() {
        return this.planoContaContabil;
    }

    public void setPlanoContaContabil(PlanoConta planoContaContabil) {
        this.planoContaContabil = planoContaContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_PARAMETRIZACAO_FINAN_GERENCI"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_PARAMETRIZACAO_FINAN_HISTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    @OneToMany(mappedBy="parametrizacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ParamFinanFolhaCentroCusto> getCentroCustos() {
        return this.centroCustos;
    }

    public void setCentroCustos(List<ParamFinanFolhaCentroCusto> centroCustos) {
        this.centroCustos = centroCustos;
    }

    @OneToMany(mappedBy="parametrizacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ParamFinanFolhaTipoFolha> getTipoFolhas() {
        return this.tipoFolhas;
    }

    public void setTipoFolhas(List<ParamFinanFolhaTipoFolha> tipoFolhas) {
        this.tipoFolhas = tipoFolhas;
    }

    @OneToMany(mappedBy="parametrizacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ParamFinanTipoColaborador> getTipoColaboradores() {
        return this.tipoColaboradores;
    }

    public void setTipoColaboradores(List<ParamFinanTipoColaborador> tipoColaboradores) {
        this.tipoColaboradores = tipoColaboradores;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

