/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemEventoGuiaFolha;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PARAM_GUIA_EVENTO_FOLHA")
public class ParametrizacaoGuiaEventoFolha
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short diaVencimento = 0;
    private PlanoConta planoContaContabil;
    private PlanoContaGerencial planoContaGerencial;
    private Pessoa pessoa;
    private List<ItemEventoGuiaFolha> itemEventoGuia = new ArrayList<ItemEventoGuiaFolha>();

    @Id
    @Column(nullable=false, unique=true, name="ID_PARAM_GUIA_EVENTO_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAM_GUIA_EVENTO_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAM_GUIA_EVENTO_F_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DIA_VENCIMENTO")
    public Short getDiaVencimento() {
        return this.diaVencimento;
    }

    public void setDiaVencimento(Short diaVencimento) {
        this.diaVencimento = diaVencimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CONTABIL", foreignKey=@ForeignKey(name="FK_PARAM_GUIA_EVENTO_F_PC"))
    public PlanoConta getPlanoContaContabil() {
        return this.planoContaContabil;
    }

    public void setPlanoContaContabil(PlanoConta planoContaContabil) {
        this.planoContaContabil = planoContaContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_PARAM_GUIA_EVENTO_F_PC_GER"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_PARAM_GUIA_EVENTO_F_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @OneToMany(mappedBy="parametrizacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemEventoGuiaFolha> getItemEventoGuia() {
        return this.itemEventoGuia;
    }

    public void setItemEventoGuia(List<ItemEventoGuiaFolha> itemEventoGuia) {
        this.itemEventoGuia = itemEventoGuia;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

