/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatResEstoquePed;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.CotacaoVendas;
import com.touchcomp.basementor.model.vo.DocumentosRefNFPropriaPed;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GeracaoTituloPedido;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.IntermediadorComercial;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LiberacaoMTC;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPed;
import com.touchcomp.basementor.model.vo.LogPedido;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NFCeConsumidor;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.ObsIntFiscoPedido;
import com.touchcomp.basementor.model.vo.ObservacaoPedidoFaturamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ReceitaAgronomica;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.TransportadorRedespacho;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnificacaoPedido;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="PEDIDO")
public class Pedido
implements InterfaceVO {
    private Long identificador;
    private String nrPedidoCliente;
    private Long codigoPedido;
    private String observacao;
    private String observacaoUsoInterno;
    private Double percFrete = 0.0;
    private Double valorFrete = 0.0;
    private Double percDesconto = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorBancoCredito = 0.0;
    private Double valorTotalBruto = 0.0;
    private Double valorTotal = 0.0;
    private Double percSeguro = 0.0;
    private Double valorSeguro = 0.0;
    private Double percDespAcessoria = 0.0;
    private Double valorDespAcessoria = 0.0;
    private String condPagMut;
    private Double percDescFinanceiro = 0.0;
    private Double percComissao = 0.0;
    private Date dataPrevisaoFat;
    private Representante representante;
    private Pessoa indicante;
    private CondicoesPagamento condicoesPagamento;
    private TipoFrete tipoFrete;
    private List<ObservacaoPedidoFaturamento> observacoes;
    private Date dataPrevisaoSaida;
    private NaturezaOperacao naturezaOperacao;
    private UnidadeFatCliente unidadeFatCliente;
    private SituacaoPedidos situacaoPedido;
    private Transportador transportador;
    private TransportadorRedespacho transportadorRedes;
    private List<Expedicao> expedicao;
    private List<ObsIntFiscoPedido> observacaoIntFisco;
    private Date dataEmissao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private List<ItemPedido> itemPedido;
    private Short reservarEstoque = 0;
    private Short tipoDesconto = 1;
    private Double pesoTotal = 0.0;
    private Double totalComissao = 0.0;
    private String observacaoSistema;
    private CotacaoVendas cotacaoVendas;
    private Short tipoFreteInf = 1;
    private Short tipoSeguroInf = 1;
    private Short tipoDespAcessInf = 1;
    private Short destacarFrete = 1;
    private Short destacarSeguro = 1;
    private Short destacarDesconto = 1;
    private Short destacarDespAcessoria = 1;
    private Pessoa agenteLoja;
    private Short informarLocalEntrega = 0;
    private Endereco enderecoEntrega;
    private Integer nrSequencialPedido = 1;
    private Long codigoPedInformado;
    private List<TransferenciaCentroEstoque> transferencias;
    private CentroEstoque centroEstoqueReserva;
    private List<NecessidadeCompra> necessidadesCompra;
    private Double percFreteInf = 0.0;
    private Double valorFreteInf = 0.0;
    private Double percDescontoInf = 0.0;
    private Double valorDescontoInf = 0.0;
    private Double percSeguroInf = 0.0;
    private Double valorSeguroInf = 0.0;
    private Double percDespAcessoriaInf = 0.0;
    private Double valorDespAcessoriaInf = 0.0;
    private Double valorTotalComImpostos = 0.0;
    private Pedido pedidoPai;
    private Short tipoDataTitulo = 0;
    private UnidadeFederativa ufEmbarque;
    private String localEmbarque;
    private Usuario usuario;
    private BigInteger idPedidoMobile;
    private Double volumeTotal = 0.0;
    private Short tipoConsumidor = 0;
    private Double valorFaturado = 0.0;
    private Double valorNaoFaturado = 0.0;
    private Pedido pedidoBonificacaoBrinde;
    private Moeda moeda;
    private CotacaoMoeda cotacaoMoeda;
    private ArquivamentoDoc arquivoDoc;
    private Short diasMediosCondPag = 0;
    private SituacaoPedidos situacaoPedAnt;
    private LiberacaoPedidoPed liberacaoPedidoPed;
    private Integer nrTotalItens = 0;
    private Double qtdeTotalItens = 0.0;
    private Double vlrTotalCusto = 0.0;
    private MeioPagamento meioPagamento;
    private List<LogPedido> logsPedido;
    private UnificacaoPedido unificacaoPedido;
    private LiberacaoMTC liberacaoMTC;
    private Usuario usuarioUltMod;
    private List<InfPagamentoPedido> infPagamentoPedido;
    private String notaEmpenho;
    private String nrContrato;
    private Usuario usuarioAutorizacaoDesconto;
    private String serialForSync;
    private Double valorAcrescCondPagamento = 0.0;
    private Double valorDescCondPagamento = 0.0;
    private NFCeConsumidor nfceConsumidor;
    private Pessoa pessoaAutorizada;
    private Usuario usuarioCancelamento;
    private String motivoCancelamento;
    private Date dataCancelamento;
    private List<DocumentosRefNFPropriaPed> notasPropriasReferenciadas;
    private Short modoReservaEstoque;
    private Double valorTotalBrutoDescTrib = 0.0;
    private Double valorTotalDescTrib = 0.0;
    private Double valorDescFinanceiro;
    private IntermediadorComercial intermediadorComercial;
    private Short indicadorPresencaConsumidor;
    private Short tipoIntermediadorComercial = EnumConstNFeIndIntermediador.NAO_SE_APLICA.getValue();
    private GeracaoTituloPedido geracaoTituloPedido;
    private CentroEstoque centroEstoqueFat;
    private Double valorLimiteDispAntesVenda;
    private Double valorLimiteDispPosVenda;
    private Double limiteCredito;
    private Double totalCompras;
    private Double valorDescontoTrib;
    private Double percDescontoTrib;
    private NFCeControleCaixa nfceControleCaixa;
    private List<ReceitaAgronomica> receitasAgronomicas;
    private ReceitaAgronomica receituario;

    public Pedido() {
        this.itemPedido = new ArrayList<ItemPedido>();
        this.observacaoIntFisco = new ArrayList<ObsIntFiscoPedido>();
        this.infPagamentoPedido = new ArrayList<InfPagamentoPedido>();
        this.observacoes = new ArrayList<ObservacaoPedidoFaturamento>();
        this.logsPedido = new ArrayList<LogPedido>();
        this.transferencias = new ArrayList<TransferenciaCentroEstoque>();
        this.necessidadesCompra = new ArrayList<NecessidadeCompra>();
        this.expedicao = new ArrayList<Expedicao>();
        LiberacaoPedidoPed l = new LiberacaoPedidoPed();
        l.setPedido(this);
        this.liberacaoPedidoPed = l;
        this.observacao = "";
        this.observacaoSistema = "";
        this.observacaoUsoInterno = "";
        this.notasPropriasReferenciadas = new ArrayList<DocumentosRefNFPropriaPed>();
        this.modoReservaEstoque = EnumConstOpFatResEstoquePed.RESERVAR_TRANSFERENCIA_ESTOQUE.getValue();
        this.valorDescFinanceiro = 0.0;
        this.indicadorPresencaConsumidor = EnumConstNFeIndicadorPresConsumidor.OPERACAO_PRESENCIAL.getValue();
        this.tipoIntermediadorComercial = EnumConstNFeIndIntermediador.NAO_SE_APLICA.getValue();
        this.valorLimiteDispAntesVenda = 0.0;
        this.valorLimiteDispPosVenda = 0.0;
        this.limiteCredito = 0.0;
        this.totalCompras = 0.0;
        this.valorDescontoTrib = 0.0;
        this.percDescontoTrib = 0.0;
        this.receitasAgronomicas = new ArrayList<ReceitaAgronomica>();
    }

    @Id
    @Column(nullable=false, name="ID_PEDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PEDIDO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="NR_PEDIDO_CLIENTE", length=15)
    public String getNrPedidoCliente() {
        return this.nrPedidoCliente;
    }

    @Column(name="CODIGO_PEDIDO")
    @Generated(value=GenerationTime.INSERT)
    public Long getCodigoPedido() {
        return this.codigoPedido;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    @Column(nullable=false, name="PERC_FRETE", precision=15, scale=4)
    public Double getPercFrete() {
        return this.percFrete;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=12, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Column(nullable=false, name="PERC_DESCONTO", precision=15, scale=4)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=12, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Column(nullable=false, name="VALOR_BANCO_CREDITO", precision=12, scale=2)
    public Double getValorBancoCredito() {
        return this.valorBancoCredito;
    }

    @Column(nullable=false, name="VALOR_TOTAL_BRUTO", precision=12, scale=2)
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=12, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @Column(nullable=false, name="PERC_SEGURO", precision=15, scale=4)
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    @Column(nullable=false, name="VALOR_SEGURO", precision=12, scale=2)
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    @Column(nullable=false, name="PERC_DESP_ACESSORIO", precision=15, scale=4)
    public Double getPercDespAcessoria() {
        return this.percDespAcessoria;
    }

    @Column(nullable=false, name="VALOR_DESP_ACESSORIO", precision=12, scale=2)
    public Double getValorDespAcessoria() {
        return this.valorDespAcessoria;
    }

    @Column(name="COND_PAG_MUT", length=100)
    public String getCondPagMut() {
        return this.condPagMut;
    }

    @Column(name="PERC_DESC_FINANCEIRO", precision=15, scale=4)
    public Double getPercDescFinanceiro() {
        return this.percDescFinanceiro;
    }

    @Column(name="PERC_COMISSAO", precision=15, scale=2)
    public Double getPercComissao() {
        return this.percComissao;
    }

    @Column(name="DATA_PREVISAO_FAT")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPrevisaoFat() {
        return this.dataPrevisaoFat;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_PEDIDO_REPRESENTANTE"))
    public Representante getRepresentante() {
        return this.representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_PEDIDO_COND_PAGAMENTO"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_PEDIDO_TIPO_FRETE"))
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pedido", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @Fetch(value=FetchMode.SUBSELECT)
    public List<ObservacaoPedidoFaturamento> getObservacoes() {
        return this.observacoes;
    }

    @Column(nullable=false, name="DATA_PREVISAO_SAIDA")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataPrevisaoSaida() {
        return this.dataPrevisaoSaida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_PEDIDO_NAT_OPERACAO"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_PEDIDO_UNID_FAT_CLIENTE"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    @JoinColumn(name="ID_SITUACAO_PEDIDO", foreignKey=@ForeignKey(name="FK_PEDIDO_SITUACAO_PEDIDOS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SituacaoPedidos getSituacaoPedido() {
        return this.situacaoPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_PEDIDO_TRANSPORTADOR"))
    public Transportador getTransportador() {
        return this.transportador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSP_REDESPACHO", foreignKey=@ForeignKey(name="FK_PEDIDO_TRANSP_REDESPACHO"))
    public TransportadorRedespacho getTransportadorRedes() {
        return this.transportadorRedes;
    }

    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY)
    public List<Expedicao> getExpedicao() {
        return this.expedicao;
    }

    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ObsIntFiscoPedido> getObservacaoIntFisco() {
        return this.observacaoIntFisco;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PEDIDO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemPedido> getItemPedido() {
        return this.itemPedido;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setNrPedidoCliente(String nrPedidoCliente) {
        this.nrPedidoCliente = nrPedidoCliente;
    }

    public void setCodigoPedido(Long codigoPedido) {
        this.codigoPedido = codigoPedido;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorBancoCredito(Double valorBancoCredito) {
        this.valorBancoCredito = valorBancoCredito;
    }

    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    public void setPercDespAcessoria(Double percDespAcessoria) {
        this.percDespAcessoria = percDespAcessoria;
    }

    public void setValorDespAcessoria(Double valorDespAcessoria) {
        this.valorDespAcessoria = valorDespAcessoria;
    }

    public void setCondPagMut(String condPagMut) {
        this.condPagMut = condPagMut;
    }

    public void setPercDescFinanceiro(Double percDescFinanceiro) {
        this.percDescFinanceiro = percDescFinanceiro;
    }

    public void setPercComissao(Double percComissao) {
        this.percComissao = percComissao;
    }

    public void setDataPrevisaoFat(Date dataPrevisaoFat) {
        this.dataPrevisaoFat = dataPrevisaoFat;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    public void setObservacoes(List<ObservacaoPedidoFaturamento> observacoes) {
        this.observacoes = observacoes;
    }

    public void setDataPrevisaoSaida(Date dataPrevisaoSaida) {
        this.dataPrevisaoSaida = dataPrevisaoSaida;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    public void setSituacaoPedido(SituacaoPedidos situacaoPedido) {
        this.situacaoPedido = situacaoPedido;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    public void setTransportadorRedes(TransportadorRedespacho transportadorRedes) {
        this.transportadorRedes = transportadorRedes;
    }

    public void setExpedicao(List<Expedicao> expedicao) {
        this.expedicao = expedicao;
    }

    public void setObservacaoIntFisco(List<ObsIntFiscoPedido> observacaoIntFisco) {
        this.observacaoIntFisco = observacaoIntFisco;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setItemPedido(List<ItemPedido> itemPedido) {
        this.itemPedido = itemPedido;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getIdentificador() != null && this.getUnidadeFatCliente() != null) {
            return ToolBaseMethodsVO.toString((String)"Pedido: {0} Cliente: {1}", (Object[])new Object[]{this.getIdentificador(), this.getUnidadeFatCliente()});
        }
        if (this.getUnidadeFatCliente() != null) {
            return ToolBaseMethodsVO.toString((String)"Cliente: {0}", (Object[])new Object[]{this.getUnidadeFatCliente()});
        }
        return ToolBaseMethodsVO.toString((String)"Pedido: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="RESERVAR_ESTOQUE")
    public Short getReservarEstoque() {
        return this.reservarEstoque;
    }

    public void setReservarEstoque(Short reservarEstoque) {
        this.reservarEstoque = reservarEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICANTE", foreignKey=@ForeignKey(name="FK_PEDIDO_INDICANTE"))
    public Pessoa getIndicante() {
        return this.indicante;
    }

    public void setIndicante(Pessoa indicante) {
        this.indicante = indicante;
    }

    @Column(name="TIPO_DESCONTO")
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Column(name="PESO_TOTAL", precision=15, scale=2)
    public Double getPesoTotal() {
        return this.pesoTotal;
    }

    public void setPesoTotal(Double pesoTotal) {
        this.pesoTotal = pesoTotal;
    }

    @Column(name="TOTAL_COMISSAO", precision=15, scale=2)
    public Double getTotalComissao() {
        return this.totalComissao;
    }

    public void setTotalComissao(Double totalComissao) {
        this.totalComissao = totalComissao;
    }

    @Column(name="OBSERVACAO_SISTEMA", length=5000)
    public String getObservacaoSistema() {
        return this.observacaoSistema;
    }

    public void setObservacaoSistema(String observacaoPedido) {
        this.observacaoSistema = observacaoPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_VENDAS", foreignKey=@ForeignKey(name="FK_PEDIDO_COT_VENDAS"))
    public CotacaoVendas getCotacaoVendas() {
        return this.cotacaoVendas;
    }

    public void setCotacaoVendas(CotacaoVendas cotacaoVendas) {
        this.cotacaoVendas = cotacaoVendas;
    }

    @Column(name="TIPO_FRETE_INF")
    public Short getTipoFreteInf() {
        return this.tipoFreteInf;
    }

    public void setTipoFreteInf(Short tipoFreteInf) {
        this.tipoFreteInf = tipoFreteInf;
    }

    @Column(name="TIPO_SEGURO_INF")
    public Short getTipoSeguroInf() {
        return this.tipoSeguroInf;
    }

    public void setTipoSeguroInf(Short tipoSeguroInf) {
        this.tipoSeguroInf = tipoSeguroInf;
    }

    @Column(name="TIPO_DESP_ACESS_INF")
    public Short getTipoDespAcessInf() {
        return this.tipoDespAcessInf;
    }

    public void setTipoDespAcessInf(Short tipoDespAcessInf) {
        this.tipoDespAcessInf = tipoDespAcessInf;
    }

    @Column(name="DESTACAR_FRETE")
    public Short getDestacarFrete() {
        return this.destacarFrete;
    }

    public void setDestacarFrete(Short destacarFrete) {
        this.destacarFrete = destacarFrete;
    }

    @Column(name="DESTACAR_SEGURO")
    public Short getDestacarSeguro() {
        return this.destacarSeguro;
    }

    public void setDestacarSeguro(Short destacarSeguro) {
        this.destacarSeguro = destacarSeguro;
    }

    @Column(name="DESTACAR_DESCONTO")
    public Short getDestacarDesconto() {
        return this.destacarDesconto;
    }

    public void setDestacarDesconto(Short destacarDesconto) {
        this.destacarDesconto = destacarDesconto;
    }

    @Column(name="DESTACAR_DESP_ACESSORIA")
    public Short getDestacarDespAcessoria() {
        return this.destacarDespAcessoria;
    }

    public void setDestacarDespAcessoria(Short destacarDespAcessoria) {
        this.destacarDespAcessoria = destacarDespAcessoria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_AGENTE_LOJA", foreignKey=@ForeignKey(name="FK_PEDIDO_PESSOA"))
    public Pessoa getAgenteLoja() {
        return this.agenteLoja;
    }

    public void setAgenteLoja(Pessoa agenteLoja) {
        this.agenteLoja = agenteLoja;
    }

    @Column(name="INFORMAR_LOCAL_ENTREGA")
    public Short getInformarLocalEntrega() {
        return this.informarLocalEntrega;
    }

    public void setInformarLocalEntrega(Short informarLocalEntrega) {
        this.informarLocalEntrega = informarLocalEntrega;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ENDERECO_ENTREGA", foreignKey=@ForeignKey(name="FK_PEDIDO_ENDERECO_ENTREGA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Endereco getEnderecoEntrega() {
        return this.enderecoEntrega;
    }

    public void setEnderecoEntrega(Endereco enderecoEntrega) {
        this.enderecoEntrega = enderecoEntrega;
    }

    @Column(name="NR_SEQUENCIAL_PEDIDO")
    public Integer getNrSequencialPedido() {
        return this.nrSequencialPedido;
    }

    public void setNrSequencialPedido(Integer nrSequencialPedido) {
        this.nrSequencialPedido = nrSequencialPedido;
    }

    @Ignore
    @Column(name="CODIGO_PED_INFORMADO")
    public Long getCodigoPedInformado() {
        return this.codigoPedInformado;
    }

    public void setCodigoPedInformado(Long codigoPedInformado) {
        this.codigoPedInformado = codigoPedInformado;
    }

    @OneToMany(mappedBy="pedido")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<TransferenciaCentroEstoque> getTransferencias() {
        return this.transferencias;
    }

    public void setTransferencias(List<TransferenciaCentroEstoque> transferencias) {
        this.transferencias = transferencias;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE_RESERVA", foreignKey=@ForeignKey(name="FK_PEDIDO_CENTRO_ESTOQUE"))
    public CentroEstoque getCentroEstoqueReserva() {
        return this.centroEstoqueReserva;
    }

    public void setCentroEstoqueReserva(CentroEstoque centroEstoqueReserva) {
        this.centroEstoqueReserva = centroEstoqueReserva;
    }

    @Column(name="PERC_FRETE_INF", precision=15, scale=4)
    public Double getPercFreteInf() {
        return this.percFreteInf;
    }

    public void setPercFreteInf(Double percFreteInf) {
        this.percFreteInf = percFreteInf;
    }

    @Column(name="VALOR_FRETE_INF", precision=15, scale=2)
    public Double getValorFreteInf() {
        return this.valorFreteInf;
    }

    public void setValorFreteInf(Double valorFreteInf) {
        this.valorFreteInf = valorFreteInf;
    }

    @Column(name="PERC_DESCONTO_INF", precision=15, scale=4)
    public Double getPercDescontoInf() {
        return this.percDescontoInf;
    }

    public void setPercDescontoInf(Double percDescontoInf) {
        this.percDescontoInf = percDescontoInf;
    }

    @Column(name="VALOR_DESCONTO_INF", precision=15, scale=2)
    public Double getValorDescontoInf() {
        return this.valorDescontoInf;
    }

    public void setValorDescontoInf(Double valorDescontoInf) {
        this.valorDescontoInf = valorDescontoInf;
    }

    @Column(name="PERC_SEGURO_INF", precision=15, scale=4)
    public Double getPercSeguroInf() {
        return this.percSeguroInf;
    }

    public void setPercSeguroInf(Double percSeguroInf) {
        this.percSeguroInf = percSeguroInf;
    }

    @Column(name="VALOR_SEGURO_INF", precision=15, scale=2)
    public Double getValorSeguroInf() {
        return this.valorSeguroInf;
    }

    public void setValorSeguroInf(Double valorSeguroInf) {
        this.valorSeguroInf = valorSeguroInf;
    }

    @Column(name="PERC_DESP_ACESSORIA_INF", precision=15, scale=4)
    public Double getPercDespAcessoriaInf() {
        return this.percDespAcessoriaInf;
    }

    public void setPercDespAcessoriaInf(Double percDespAcessoriaInf) {
        this.percDespAcessoriaInf = percDespAcessoriaInf;
    }

    @Column(name="VALOR_DESP_ACESSORIA_INF", precision=15, scale=2)
    public Double getValorDespAcessoriaInf() {
        return this.valorDespAcessoriaInf;
    }

    public void setValorDespAcessoriaInf(Double valorDespAcessoriaInf) {
        this.valorDespAcessoriaInf = valorDespAcessoriaInf;
    }

    @Column(name="VALOR_TOTAL_COM_IMPOSTOS", precision=15, scale=2)
    public Double getValorTotalComImpostos() {
        return this.valorTotalComImpostos;
    }

    public void setValorTotalComImpostos(Double valorTotalComImpostos) {
        this.valorTotalComImpostos = valorTotalComImpostos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO_PAI", foreignKey=@ForeignKey(name="FK_PEDIDO_PEDIDO"))
    public Pedido getPedidoPai() {
        return this.pedidoPai;
    }

    public void setPedidoPai(Pedido pedidoPai) {
        this.pedidoPai = pedidoPai;
    }

    @Column(name="TIPO_DATA_TITULO")
    public Short getTipoDataTitulo() {
        return this.tipoDataTitulo;
    }

    public void setTipoDataTitulo(Short tipoDataTitulo) {
        this.tipoDataTitulo = tipoDataTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_EMBARQUE", foreignKey=@ForeignKey(name="FK_PEDIDO_UF_EMBARQUE"))
    public UnidadeFederativa getUfEmbarque() {
        return this.ufEmbarque;
    }

    @Column(name="LOCAL_EMBARQUE", length=60)
    public String getLocalEmbarque() {
        return this.localEmbarque;
    }

    public void setUfEmbarque(UnidadeFederativa ufEmbarque) {
        this.ufEmbarque = ufEmbarque;
    }

    public void setLocalEmbarque(String localEmbarque) {
        this.localEmbarque = localEmbarque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_PEDIDO_USER"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Ignore
    @Column(name="ID_PEDIDO_MOBILE", precision=17, scale=0)
    public BigInteger getIdPedidoMobile() {
        return this.idPedidoMobile;
    }

    public void setIdPedidoMobile(BigInteger idPedidoMobile) {
        this.idPedidoMobile = idPedidoMobile;
    }

    @Column(name="VOLUME_TOTAL", precision=15, scale=3)
    public Double getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(Double volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    @Column(name="TIPO_CONSUMIDOR")
    public Short getTipoConsumidor() {
        return this.tipoConsumidor;
    }

    public void setTipoConsumidor(Short tipoConsumidor) {
        this.tipoConsumidor = tipoConsumidor;
    }

    @Transient
    public Double getValorFaturado() {
        return this.valorFaturado;
    }

    public void setValorFaturado(Double valorFaturado) {
        this.valorFaturado = valorFaturado;
    }

    @Transient
    public Double getValorNaoFaturado() {
        return this.valorNaoFaturado;
    }

    public void setValorNaoFaturado(Double valorNaoFaturado) {
        this.valorNaoFaturado = valorNaoFaturado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO_BONIFICACAO_BRINDE", foreignKey=@ForeignKey(name="FK_PEDIDO_PED_BRINDE"))
    public Pedido getPedidoBonificacaoBrinde() {
        return this.pedidoBonificacaoBrinde;
    }

    public void setPedidoBonificacaoBrinde(Pedido pedidoBonificacaoBrinde) {
        this.pedidoBonificacaoBrinde = pedidoBonificacaoBrinde;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOEDA", foreignKey=@ForeignKey(name="FK_PEDIDO_MOEDA"))
    public Moeda getMoeda() {
        return this.moeda;
    }

    public void setMoeda(Moeda moeda) {
        this.moeda = moeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_MOEDA", foreignKey=@ForeignKey(name="FK_PEDIDO_COTACAO_MOEDA"))
    public CotacaoMoeda getCotacaoMoeda() {
        return this.cotacaoMoeda;
    }

    public void setCotacaoMoeda(CotacaoMoeda cotacaoMoeda) {
        this.cotacaoMoeda = cotacaoMoeda;
    }

    @JoinColumn(name="ID_ARQUIVO_DOC", foreignKey=@ForeignKey(name="FK_PEDIDO_ARQUIVAMENTO_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivoDoc() {
        return this.arquivoDoc;
    }

    public void setArquivoDoc(ArquivamentoDoc arquivoDoc) {
        this.arquivoDoc = arquivoDoc;
    }

    @Column(name="DIAS_MEDIOS_COND_PAG")
    public Short getDiasMediosCondPag() {
        return this.diasMediosCondPag;
    }

    public void setDiasMediosCondPag(Short diasMediosCondPag) {
        this.diasMediosCondPag = diasMediosCondPag;
    }

    @Column(name="OBSERVACAO_USO_INTERNO", length=5000)
    public String getObservacaoUsoInterno() {
        return this.observacaoUsoInterno;
    }

    public void setObservacaoUsoInterno(String observacaoUsoInterno) {
        this.observacaoUsoInterno = observacaoUsoInterno;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="ID_SITUACAO_PED_ANT", foreignKey=@ForeignKey(name="FK_PEDIDO_SIT_PEDIDOS"))
    public SituacaoPedidos getSituacaoPedAnt() {
        return this.situacaoPedAnt;
    }

    public void setSituacaoPedAnt(SituacaoPedidos situacaoPedAnt) {
        this.situacaoPedAnt = situacaoPedAnt;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LIBERACAO_PED_PED", foreignKey=@ForeignKey(name="FK_PEDIDO_LIB_PED_PED"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LiberacaoPedidoPed getLiberacaoPedidoPed() {
        return this.liberacaoPedidoPed;
    }

    public void setLiberacaoPedidoPed(LiberacaoPedidoPed liberacaoPedidoPed) {
        this.liberacaoPedidoPed = liberacaoPedidoPed;
    }

    @Column(nullable=false, name="NR_TOTAL_ITENS")
    public Integer getNrTotalItens() {
        return this.nrTotalItens;
    }

    public void setNrTotalItens(Integer nrTotalItens) {
        this.nrTotalItens = nrTotalItens;
    }

    @Column(nullable=false, name="QTDE_TOTAL_ITENS", precision=15, scale=2)
    public Double getQtdeTotalItens() {
        return this.qtdeTotalItens;
    }

    public void setQtdeTotalItens(Double qtdeTotalItens) {
        this.qtdeTotalItens = qtdeTotalItens;
    }

    @Column(nullable=false, name="VALOR_TOTAL_CUSTO", precision=15, scale=2)
    public Double getVlrTotalCusto() {
        return this.vlrTotalCusto;
    }

    public void setVlrTotalCusto(Double vlrTotalCusto) {
        this.vlrTotalCusto = vlrTotalCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_PEDIDO_MEIO_PAGAMENTO"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LogPedido> getLogsPedido() {
        return this.logsPedido;
    }

    public void setLogsPedido(List<LogPedido> logsPedido) {
        this.logsPedido = logsPedido;
    }

    @JoinColumn(nullable=true, name="ID_UNIFICACAO_PEDIDO", foreignKey=@ForeignKey(name="FK_PEDIDO_UNIFICACAO_PEDIDO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnificacaoPedido getUnificacaoPedido() {
        return this.unificacaoPedido;
    }

    public void setUnificacaoPedido(UnificacaoPedido unificacaoPedido) {
        this.unificacaoPedido = unificacaoPedido;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="pedido")
    public LiberacaoMTC getLiberacaoMTC() {
        return this.liberacaoMTC;
    }

    public void setLiberacaoMTC(LiberacaoMTC liberacaoMTC) {
        this.liberacaoMTC = liberacaoMTC;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_ULT_MOD", foreignKey=@ForeignKey(name="FK_PEDIDO_USER_ULT_MOD"))
    public Usuario getUsuarioUltMod() {
        return this.usuarioUltMod;
    }

    public void setUsuarioUltMod(Usuario usuarioUltMod) {
        this.usuarioUltMod = usuarioUltMod;
    }

    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<InfPagamentoPedido> getInfPagamentoPedido() {
        return this.infPagamentoPedido;
    }

    public void setInfPagamentoPedido(List<InfPagamentoPedido> infPagamentoPedido) {
        this.infPagamentoPedido = infPagamentoPedido;
    }

    @Column(name="NOTA_EMPENHO", length=17)
    public String getNotaEmpenho() {
        return this.notaEmpenho;
    }

    @Column(name="NR_CONTRATO", length=60)
    public String getNrContrato() {
        return this.nrContrato;
    }

    public void setNotaEmpenho(String notaEmpenho) {
        this.notaEmpenho = notaEmpenho;
    }

    public void setNrContrato(String nrContrato) {
        this.nrContrato = nrContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_AUT_DESCONTO", foreignKey=@ForeignKey(name="FK_PEDIDO_USUARIO_AUT_DESC"))
    public Usuario getUsuarioAutorizacaoDesconto() {
        return this.usuarioAutorizacaoDesconto;
    }

    public void setUsuarioAutorizacaoDesconto(Usuario usuarioAutorizacaoDesconto) {
        this.usuarioAutorizacaoDesconto = usuarioAutorizacaoDesconto;
    }

    @Column(name="SERIAL_FOR_SYNC", length=50)
    public String getSerialForSync() {
        return this.serialForSync;
    }

    public void setSerialForSync(String serialForSync) {
        this.serialForSync = serialForSync;
    }

    @Column(nullable=false, name="VALOR_ACRESC_COND_PAG", precision=15, scale=2)
    public Double getValorAcrescCondPagamento() {
        return this.valorAcrescCondPagamento;
    }

    public void setValorAcrescCondPagamento(Double valorAcrescCondPagamento) {
        this.valorAcrescCondPagamento = valorAcrescCondPagamento;
    }

    @Column(nullable=false, name="VALOR_DESC_COND_PAG", precision=15, scale=2)
    public Double getValorDescCondPagamento() {
        return this.valorDescCondPagamento;
    }

    public void setValorDescCondPagamento(Double valorDescCondPagamento) {
        this.valorDescCondPagamento = valorDescCondPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE_CONSUMIDOR", foreignKey=@ForeignKey(name="FK_PEDIDO_NFCE_CONSUMIDOR"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NFCeConsumidor getNfceConsumidor() {
        return this.nfceConsumidor;
    }

    public void setNfceConsumidor(NFCeConsumidor nfceConsumidor) {
        this.nfceConsumidor = nfceConsumidor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_AUTORIZADA", foreignKey=@ForeignKey(name="FK_PEDIDO_PESSOA_AUTORIZADA"))
    public Pessoa getPessoaAutorizada() {
        return this.pessoaAutorizada;
    }

    public void setPessoaAutorizada(Pessoa pessoaAutorizada) {
        this.pessoaAutorizada = pessoaAutorizada;
    }

    @OneToMany(mappedBy="pedido")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NecessidadeCompra> getNecessidadesCompra() {
        return this.necessidadesCompra;
    }

    public void setNecessidadesCompra(List<NecessidadeCompra> necessidadesCompra) {
        this.necessidadesCompra = necessidadesCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_CANCELAMENTO", foreignKey=@ForeignKey(name="FK_PEDIDO_USU_CANCELAMENTO"))
    public Usuario getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    public void setUsuarioCancelamento(Usuario usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=1000)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_CANCELAMENTO")
    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @OneToMany(mappedBy="pedido")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DocumentosRefNFPropriaPed> getNotasPropriasReferenciadas() {
        return this.notasPropriasReferenciadas;
    }

    public void setNotasPropriasReferenciadas(List<DocumentosRefNFPropriaPed> notasPropriasReferenciadas) {
        this.notasPropriasReferenciadas = notasPropriasReferenciadas;
    }

    @Column(name="MODO_RESERVA_ESTOQUE")
    public Short getModoReservaEstoque() {
        return this.modoReservaEstoque;
    }

    public void setModoReservaEstoque(Short modoReservaEstoque) {
        this.modoReservaEstoque = modoReservaEstoque;
    }

    @Column(name="VALOR_TOTAL_BRUTO_DESC_TRIB")
    public Double getValorTotalBrutoDescTrib() {
        return this.valorTotalBrutoDescTrib;
    }

    public void setValorTotalBrutoDescTrib(Double valorTotalBrutoDescTrib) {
        this.valorTotalBrutoDescTrib = valorTotalBrutoDescTrib;
    }

    @Column(name="VALOR_TOTAL_DESC_TRIB")
    public Double getValorTotalDescTrib() {
        return this.valorTotalDescTrib;
    }

    public void setValorTotalDescTrib(Double valorTotalDescTrib) {
        this.valorTotalDescTrib = valorTotalDescTrib;
    }

    @Column(name="VALOR_DESC_FINANCEIRO", precision=15, scale=4)
    public Double getValorDescFinanceiro() {
        return this.valorDescFinanceiro;
    }

    public void setValorDescFinanceiro(Double valorDescFinanceiro) {
        this.valorDescFinanceiro = valorDescFinanceiro;
    }

    @Column(name="TIPO_INTERMEDIADOR_COMERCIAL")
    public Short getTipoIntermediadorComercial() {
        return this.tipoIntermediadorComercial;
    }

    public void setTipoIntermediadorComercial(Short tipoIntermediadorComercial) {
        this.tipoIntermediadorComercial = tipoIntermediadorComercial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTERMEDIADOR_COMERCIAL")
    public IntermediadorComercial getIntermediadorComercial() {
        return this.intermediadorComercial;
    }

    public void setIntermediadorComercial(IntermediadorComercial intermediadorComecial) {
        this.intermediadorComercial = intermediadorComecial;
    }

    @Column(name="IND_PRESENCA_CONSUMIDOR")
    public Short getIndicadorPresencaConsumidor() {
        return this.indicadorPresencaConsumidor;
    }

    public void setIndicadorPresencaConsumidor(Short indicadorPresencaConsumidor) {
        this.indicadorPresencaConsumidor = indicadorPresencaConsumidor;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="pedido")
    public GeracaoTituloPedido getGeracaoTituloPedido() {
        return this.geracaoTituloPedido;
    }

    public void setGeracaoTituloPedido(GeracaoTituloPedido geracaoTituloPedido) {
        this.geracaoTituloPedido = geracaoTituloPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE_FAT", foreignKey=@ForeignKey(name="FK_PEDIDO_CENTRO_ESTOQUE"))
    public CentroEstoque getCentroEstoqueFat() {
        return this.centroEstoqueFat;
    }

    public void setCentroEstoqueFat(CentroEstoque centroEstoqueFat) {
        this.centroEstoqueFat = centroEstoqueFat;
    }

    @Column(name="VALOR_LIMITE_DISP_ANTES_VENDA", precision=15, scale=2)
    public Double getValorLimiteDispAntesVenda() {
        return this.valorLimiteDispAntesVenda;
    }

    public void setValorLimiteDispAntesVenda(Double valorLimiteDispAntesVenda) {
        this.valorLimiteDispAntesVenda = valorLimiteDispAntesVenda;
    }

    @Column(name="VALOR_LIMITE_DISP_POS_VENDA", precision=15, scale=2)
    public Double getValorLimiteDispPosVenda() {
        return this.valorLimiteDispPosVenda;
    }

    public void setValorLimiteDispPosVenda(Double valorLimiteDispPosVenda) {
        this.valorLimiteDispPosVenda = valorLimiteDispPosVenda;
    }

    @Column(name="LIMITE_CREDITO", precision=15, scale=2)
    public Double getLimiteCredito() {
        return this.limiteCredito;
    }

    public void setLimiteCredito(Double limiteCredito) {
        this.limiteCredito = limiteCredito;
    }

    @Column(name="TOTAL_COMPRAS", precision=15, scale=2)
    public Double getTotalCompras() {
        return this.totalCompras;
    }

    public void setTotalCompras(Double totalCompras) {
        this.totalCompras = totalCompras;
    }

    @Column(name="VALOR_DESC_TRIBUTADO", precision=15, scale=2)
    public Double getValorDescontoTrib() {
        return this.valorDescontoTrib;
    }

    public void setValorDescontoTrib(Double valorDescontoTrib) {
        this.valorDescontoTrib = valorDescontoTrib;
    }

    @Column(name="PERC_DESC_TRIBUTADO", precision=15, scale=4)
    public Double getPercDescontoTrib() {
        return this.percDescontoTrib;
    }

    public void setPercDescontoTrib(Double percDescontoTrib) {
        this.percDescontoTrib = percDescontoTrib;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE_CONTROLE_CAIXA", foreignKey=@ForeignKey(name="FK_PEDIDO_NFCE_CONTR_CAIXA"))
    public NFCeControleCaixa getNfceControleCaixa() {
        return this.nfceControleCaixa;
    }

    public void setNfceControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        this.nfceControleCaixa = nfceControleCaixa;
    }

    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY)
    public List<ReceitaAgronomica> getReceitasAgronomicas() {
        return this.receitasAgronomicas;
    }

    public void setReceitasAgronomicas(List<ReceitaAgronomica> receitasAgronomicas) {
        this.receitasAgronomicas = receitasAgronomicas;
    }

    @Transient
    public ReceitaAgronomica getReceituario() {
        return this.receituario;
    }

    public void setReceituario(ReceitaAgronomica receituario) {
        this.receituario = receituario;
    }
}

