/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PEDIDO_ALMOXARIFADO")
public class PedidoAlmoxarifado
implements InterfaceVO {
    private Long identificador;
    private Date dataEmissao;
    private Empresa empresa;
    private Empresa empresaAtendimento;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataAgendamento;
    private String observacao;
    private List<ItemPedidoAlmoxarifado> itensPedido;
    private String utilidade;
    private Usuario usuario;
    private DiagnosticoOSAtivo diagnosticoOS;
    private NaturezaOperacao naturezaOperacao;

    public PedidoAlmoxarifado() {
        this.itensPedido = new ArrayList<ItemPedidoAlmoxarifado>();
    }

    public PedidoAlmoxarifado(Long identificador, Date dataEmissao, Date dataAgendamento, CentroCusto centroCusto, PlanoConta planoConta, Equipamento equipamento, Short atendido) {
        this.identificador = identificador;
        this.dataEmissao = dataEmissao;
        this.dataAgendamento = dataAgendamento;
    }

    public PedidoAlmoxarifado(List itens) {
        this.itensPedido = itens;
    }

    @Column(nullable=false, name="DATA_AGENDAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAgendamento() {
        return this.dataAgendamento;
    }

    public void setDataAgendamento(Date dataAgendamento) {
        this.dataAgendamento = dataAgendamento;
    }

    @Column(name="OBSERVACAO", length=10000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="pedidoAlmoxarifado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemPedidoAlmoxarifado> getItensPedido() {
        return this.itensPedido;
    }

    public void setItensPedido(List itensPedido) {
        this.itensPedido = itensPedido;
    }

    @Id
    @Column(name="ID_PEDIDO_ALMOXARIFADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PEDIDO_ALMOXARIFADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PEDIDO_ALMOXARIFADO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - Obs: {1}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.getDataEmissao()), this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="UTILIDADE", length=5000)
    public String getUtilidade() {
        return this.utilidade;
    }

    public void setUtilidade(String utilidade) {
        this.utilidade = utilidade;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_PEDIDO_ALMOXARIFADO_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToOne(mappedBy="pedidoAlmoxarifado", fetch=FetchType.LAZY)
    public DiagnosticoOSAtivo getDiagnosticoOS() {
        return this.diagnosticoOS;
    }

    public void setDiagnosticoOS(DiagnosticoOSAtivo diagnosticoOS) {
        this.diagnosticoOS = diagnosticoOS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA_ATENDIMENTO", foreignKey=@ForeignKey(name="FK_PEDIDO_ALMOXARIFADO_EMP_ATEN"))
    public Empresa getEmpresaAtendimento() {
        return this.empresaAtendimento;
    }

    public void setEmpresaAtendimento(Empresa empresaAtendimento) {
        this.empresaAtendimento = empresaAtendimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_PEDIDO_ALMOXARIFADO_NAT_OP"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }
}

