/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoPedidoComercio;
import com.touchcomp.basementor.model.vo.ItemPedidoComercio;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoComercio;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PEDIDO_COMERCIO")
public class PedidoComercio
implements InterfaceVO {
    private Long identificador;
    private String observacao;
    private Double percDesconto = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotalBruto = 0.0;
    private Double valorTotal = 0.0;
    private Double percAcrescimo = 0.0;
    private Double valorAcrescimo = 0.0;
    private Date dataEmissao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short statusPedido = 0;
    private Pessoa cliente;
    private Usuario usuario;
    private List<ItemPedidoComercio> itensPedido = new ArrayList<ItemPedidoComercio>();
    private Short tipoDesconto = 0;
    private Short tipoAcrescimo = 0;
    private Usuario usuarioCancelamento;
    private String motivoCancelamento;
    private Usuario usuarioFechamento;
    private FechamentoPedidoComercio fechamentoPedidoComercio;
    private NotaFiscalPropria notaFiscalPropria;
    private Short tipoPedido = 0;
    private Short pedidoBloqueado = 0;
    private LiberacaoPedidoComercio liberacaoPedidoComercio;
    private Short tipoFaturamentoPedido = 0;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private Cliente clientePedido;
    private Representante representante;
    private Double percComissaoMedio = 0.0;
    private Double valorComissao = 0.0;
    private Double valorDescontoInf = 0.0;
    private Double percDescontoInf = 0.0;
    private Double percAcrescimoInf = 0.0;
    private Double valorAcrescimoInf = 0.0;
    private Usuario usuarioAutorizacaoDesconto;
    private Pessoa pessoaAutorizada;
    private Pessoa pessoaIndicante;

    @Id
    @Column(nullable=false, name="ID_PEDIDO_COMERCIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PEDIDO_COMERCIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    @Column(nullable=false, name="PERC_DESCONTO", precision=15, scale=4)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Column(nullable=false, name="VALOR_TOTAL_BRUTO", precision=15, scale=2)
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @Column(nullable=false, name="PERC_ACRESCIMO", precision=15, scale=4)
    public Double getPercAcrescimo() {
        return this.percAcrescimo;
    }

    @Column(nullable=false, name="VALOR_ACRESCIMO", precision=15, scale=2)
    public Double getValorAcrescimo() {
        return this.valorAcrescimo;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setPercAcrescimo(Double percDespAcessoria) {
        this.percAcrescimo = percDespAcessoria;
    }

    public void setValorAcrescimo(Double valorDespAcessoria) {
        this.valorAcrescimo = valorDespAcessoria;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="STATUS_PEDIDO")
    public Short getStatusPedido() {
        return this.statusPedido;
    }

    public void setStatusPedido(Short statusPedido) {
        this.statusPedido = statusPedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_CLIENTE"))
    public Pessoa getCliente() {
        return this.cliente;
    }

    public void setCliente(Pessoa cliente) {
        this.cliente = cliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="pedidoComercio", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemPedidoComercio> getItensPedido() {
        return this.itensPedido;
    }

    public void setItensPedido(List<ItemPedidoComercio> itensPedido) {
        this.itensPedido = itensPedido;
    }

    @Column(name="TIPO_DESCONTO")
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Column(name="TIPO_ACRESCIMO")
    public Short getTipoAcrescimo() {
        return this.tipoAcrescimo;
    }

    public void setTipoAcrescimo(Short tipoAcrescimo) {
        this.tipoAcrescimo = tipoAcrescimo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_CANCELAMENTO", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_USU_CANCELAM"))
    public Usuario getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    public void setUsuarioCancelamento(Usuario usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=500)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_FECHAMENTO", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_FECHAMENTO"))
    public Usuario getUsuarioFechamento() {
        return this.usuarioFechamento;
    }

    public void setUsuarioFechamento(Usuario usuarioFechamento) {
        this.usuarioFechamento = usuarioFechamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FECHAM_PEDIDO_COMERCIO", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_FECHAM_PED"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public FechamentoPedidoComercio getFechamentoPedidoComercio() {
        return this.fechamentoPedidoComercio;
    }

    public void setFechamentoPedidoComercio(FechamentoPedidoComercio fechamentoPedidoComercio) {
        this.fechamentoPedidoComercio = fechamentoPedidoComercio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_NOTA_PROPRIA"))
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.PERSIST})
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @Column(name="TIPO_PEDIDO")
    public Short getTipoPedido() {
        return this.tipoPedido;
    }

    public void setTipoPedido(Short tipoPedido) {
        this.tipoPedido = tipoPedido;
    }

    @Column(name="PEDIDO_BLOQUEADO")
    public Short getPedidoBloqueado() {
        return this.pedidoBloqueado;
    }

    public void setPedidoBloqueado(Short pedidoBloqueado) {
        this.pedidoBloqueado = pedidoBloqueado;
    }

    @OneToOne(mappedBy="pedidoComercio")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public LiberacaoPedidoComercio getLiberacaoPedidoComercio() {
        return this.liberacaoPedidoComercio;
    }

    public void setLiberacaoPedidoComercio(LiberacaoPedidoComercio liberacaoPedidoComercio) {
        this.liberacaoPedidoComercio = liberacaoPedidoComercio;
    }

    @Column(name="TIPO_FATURAMENTO_PEDIDO")
    public Short getTipoFaturamentoPedido() {
        return this.tipoFaturamentoPedido;
    }

    public void setTipoFaturamentoPedido(Short tipoFaturamentoPedido) {
        this.tipoFaturamentoPedido = tipoFaturamentoPedido;
    }

    @OneToMany(mappedBy="pedidoComercio", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE_PEDIDO", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_CLIENTE_PED"))
    public Cliente getClientePedido() {
        return this.clientePedido;
    }

    public void setClientePedido(Cliente clientePedido) {
        this.clientePedido = clientePedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_REPRESENTANT"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @Column(name="PERC_COMISSAO_MEDIO", precision=15, scale=2)
    public Double getPercComissaoMedio() {
        return this.percComissaoMedio;
    }

    public void setPercComissaoMedio(Double percComissaoMedio) {
        this.percComissaoMedio = percComissaoMedio;
    }

    @Column(name="VALOR_COMISSAO", precision=15, scale=2)
    public Double getValorComissao() {
        return this.valorComissao;
    }

    public void setValorComissao(Double valorComissao) {
        this.valorComissao = valorComissao;
    }

    @Column(name="VALOR_DESCONTO_INF", precision=15, scale=2)
    public Double getValorDescontoInf() {
        return this.valorDescontoInf;
    }

    public void setValorDescontoInf(Double valorDescontoInf) {
        this.valorDescontoInf = valorDescontoInf;
    }

    @Column(name="PERC_DESCONTO_INF", precision=15, scale=4)
    public Double getPercDescontoInf() {
        return this.percDescontoInf;
    }

    public void setPercDescontoInf(Double percDescontoInf) {
        this.percDescontoInf = percDescontoInf;
    }

    @Column(name="PERC_ACRESCIMO_INF", precision=15, scale=4)
    public Double getPercAcrescimoInf() {
        return this.percAcrescimoInf;
    }

    public void setPercAcrescimoInf(Double percAcrescimoInf) {
        this.percAcrescimoInf = percAcrescimoInf;
    }

    @Column(name="VALOR_ACRESCIMO_INF", precision=15, scale=2)
    public Double getValorAcrescimoInf() {
        return this.valorAcrescimoInf;
    }

    public void setValorAcrescimoInf(Double valorAcrescimoInf) {
        this.valorAcrescimoInf = valorAcrescimoInf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_AUT_DESCONTO", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_USUAR_DESC"))
    public Usuario getUsuarioAutorizacaoDesconto() {
        return this.usuarioAutorizacaoDesconto;
    }

    public void setUsuarioAutorizacaoDesconto(Usuario usuarioAutorizacaoDesconto) {
        this.usuarioAutorizacaoDesconto = usuarioAutorizacaoDesconto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_AUTORIZADA", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_PESSOA_AUT"))
    public Pessoa getPessoaAutorizada() {
        return this.pessoaAutorizada;
    }

    public void setPessoaAutorizada(Pessoa pessoaAutorizada) {
        this.pessoaAutorizada = pessoaAutorizada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_INDICANTE", foreignKey=@ForeignKey(name="FK_PEDIDO_COMERCIO_INDICANTE"))
    public Pessoa getPessoaIndicante() {
        return this.pessoaIndicante;
    }

    public void setPessoaIndicante(Pessoa pessoaIndicante) {
        this.pessoaIndicante = pessoaIndicante;
    }
}

