/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.pedidostransportes.EnumConstPedidosTransportesStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LogAltVrFretePedTransp;
import com.touchcomp.basementor.model.vo.ProdutoPredominanteCte;
import com.touchcomp.basementor.model.vo.ProgramacaoViagens;
import com.touchcomp.basementor.model.vo.TipoMedidaCargaCte;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFatTransporte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PEDIDOS_TRANSPORTES", uniqueConstraints={@UniqueConstraint(name="UNQ1_PEDIDOS_TRANSPORTES_NUM_PE", columnNames={"NUMERO_PEDIDO"})})
public class PedidosTransportes
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Short status;
    private Date dataEmissao;
    private UnidadeFatCliente tomadorServico;
    private UnidadeFatTransporte remetente;
    private UnidadeFatTransporte destinatario;
    private ProdutoPredominanteCte produtoPredominante;
    private String numeroPedido;
    private Double volume;
    private TipoMedidaCargaCte unidadeMedida;
    private Double valorFrete;
    private Double valorFreteAgregado;
    private Double valorFreteMotorista;
    private Double kmIdaVolta;
    private Long diasViagem;
    private String observacao;
    private String motivoCancelamento;
    private String motivoFechamento;
    private List<ProgramacaoViagens> programacaoViagens;
    private List<LogAltVrFretePedTransp> logAltVrFretePedTransp;

    public PedidosTransportes() {
        this.status = EnumConstPedidosTransportesStatus.ABERTO.value;
        this.volume = 0.0;
        this.valorFrete = 0.0;
        this.valorFreteAgregado = 0.0;
        this.valorFreteMotorista = 0.0;
        this.kmIdaVolta = 0.0;
        this.diasViagem = 0L;
        this.programacaoViagens = new ArrayList<ProgramacaoViagens>();
        this.logAltVrFretePedTransp = new ArrayList<LogAltVrFretePedTransp>();
    }

    @Id
    @Column(nullable=false, name="ID_PEDIDOS_TRANSPORTES")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PEDIDOS_TRANSPORTES")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PEDIDOS_TRANSPORTES_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_TOMADOR_SERVICO", foreignKey=@ForeignKey(name="FK_PEDIDOS_TRANSPORTES_TOM_SER"))
    public UnidadeFatCliente getTomadorServico() {
        return this.tomadorServico;
    }

    public void setTomadorServico(UnidadeFatCliente tomadorServico) {
        this.tomadorServico = tomadorServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_REMETENTE", foreignKey=@ForeignKey(name="FK_PEDIDOS_TRANSPORTES_REMET"))
    public UnidadeFatTransporte getRemetente() {
        return this.remetente;
    }

    public void setRemetente(UnidadeFatTransporte remetente) {
        this.remetente = remetente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_DESTINATARIO", foreignKey=@ForeignKey(name="FK_PEDIDOS_TRANSPORTES_DEST"))
    public UnidadeFatTransporte getDestinatario() {
        return this.destinatario;
    }

    public void setDestinatario(UnidadeFatTransporte destinatario) {
        this.destinatario = destinatario;
    }

    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PRODUTO_PREDOMINANTE", foreignKey=@ForeignKey(name="FK_PEDIDOS_TRANSPORTES_PROD_PRE"))
    public ProdutoPredominanteCte getProdutoPredominante() {
        return this.produtoPredominante;
    }

    public void setProdutoPredominante(ProdutoPredominanteCte produtoPredominante) {
        this.produtoPredominante = produtoPredominante;
    }

    @Column(nullable=false, name="NUMERO_PEDIDO", length=15)
    public String getNumeroPedido() {
        return this.numeroPedido;
    }

    public void setNumeroPedido(String numeroPedido) {
        this.numeroPedido = numeroPedido;
    }

    @Column(nullable=false, name="VOLUME", precision=15, scale=3)
    public Double getVolume() {
        return this.volume;
    }

    public void setVolume(Double volume) {
        this.volume = volume;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_PEDIDOS_TRANSPORTES_UNID_MED"))
    public TipoMedidaCargaCte getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public void setUnidadeMedida(TipoMedidaCargaCte unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=15, scale=4)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @Column(nullable=false, name="VALOR_FRETE_AGREGADO", precision=15, scale=4)
    public Double getValorFreteAgregado() {
        return this.valorFreteAgregado;
    }

    public void setValorFreteAgregado(Double valorFreteAgregado) {
        this.valorFreteAgregado = valorFreteAgregado;
    }

    @Column(nullable=false, name="VALOR_FRETE_MOTORISTA", precision=15, scale=4)
    public Double getValorFreteMotorista() {
        return this.valorFreteMotorista;
    }

    public void setValorFreteMotorista(Double valorFreteMotorista) {
        this.valorFreteMotorista = valorFreteMotorista;
    }

    @Column(nullable=false, name="KM_IDA_VOLTA", precision=15, scale=3)
    public Double getKmIdaVolta() {
        return this.kmIdaVolta;
    }

    public void setKmIdaVolta(Double kmIdaVolta) {
        this.kmIdaVolta = kmIdaVolta;
    }

    @Column(nullable=false, name="DIAS_VIAGEM")
    public Long getDiasViagem() {
        return this.diasViagem;
    }

    public void setDiasViagem(Long diasViagem) {
        this.diasViagem = diasViagem;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=1000)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Column(name="MOTIVO_FECHAMENTO", length=1000)
    public String getMotivoFechamento() {
        return this.motivoFechamento;
    }

    public void setMotivoFechamento(String motivoFechamento) {
        this.motivoFechamento = motivoFechamento;
    }

    @OneToMany(mappedBy="pedidosTransportes", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ProgramacaoViagens> getProgramacaoViagens() {
        return this.programacaoViagens;
    }

    public void setProgramacaoViagens(List<ProgramacaoViagens> programacaoViagens) {
        this.programacaoViagens = programacaoViagens;
    }

    @OneToMany(mappedBy="pedidosTransportes", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LogAltVrFretePedTransp> getLogAltVrFretePedTransp() {
        return this.logAltVrFretePedTransp;
    }

    public void setLogAltVrFretePedTransp(List<LogAltVrFretePedTransp> logAltVrFretePedTransp) {
        this.logAltVrFretePedTransp = logAltVrFretePedTransp;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNumeroPedido()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

