/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NFCeCaixa;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PERIODO_EMISSAO_NFE")
public class PeriodoEmissaoNFe
implements InterfaceVO {
    private Long identificador;
    private Date dataInicial;
    private String descricao;
    private Date dataCadastro;
    private TipoEmissaoNFe tipoEmissaoNfe;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private String serialForSinc;
    private Short origemNFCe = 0;
    private NFCeCaixa nfceCaixa;

    @Id
    @Column(name="ID_PERIODO_EMISSAO_NFE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PERIODO_EMISSAO_NFE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DESCRICAO", length=256)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PERIODO_EMISSAO_NFE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(name="ID_TIPO_EMISSAO_NFE", foreignKey=@ForeignKey(name="FK_PERIODO_EMISSAO_TIPO_EMI_NFE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEmissaoNFe getTipoEmissaoNfe() {
        return this.tipoEmissaoNfe;
    }

    public void setTipoEmissaoNfe(TipoEmissaoNFe tipoEmissaoNfe) {
        this.tipoEmissaoNfe = tipoEmissaoNfe;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} - {2}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao(), ToolDate.dateToStr((Date)this.getDataInicial())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="SERIAL_FOR_SINC", length=100)
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Column(name="ORIGEM_NFCE")
    public Short getOrigemNFCe() {
        return this.origemNFCe;
    }

    public void setOrigemNFCe(Short origemNFCe) {
        this.origemNFCe = origemNFCe;
    }

    @JoinColumn(name="ID_CAIXA_FISCAL", foreignKey=@ForeignKey(name="FK_PERIODO_EMISSAO_NFCE_CAIXA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NFCeCaixa getNfceCaixa() {
        return this.nfceCaixa;
    }

    public void setNfceCaixa(NFCeCaixa nfceCaixa) {
        this.nfceCaixa = nfceCaixa;
    }
}

