/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PERIODO_PRODUCAO")
public class PeriodoProducao
implements InterfaceVO {
    private Long identificador;
    private Date dataInicial;
    private Date dataFinal;
    private Date dataInicialPesqPed;
    private Date dataFinalPesqPed;
    private String descricao;
    private Empresa empresa;
    private Date dataCadastro;
    private Short ativo = 1;
    private Short tipoPesquisaDataPed = 0;

    @Id
    @Column(nullable=false, name="ID_PERIODO_PRODUCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PERIODO_PRODUCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PERIODO_PRODUCAO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_INICIAL_PESQ_PED")
    public Date getDataInicialPesqPed() {
        return this.dataInicialPesqPed;
    }

    public void setDataInicialPesqPed(Date dataInicialPesqPed) {
        this.dataInicialPesqPed = dataInicialPesqPed;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FINAL_PESQ_PEDIDO")
    public Date getDataFinalPesqPed() {
        return this.dataFinalPesqPed;
    }

    public void setDataFinalPesqPed(Date dataFinalPesqPed) {
        this.dataFinalPesqPed = dataFinalPesqPed;
    }

    @Column(name="TIPO_PESQUISA_DATA_PEDIDO")
    public Short getTipoPesquisaDataPed() {
        return this.tipoPesquisaDataPed;
    }

    public void setTipoPesquisaDataPed(Short tipoPesquisaDataPed) {
        this.tipoPesquisaDataPed = tipoPesquisaDataPed;
    }
}

