/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EdicaoPesquisa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.QuestaoPesquisaEfetuada;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PESQUISA_EFETUADA")
public class PesquisaEfetuada
implements InterfaceVO {
    private Long identificador;
    private String observacao;
    private Date dataCadastro;
    private Date dataPesquisa;
    private EdicaoPesquisa edicaoPesquisa;
    private Pessoa pessoa;
    private Pessoa pessoaEmpresa;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Double notaMedia = 0.0;
    private List<QuestaoPesquisaEfetuada> questoesPesquisa = new ArrayList<QuestaoPesquisaEfetuada>();
    private Usuario usuario;
    private Pessoa pessoaReferencia;

    @Id
    @Column(name="ID_PESQUISA_EFETUADA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PESQUISA_EFETUADA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PESQUISA_EFETUADA_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getEdicaoPesquisa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PESQUISA")
    public Date getDataPesquisa() {
        return this.dataPesquisa;
    }

    public void setDataPesquisa(Date dataPesquisa) {
        this.dataPesquisa = dataPesquisa;
    }

    @JoinColumn(name="ID_EDICAO_PESQUISA", foreignKey=@ForeignKey(name="FK_PESQUISA_EFETUADA_ED_PESQUIS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public EdicaoPesquisa getEdicaoPesquisa() {
        return this.edicaoPesquisa;
    }

    public void setEdicaoPesquisa(EdicaoPesquisa pesquisa) {
        this.edicaoPesquisa = pesquisa;
    }

    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_PESQUISA_EFETUADA_PES"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @JoinColumn(name="ID_PESSOA_EMPRESA", foreignKey=@ForeignKey(name="FK_PESQUISA_EFETUADA_PES_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoaEmpresa() {
        return this.pessoaEmpresa;
    }

    public void setPessoaEmpresa(Pessoa pessoaEmpresa) {
        this.pessoaEmpresa = pessoaEmpresa;
    }

    @OneToMany(mappedBy="pesquisaEfetuada")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<QuestaoPesquisaEfetuada> getQuestoesPesquisa() {
        return this.questoesPesquisa;
    }

    public void setQuestoesPesquisa(List<QuestaoPesquisaEfetuada> questoesPesquisa) {
        this.questoesPesquisa = questoesPesquisa;
    }

    @Column(nullable=false, name="NOTA_MEDIA", precision=15, scale=2)
    public Double getNotaMedia() {
        return this.notaMedia;
    }

    public void setNotaMedia(Double notaMedia) {
        this.notaMedia = notaMedia;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_PESQUISA_EFETUADA_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @JoinColumn(name="ID_PESSOA_REFERENCIA", foreignKey=@ForeignKey(name="FK_PESQUISA_EFETUADA_PES_REF"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoaReferencia() {
        return this.pessoaReferencia;
    }

    public void setPessoaReferencia(Pessoa pessoaReferencia) {
        this.pessoaReferencia = pessoaReferencia;
    }
}

