/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.QueryWeb;
import com.touchcomp.basementor.annotations.QueryWebFields;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GeracaoContaPessoa;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.GrupoPessoasRelSub;
import com.touchcomp.basementor.model.vo.PessoaDadosFinanceiros;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="PESSOA")
@QueryWeb(idField="identificador", mask="{0} - {1}({2})", fields={@QueryWebFields(fieldName="nome"), @QueryWebFields(fieldName="nomeFantasia")})
public class Pessoa
implements InterfaceVO {
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();
    private Long identificador;
    private String nome;
    private String nomeFantasia;
    private String pessoaContato;
    private Endereco endereco;
    private Complemento complemento;
    private Timestamp dataAtualizacao;
    private Date dataCadastro = new Date();
    private GrupoPessoas grupoPessoas;
    private Date dataInicioRelacionamento;
    private Endereco enderecoCobranca;
    private String observacao;
    private List<ContaSalarioColaborador> contaSalarioColaborador = new ArrayList<ContaSalarioColaborador>();
    private Double distanciaKm = 0.0;
    private Double longitude = 0.0;
    private Double latitude = 0.0;
    private List<GrupoPessoasRelSub> grupoPessoasRel = new ArrayList<GrupoPessoasRelSub>();
    private Short tipoPessoa;
    private PessoaDadosFinanceiros pessoaDadosFinanceiros;
    private Short usarComoEnderecoCob;
    private GeracaoContaPessoa contasPessoa;

    public Pessoa() {
        this.tipoPessoa = EnumConstTipoPessoa.PESSOA_PRIMARIA.value;
        this.usarComoEnderecoCob = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(name="ID_PESSOA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PESSOA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="NOME", length=150)
    public String getNome() {
        return this.nome;
    }

    @Column(name="NOME_FANTASIA", length=60)
    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    @Column(nullable=true, name="PESSOA_CONTATO", length=60)
    public String getPessoaContato() {
        return this.pessoaContato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_ENDERECO", foreignKey=@ForeignKey(name="FK_PESSOA_ENDERECO"))
    @Fetch(value=FetchMode.JOIN)
    public Endereco getEndereco() {
        return this.endereco;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_COMPLEMENTO", foreignKey=@ForeignKey(name="FK_PESSOA_COMPLEMENTO"))
    public Complemento getComplemento() {
        return this.complemento;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setComplemento(Complemento complemento) {
        this.complemento = complemento;
    }

    public void setPessoaContato(String pessoaContato) {
        this.pessoaContato = pessoaContato;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_PESSOAS", foreignKey=@ForeignKey(name="FK_PESSOA_GRUPO_PESSOAS"))
    public GrupoPessoas getGrupoPessoas() {
        return this.grupoPessoas;
    }

    public void setGrupoPessoas(GrupoPessoas grupoPessoas) {
        this.grupoPessoas = grupoPessoas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIO_RELACIONAMENTO")
    public Date getDataInicioRelacionamento() {
        return this.dataInicioRelacionamento;
    }

    public void setDataInicioRelacionamento(Date dataInicioRelacionamento) {
        this.dataInicioRelacionamento = dataInicioRelacionamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_ENDERECO_COBRANCA", foreignKey=@ForeignKey(name="FK_PESSOA_ENDERECO_COBRANCA"))
    public Endereco getEnderecoCobranca() {
        return this.enderecoCobranca;
    }

    public void setEnderecoCobranca(Endereco enderecoCobranca) {
        this.enderecoCobranca = enderecoCobranca;
    }

    @Column(name="OBSERVACAO")
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="pessoa", fetch=FetchType.LAZY, targetEntity=ContaSalarioColaborador.class)
    public List<ContaSalarioColaborador> getContaSalarioColaborador() {
        return this.contaSalarioColaborador;
    }

    public void setContaSalarioColaborador(List<ContaSalarioColaborador> contaSalarioColaborador) {
        this.contaSalarioColaborador = contaSalarioColaborador;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Column(name="LONGITUDE", precision=15, scale=7)
    public Double getLongitude() {
        return this.longitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Column(name="DISTANCIA_KM", precision=15, scale=2)
    public Double getDistanciaKm() {
        return this.distanciaKm;
    }

    public void setDistanciaKm(Double distanciaKm) {
        this.distanciaKm = distanciaKm;
    }

    @Column(nullable=false, name="LATITUDE", precision=15, scale=7)
    public Double getLatitude() {
        return this.latitude;
    }

    @OneToMany(mappedBy="pessoa", fetch=FetchType.LAZY)
    public List<GrupoPessoasRelSub> getGrupoPessoasRel() {
        return this.grupoPessoasRel;
    }

    public void setGrupoPessoasRel(List<GrupoPessoasRelSub> grupoPessoasRel) {
        this.grupoPessoasRel = grupoPessoasRel;
    }

    @Column(name="TIPO_PESSOA")
    public Short getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(Short tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_PESSOA_DADOS_FINANCEIROS", foreignKey=@ForeignKey(name="FK_PESSOA_PESS_DADOS_FIN"))
    public PessoaDadosFinanceiros getPessoaDadosFinanceiros() {
        return this.pessoaDadosFinanceiros;
    }

    public void setPessoaDadosFinanceiros(PessoaDadosFinanceiros pessoaDadosFinanceiros) {
        this.pessoaDadosFinanceiros = pessoaDadosFinanceiros;
    }

    @Column(name="USAR_COMO_ENDERECO_COB")
    public Short getUsarComoEnderecoCob() {
        return this.usarComoEnderecoCob;
    }

    public void setUsarComoEnderecoCob(Short usarComoEnderecoCob) {
        this.usarComoEnderecoCob = usarComoEnderecoCob;
    }

    @OneToOne(mappedBy="pessoa", cascade={CascadeType.REMOVE})
    @Fetch(value=FetchMode.SELECT)
    public GeracaoContaPessoa getContasPessoa() {
        return this.contasPessoa;
    }

    public void setContasPessoa(GeracaoContaPessoa contasPessoa) {
        this.contasPessoa = contasPessoa;
    }
}

