/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatTransporte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="PESSOA_TRANSPORTE", uniqueConstraints={@UniqueConstraint(name="UNQ1_PESSOA_TRANSPORTE", columnNames={"ID_PESSOA"})})
public class PessoaTransporte
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<UnidadeFatTransporte> unidadeFatTransporte = new ArrayList<UnidadeFatTransporte>();

    @Id
    @Column(nullable=false, name="ID_PESSOA_TRANSPORTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PESSOA_TRANSPORTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.SAVE_UPDATE})
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_PESSOA_TRANSPORTE_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PESSOA_TRANSPORTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="pessoaTransporte")
    @Cascade(value={CascadeType.MERGE, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    public List<UnidadeFatTransporte> getUnidadeFatTransporte() {
        return this.unidadeFatTransporte;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setUnidadeFatTransporte(List<UnidadeFatTransporte> unidadeFatTransporte) {
        this.unidadeFatTransporte = unidadeFatTransporte;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

