/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DiaPlanejTempoTrabalhoPCP;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanejTempoTrabalhoPCPCelProdutiva;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="PLANEJ_TEMPO_TRAB_PCP")
public class PlanejTempoTrabalhoPCP
implements InterfaceVO {
    private Long identificador;
    private Date periodo;
    private String descricao;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;
    private Double totalHoras = 0.0;
    private List<DiaPlanejTempoTrabalhoPCP> diaPlanejTempoTrabalhoPCP = new ArrayList<DiaPlanejTempoTrabalhoPCP>();
    private List<PlanejTempoTrabalhoPCPCelProdutiva> celulasProdutivas = new ArrayList<PlanejTempoTrabalhoPCPCelProdutiva>();

    @Id
    @Column(nullable=false, name="ID_PLANEJ_TEMPO_TRAB_PCP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PLANEJ_TEMPO_TRAB_PCP")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="PERIODO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Column(name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PLANEJ_TEMPO_TRAB_PCP_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="TOTAL_HORAS", precision=15, scale=2)
    public Double getTotalHoras() {
        return this.totalHoras;
    }

    public void setTotalHoras(Double totalHoras) {
        this.totalHoras = totalHoras;
    }

    @OneToMany(mappedBy="planejTempoTrabalhoPCP", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<DiaPlanejTempoTrabalhoPCP> getDiaPlanejTempoTrabalhoPCP() {
        return this.diaPlanejTempoTrabalhoPCP;
    }

    public void setDiaPlanejTempoTrabalhoPCP(List<DiaPlanejTempoTrabalhoPCP> diaPlanejTempoTrabalhoPCP) {
        this.diaPlanejTempoTrabalhoPCP = diaPlanejTempoTrabalhoPCP;
    }

    @OneToMany(mappedBy="planejTempoTrabalhoPCP", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<PlanejTempoTrabalhoPCPCelProdutiva> getCelulasProdutivas() {
        return this.celulasProdutivas;
    }

    public void setCelulasProdutivas(List<PlanejTempoTrabalhoPCPCelProdutiva> celulasProdutivas) {
        this.celulasProdutivas = celulasProdutivas;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

