/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoPlanoConta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NaturezaOperacaPC;
import com.touchcomp.basementor.model.vo.PlanoContaContabilSped;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="PLANO_CONTA")
public class PlanoConta
implements InterfaceVO,
Comparable {
    private Long identificador;
    private String codigo;
    private Integer marca;
    private String reduzida;
    private String seq;
    private String descricao;
    private Empresa empresa;
    private Date dataCadastro;
    private NaturezaOperacaPC naturezaOperacaoPC;
    private List<PlanoContaContabilSped> planoContaContabilSped;
    private ClassificacaoPlanoConta classificacaoPlanoConta;
    private Short ativo;

    public PlanoConta(Long identificador, String codigo, Integer marca, String reduzida, String seq, String descricao, Date dataCadastro) {
        this.identificador = identificador;
        this.codigo = codigo;
        this.marca = marca;
        this.reduzida = reduzida;
        this.seq = seq;
        this.descricao = descricao;
        this.dataCadastro = dataCadastro;
        this.planoContaContabilSped = new ArrayList<PlanoContaContabilSped>();
    }

    public PlanoConta() {
        this.planoContaContabilSped = new ArrayList<PlanoContaContabilSped>();
        this.marca = EnumConstSinteticoAnalitico.ANALITICO.getValueInt();
        this.ativo = 1;
    }

    @Id
    @Column(name="ID_PLANO_CONTA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PLANO_CONTA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="CODIGO", length=10)
    public String getCodigo() {
        return this.codigo;
    }

    @Column(name="MARCA")
    public Integer getMarca() {
        return this.marca;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="REDUZIDA", length=5)
    public String getReduzida() {
        return this.reduzida;
    }

    @Column(name="SEQ", length=10)
    public String getSeq() {
        return this.seq;
    }

    @Column(name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMP", foreignKey=@ForeignKey(name="FK_PLANO_CONTA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setMarca(Integer marca) {
        this.marca = marca;
    }

    public void setReduzida(String reduzida) {
        this.reduzida = reduzida;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigo(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public int compareTo(Object o) {
        if (!(o instanceof PlanoConta)) {
            return 1;
        }
        PlanoConta pc = (PlanoConta)o;
        return this.getCodigo().compareTo(pc.getCodigo());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_PLANO_CONTA_NAT_OP_PC"))
    public NaturezaOperacaPC getNaturezaOperacaoPC() {
        return this.naturezaOperacaoPC;
    }

    public void setNaturezaOperacaoPC(NaturezaOperacaPC naturezaOperacaoPC) {
        this.naturezaOperacaoPC = naturezaOperacaoPC;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="planoConta", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<PlanoContaContabilSped> getPlanoContaContabilSped() {
        return this.planoContaContabilSped;
    }

    public void setPlanoContaContabilSped(List<PlanoContaContabilSped> planoContaContabilSped) {
        this.planoContaContabilSped = planoContaContabilSped;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_PLANO_CONTA_CLASSIFICACAO"))
    public ClassificacaoPlanoConta getClassificacaoPlanoConta() {
        return this.classificacaoPlanoConta;
    }

    public void setClassificacaoPlanoConta(ClassificacaoPlanoConta classificacaoPlanoConta) {
        this.classificacaoPlanoConta = classificacaoPlanoConta;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

