/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.SetorExecutanteServicos;
import com.touchcomp.basementor.model.vo.TipoControle;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementor.model.vo.TipoServico;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PLANO_MANUTENCAO_ATIVO", uniqueConstraints={@UniqueConstraint(name="UNQ1_PLANO_MANUTENCAO_ATIVO", columnNames={"DESCRICAO", "ID_EMPRESA"})})
public class PlanoManutencaoAtivo
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short ativo = 1;
    private String descricao;
    private Short prioridade = 0;
    private Integer periodicidade = 0;
    private Integer limiteAlerta = 0;
    private Integer limite = 0;
    private TipoServico tipoServico;
    private TipoControle tipoControle;
    private TipoPontoControle tipoPontoControle;
    private List<SetorExecutanteServicos> setorExecutantesServicos = new ArrayList<SetorExecutanteServicos>();
    private List<AtivoDataUltimaManutencao> ativos = new ArrayList<AtivoDataUltimaManutencao>();
    private Short reservarEstoque = 0;

    @Id
    @Column(nullable=false, name="ID_PLANO_MANUTENCAO_ATIVO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PLANO_MANUTENCAO_ATIVO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PLANO_MAN_ATIVO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="PRIORIDADE")
    public Short getPrioridade() {
        return this.prioridade;
    }

    public void setPrioridade(Short prioridade) {
        this.prioridade = prioridade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CONTROLE", foreignKey=@ForeignKey(name="FK_PLANO_MAN_ATIVO_TP_CONT"))
    public TipoControle getTipoControle() {
        return this.tipoControle;
    }

    public void setTipoControle(TipoControle tipoControle) {
        this.tipoControle = tipoControle;
    }

    @Column(name="PERIODICIDADE")
    public Integer getPeriodicidade() {
        return this.periodicidade;
    }

    public void setPeriodicidade(Integer periodicidade) {
        this.periodicidade = periodicidade;
    }

    @Column(name="LIMITE_ALERTA")
    public Integer getLimiteAlerta() {
        return this.limiteAlerta;
    }

    public void setLimiteAlerta(Integer limiteAlerta) {
        this.limiteAlerta = limiteAlerta;
    }

    @Column(name="LIMITE")
    public Integer getLimite() {
        return this.limite;
    }

    public void setLimite(Integer limite) {
        this.limite = limite;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SERVICO", foreignKey=@ForeignKey(name="FK_PLANO_MAN_ATIVO_TP_SERVICO"))
    public TipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(TipoServico tipoServico) {
        this.tipoServico = tipoServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PONTO_CONTROLE", foreignKey=@ForeignKey(name="FK_PLANO_MAN_ATIVO_TP_PON_CONTR"))
    public TipoPontoControle getTipoPontoControle() {
        return this.tipoPontoControle;
    }

    public void setTipoPontoControle(TipoPontoControle tipoPontoControle) {
        this.tipoPontoControle = tipoPontoControle;
    }

    @OneToMany(mappedBy="planoManutencaoAtivo", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<SetorExecutanteServicos> getSetorExecutantesServicos() {
        return this.setorExecutantesServicos;
    }

    public void setSetorExecutantesServicos(List<SetorExecutanteServicos> setorExecutantesServicos) {
        this.setorExecutantesServicos = setorExecutantesServicos;
    }

    @OneToMany(mappedBy="planoManutencaoAtivo", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<AtivoDataUltimaManutencao> getAtivos() {
        return this.ativos;
    }

    @Column(name="RESERVAR_ESTOQUE")
    public Short getReservarEstoque() {
        return this.reservarEstoque;
    }

    public void setReservarEstoque(Short reservarEstoque) {
        this.reservarEstoque = reservarEstoque;
    }

    public void setAtivos(List<AtivoDataUltimaManutencao> ativos) {
        this.ativos = ativos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

