/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ModeloPneu;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Recap;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="PNEU", uniqueConstraints={@UniqueConstraint(name="UNQ_PNEU_0", columnNames={"NUMERO_FOGO"})})
public class Pneu
implements InterfaceVO {
    private Long identificador;
    private String serie;
    private String numeroFogo;
    private String codigoDOT;
    private Produto produto;
    private ItemNotaTerceiros itemNotaTerceiros;
    private Empresa empresa;
    private Recap recap;
    private Double sulco = 0.0;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private ModeloPneu modeloPneu;
    private String desenhoPneu;

    @Id
    @Column(name="ID_PNEU")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PNEU")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="SERIE", length=100)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(name="NUMERO_FOGO", length=20)
    public String getNumeroFogo() {
        return this.numeroFogo;
    }

    public void setNumeroFogo(String numeroFogo) {
        this.numeroFogo = numeroFogo;
    }

    @Column(name="CODIGO_DOT", length=8)
    public String getCodigoDOT() {
        return this.codigoDOT;
    }

    public void setCodigoDOT(String codigoDOT) {
        this.codigoDOT = codigoDOT;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_PNEU_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_PNEU_ITEM_NOTA_TERC"))
    public ItemNotaTerceiros getItemNotaFiscalTerceiros() {
        return this.itemNotaTerceiros;
    }

    public void setItemNotaFiscalTerceiros(ItemNotaTerceiros itemNotaFiscalTerceiros) {
        this.itemNotaTerceiros = itemNotaFiscalTerceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PNEU_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RECAP", foreignKey=@ForeignKey(name="FK_PNEU_RECAP"))
    public Recap getRecap() {
        return this.recap;
    }

    public void setRecap(Recap recap) {
        this.recap = recap;
    }

    @Column(nullable=false, name="SULCO", precision=10, scale=4)
    public Double getSulco() {
        return this.sulco;
    }

    public void setSulco(Double sulco) {
        this.sulco = sulco;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_PNEU", foreignKey=@ForeignKey(name="FK_PNEU_4"))
    public ModeloPneu getModeloPneu() {
        return this.modeloPneu;
    }

    public void setModeloPneu(ModeloPneu modeloPneu) {
        this.modeloPneu = modeloPneu;
    }

    @Column(name="DESENHO_PNEU", length=11)
    public String getDesenhoPneu() {
        return this.desenhoPneu;
    }

    public void setDesenhoPneu(String desenhoPneu) {
        this.desenhoPneu = desenhoPneu;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getProduto() != null) {
            sb.append("Prod: ");
            sb.append(this.getProduto().getIdentificador());
            sb.append("-");
            sb.append(this.getProduto().getNome());
        }
        if (this.getSerie() != null) {
            sb.append("  Serie: ");
            sb.append(this.getSerie());
        }
        if (this.getNumeroFogo() != null) {
            sb.append("  Nr. Fogo: ");
            sb.append(this.getNumeroFogo());
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{sb});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

