/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PreAcuracidadeEstItem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PRE_ACURACIDADE_ESTOQUE")
public class PreAcuracidadeEst
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Date dataApuracidadeEstoque;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private CentroEstoque centroEstoque;
    private List<PreAcuracidadeEstItem> itens = new ArrayList<PreAcuracidadeEstItem>();
    private ApuracidadeEstoque apuracidadeEstoque;

    @Id
    @Column(nullable=false, unique=true, name="ID_PRE_ACURACIDADE_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRE_ACURACIDADE_ESTOQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ACURACIDADE_ESTOQUE")
    public Date getDataApuracidadeEstoque() {
        return this.dataApuracidadeEstoque;
    }

    public void setDataApuracidadeEstoque(Date dataApuracidadeEstoque) {
        this.dataApuracidadeEstoque = dataApuracidadeEstoque;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRE_ACURACIDADE_ESTOQUE_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_PRE_ACURACIDADE_ESTOQUE_CEN"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="preAcuracidadeEstoque")
    @Cascade(value={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DELETE_ORPHAN})
    public List<PreAcuracidadeEstItem> getItens() {
        return this.itens;
    }

    public void setItens(List<PreAcuracidadeEstItem> itens) {
        this.itens = itens;
    }

    @JoinColumn(name="ID_APURACIDADE_ESTOQUE", foreignKey=@ForeignKey(name="FK_PRE_ACURACIDADE_ESTOQUE_APU"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ApuracidadeEstoque getApuracidadeEstoque() {
        return this.apuracidadeEstoque;
    }

    public void setApuracidadeEstoque(ApuracidadeEstoque apuracidadeEstoque) {
        this.apuracidadeEstoque = apuracidadeEstoque;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

