/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ClassificacaoColaborador;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.EsocRegimeJornadaTrab;
import com.touchcomp.basementor.model.vo.EstadoCivil;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GrauInstrucao;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.LocalTrabalhoColaborador;
import com.touchcomp.basementor.model.vo.PreCadastroColabDadosBanc;
import com.touchcomp.basementor.model.vo.PreCadastroColabDependentes;
import com.touchcomp.basementor.model.vo.RacaCor;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementor.model.vo.TipoDeficiencia;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PRE_CADASTRO_COLABORADOR")
public class PreCadastroColaborador
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private Date dataCadastro;
    private String numeroRegistro;
    private CentroCusto centroCusto;
    private Funcao funcao;
    private Date dataAdmissao;
    private GrauInstrucao grauInstrucao;
    private EstadoCivil estadoCivil;
    private TipoColaborador tipoColaborador;
    private String nomeMae;
    private String nomePai;
    private RacaCor racaCor;
    private TipoDeficiencia tipoDeficiencia;
    private String numeroPis;
    private String carteiraProfissional;
    private String serieCarteira;
    private UnidadeFederativa ufCarteira;
    private String diasExperiencia;
    private String telefoneContato;
    private HorarioTrabalho horarioTrabalho;
    private EsocRegimeJornadaTrab regimeJornada;
    private String cpf;
    private Short ergonometria = 0;
    private Short possuiDoenca = 0;
    private String doenca;
    private Short treinamentoLocal = 0;
    private String referencia;
    private String experiencia;
    private String observacao;
    private Date dataExame;
    private String rg;
    private Short possuiValeTransporte = 0;
    private Double qtdadeValeTransporte = 0.0;
    private ClassificacaoColaborador classificacaoColaborador;
    private LocalTrabalhoColaborador localTrabalho;
    private Short recebimentoSeguroDesemprego = 0;
    private Endereco endereco;
    private List<PreCadastroColabDependentes> dependentes = new ArrayList<PreCadastroColabDependentes>();
    private List<PreCadastroColabDadosBanc> dadosBancarios = new ArrayList<PreCadastroColabDadosBanc>();
    private Date dataNascimento;
    private String celular;
    private String nomeConjugue;
    private String cpfConjugue;
    private Date dataNascimentoConjugue;
    private Date dataCarteiraProfissional;
    private String naturalidade;
    private String orgaoExpedidorRG;
    private String cnh;
    private String categoriaCnh;
    private Date dataValidadeCnh;
    private Short valeRefeicao = 0;
    private Short valeAlimentacao = 0;
    private String onibusUtilizado;
    private Double valorPassagem = 0.0;
    private ContratoLocacao contratoLocacao;
    private String email;

    @Id
    @Column(nullable=false, unique=true, name="ID_PRE_CADASTRO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRE_CADASTRO_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="NUMERO_REGISTRO", length=50)
    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    public void setNumeroRegistro(String numeroRegistro) {
        this.numeroRegistro = numeroRegistro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_CENT_CUST"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_FUNCAO"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ADMISSAO")
    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public void setDataAdmissao(Date dataAdmissao) {
        this.dataAdmissao = dataAdmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRAU_INSTRUCAO", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_GRAU_INST"))
    public GrauInstrucao getGrauInstrucao() {
        return this.grauInstrucao;
    }

    public void setGrauInstrucao(GrauInstrucao grauInstrucao) {
        this.grauInstrucao = grauInstrucao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESTADO_CIVIL", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_EST_CIVIL"))
    public EstadoCivil getEstadoCivil() {
        return this.estadoCivil;
    }

    public void setEstadoCivil(EstadoCivil estadoCivil) {
        this.estadoCivil = estadoCivil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_COLABORADOR", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_TP_COLAB"))
    public TipoColaborador getTipoColaborador() {
        return this.tipoColaborador;
    }

    public void setTipoColaborador(TipoColaborador tipoColaborador) {
        this.tipoColaborador = tipoColaborador;
    }

    @Column(name="NOME_MAE", length=500)
    public String getNomeMae() {
        return this.nomeMae;
    }

    public void setNomeMae(String nomeMae) {
        this.nomeMae = nomeMae;
    }

    @Column(name="NOME_PAI", length=500)
    public String getNomePai() {
        return this.nomePai;
    }

    public void setNomePai(String nomePai) {
        this.nomePai = nomePai;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RACA_COR", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_RACA_COR"))
    public RacaCor getRacaCor() {
        return this.racaCor;
    }

    public void setRacaCor(RacaCor racaCor) {
        this.racaCor = racaCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DEFICIENCIA", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_TP_DEF"))
    public TipoDeficiencia getTipoDeficiencia() {
        return this.tipoDeficiencia;
    }

    public void setTipoDeficiencia(TipoDeficiencia tipoDeficiencia) {
        this.tipoDeficiencia = tipoDeficiencia;
    }

    @Column(name="NUMERO_PIS", length=50)
    public String getNumeroPis() {
        return this.numeroPis;
    }

    public void setNumeroPis(String numeroPis) {
        this.numeroPis = numeroPis;
    }

    @Column(name="CARTEIRA_PROFISSIONAL", length=50)
    public String getCarteiraProfissional() {
        return this.carteiraProfissional;
    }

    public void setCarteiraProfissional(String carteiraProfissional) {
        this.carteiraProfissional = carteiraProfissional;
    }

    @Column(name="SERIE_CARTEIRA", length=10)
    public String getSerieCarteira() {
        return this.serieCarteira;
    }

    public void setSerieCarteira(String serieCarteira) {
        this.serieCarteira = serieCarteira;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_CARTEIRA", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_UF_CARTEI"))
    public UnidadeFederativa getUfCarteira() {
        return this.ufCarteira;
    }

    public void setUfCarteira(UnidadeFederativa ufCarteira) {
        this.ufCarteira = ufCarteira;
    }

    @Column(name="DIAS_EXPERIENCIA", length=50)
    public String getDiasExperiencia() {
        return this.diasExperiencia;
    }

    public void setDiasExperiencia(String diasExperiencia) {
        this.diasExperiencia = diasExperiencia;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NOME", length=100)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @Column(name="TELEFONE_CONTATO", length=20)
    public String getTelefoneContato() {
        return this.telefoneContato;
    }

    public void setTelefoneContato(String telefoneContato) {
        this.telefoneContato = telefoneContato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HORARIO_TRABALHO", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLABORADOR_10"))
    public HorarioTrabalho getHorarioTrabalho() {
        return this.horarioTrabalho;
    }

    public void setHorarioTrabalho(HorarioTrabalho horarioTrabalho) {
        this.horarioTrabalho = horarioTrabalho;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_JORNADA", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLABORADOR_11"))
    public EsocRegimeJornadaTrab getRegimeJornada() {
        return this.regimeJornada;
    }

    public void setRegimeJornada(EsocRegimeJornadaTrab regimeJornada) {
        this.regimeJornada = regimeJornada;
    }

    @Column(name="CPF", length=11)
    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @Column(name="ERGONOMETRIA")
    public Short getErgonometria() {
        return this.ergonometria;
    }

    public void setErgonometria(Short ergonometria) {
        this.ergonometria = ergonometria;
    }

    @Column(name="POSSUI_DOENCA")
    public Short getPossuiDoenca() {
        return this.possuiDoenca;
    }

    public void setPossuiDoenca(Short possuiDoenca) {
        this.possuiDoenca = possuiDoenca;
    }

    @Column(name="DOENCA", length=500)
    public String getDoenca() {
        return this.doenca;
    }

    public void setDoenca(String doenca) {
        this.doenca = doenca;
    }

    @Column(name="TREINAMENTO_LOCAL")
    public Short getTreinamentoLocal() {
        return this.treinamentoLocal;
    }

    public void setTreinamentoLocal(Short treinamentoLocal) {
        this.treinamentoLocal = treinamentoLocal;
    }

    @Column(name="REFERENCIA", length=500)
    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    @Column(name="EXPERIENCIA", length=100)
    public String getExperiencia() {
        return this.experiencia;
    }

    public void setExperiencia(String experiencia) {
        this.experiencia = experiencia;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DATA_EXAME")
    @Temporal(value=TemporalType.DATE)
    public Date getDataExame() {
        return this.dataExame;
    }

    public void setDataExame(Date dataExame) {
        this.dataExame = dataExame;
    }

    @Column(name="RG", length=21)
    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    @Column(name="POSSUI_VALE_TRANSPORTE")
    public Short getPossuiValeTransporte() {
        return this.possuiValeTransporte;
    }

    public void setPossuiValeTransporte(Short possuiValeTransporte) {
        this.possuiValeTransporte = possuiValeTransporte;
    }

    @Column(name="QTDADE_VALE_TRANSPORTE", precision=15, scale=2)
    public Double getQtdadeValeTransporte() {
        return this.qtdadeValeTransporte;
    }

    public void setQtdadeValeTransporte(Double qtdadeValeTransporte) {
        this.qtdadeValeTransporte = qtdadeValeTransporte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_COLABORADOR", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_CLASSIFI_COLABO"))
    public ClassificacaoColaborador getClassificacaoColaborador() {
        return this.classificacaoColaborador;
    }

    public void setClassificacaoColaborador(ClassificacaoColaborador classificacaoColaborador) {
        this.classificacaoColaborador = classificacaoColaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCAL_TRABALHO", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_LOCAL_TRABALHO"))
    public LocalTrabalhoColaborador getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(LocalTrabalhoColaborador localTrabalho) {
        this.localTrabalho = localTrabalho;
    }

    @Column(name="RECEBIMENTO_SEGURO_DESEMPREGO")
    public Short getRecebimentoSeguroDesemprego() {
        return this.recebimentoSeguroDesemprego;
    }

    public void setRecebimentoSeguroDesemprego(Short recebimentoSeguroDesemprego) {
        this.recebimentoSeguroDesemprego = recebimentoSeguroDesemprego;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_ENDERECO", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_ENDERECO"))
    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    @OneToMany(mappedBy="preCadastroColaborador", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<PreCadastroColabDependentes> getDependentes() {
        return this.dependentes;
    }

    public void setDependentes(List<PreCadastroColabDependentes> dependentes) {
        this.dependentes = dependentes;
    }

    @OneToMany(mappedBy="preCadastroColaborador", orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<PreCadastroColabDadosBanc> getDadosBancarios() {
        return this.dadosBancarios;
    }

    public void setDadosBancarios(List<PreCadastroColabDadosBanc> dadosBancarios) {
        this.dadosBancarios = dadosBancarios;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_NASCIMENTO")
    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    @Column(name="CELULAR", length=20)
    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    @Column(name="NOME_CONJUGUE", length=300)
    public String getNomeConjugue() {
        return this.nomeConjugue;
    }

    public void setNomeConjugue(String nomeConjugue) {
        this.nomeConjugue = nomeConjugue;
    }

    @Column(name="CPF_CONJUGUE", length=20)
    public String getCpfConjugue() {
        return this.cpfConjugue;
    }

    public void setCpfConjugue(String cpfConjugue) {
        this.cpfConjugue = cpfConjugue;
    }

    @Column(name="DATA_NASCIMENTO_CONJUGUE")
    public Date getDataNascimentoConjugue() {
        return this.dataNascimentoConjugue;
    }

    public void setDataNascimentoConjugue(Date dataNascimentoConjugue) {
        this.dataNascimentoConjugue = dataNascimentoConjugue;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CARTEIRA_PROFISSIONAL")
    public Date getDataCarteiraProfissional() {
        return this.dataCarteiraProfissional;
    }

    public void setDataCarteiraProfissional(Date dataCarteiraProfissional) {
        this.dataCarteiraProfissional = dataCarteiraProfissional;
    }

    @Column(name="NATURALIDADE", length=200)
    public String getNaturalidade() {
        return this.naturalidade;
    }

    public void setNaturalidade(String naturalidade) {
        this.naturalidade = naturalidade;
    }

    @Column(name="ORGAO_EXPEDIDOR_RG", length=50)
    public String getOrgaoExpedidorRG() {
        return this.orgaoExpedidorRG;
    }

    public void setOrgaoExpedidorRG(String orgaoExpedidorRG) {
        this.orgaoExpedidorRG = orgaoExpedidorRG;
    }

    @Column(name="CNH", length=20)
    public String getCnh() {
        return this.cnh;
    }

    public void setCnh(String cnh) {
        this.cnh = cnh;
    }

    @Column(name="CATEGORIA_CNH", length=10)
    public String getCategoriaCnh() {
        return this.categoriaCnh;
    }

    public void setCategoriaCnh(String categoriaCnh) {
        this.categoriaCnh = categoriaCnh;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VALIDADE_CNH")
    public Date getDataValidadeCnh() {
        return this.dataValidadeCnh;
    }

    public void setDataValidadeCnh(Date dataValidadeCnh) {
        this.dataValidadeCnh = dataValidadeCnh;
    }

    @Column(name="VALE_REFEICAO")
    public Short getValeRefeicao() {
        return this.valeRefeicao;
    }

    public void setValeRefeicao(Short valeRefeicao) {
        this.valeRefeicao = valeRefeicao;
    }

    @Column(name="VALE_ALIMENTACAO")
    public Short getValeAlimentacao() {
        return this.valeAlimentacao;
    }

    public void setValeAlimentacao(Short valeAlimentacao) {
        this.valeAlimentacao = valeAlimentacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_PRE_CADASTRO_COLAB_CONT_LOCA"))
    public ContratoLocacao getContratoLocacao() {
        return this.contratoLocacao;
    }

    public void setContratoLocacao(ContratoLocacao contratoLocacao) {
        this.contratoLocacao = contratoLocacao;
    }

    @Column(name="ONIBUS_UTILIZADO", length=500)
    public String getOnibusUtilizado() {
        return this.onibusUtilizado;
    }

    public void setOnibusUtilizado(String onibusUtilizado) {
        this.onibusUtilizado = onibusUtilizado;
    }

    @Column(name="VALOR_PASSAGEM", precision=15, scale=2)
    public Double getValorPassagem() {
        return this.valorPassagem;
    }

    public void setValorPassagem(Double valorPassagem) {
        this.valorPassagem = valorPassagem;
    }

    @Column(name="EMAIL", length=500)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

