/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemProdNFCTeInf;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PreRpsPagtoTranspAgregado;
import com.touchcomp.basementor.model.vo.PreRpsTransporteNFe;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.TipoOperacao;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PRE_RPS_TRANSPORTE")
public class PreRpsTransporte
implements InterfaceVO {
    private Long identificador;
    private Date dataEmissao;
    private UnidadeFatTomPrestRPS unidadeTomPrestRPS;
    private ConjuntoTransportador conjuntoTransportador;
    private Double valorFrete = 0.0;
    private Double quantidadeTotalCarga = 0.0;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private TipoOperacao tipoOperacao;
    private PreRpsTransporteNFe preRpsTransporteNfe;
    private List<ItemProdNFCTeInf> itemProdNFCteInf = new ArrayList<ItemProdNFCTeInf>();
    private Rps rps;
    private PreRpsPagtoTranspAgregado preRpsPagtoTranspAgregado;
    private Pessoa destinatario;

    @Id
    @Column(name="ID_PRE_RPS_TRANSPORTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRE_RPS_TRANSPORTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRE_RPS_TRANSPORTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_TOM_PRES_RPS", foreignKey=@ForeignKey(name="FK_PRERPS_TRANSP_UN_TOMPRES_RPS"))
    public UnidadeFatTomPrestRPS getUnidadeTomPrestRPS() {
        return this.unidadeTomPrestRPS;
    }

    public void setUnidadeTomPrestRPS(UnidadeFatTomPrestRPS unidadeTomPrestRPS) {
        this.unidadeTomPrestRPS = unidadeTomPrestRPS;
    }

    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_PRERPS_TRANSP_CONJ_TRANS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @Column(name="VALOR_FRETE", precision=15, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    @OneToMany(fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="prerps_transp_nfe_item_pr_inf", joinColumns={@JoinColumn(name="id_pre_rps_transp")}, inverseJoinColumns={@JoinColumn(name="id_item_prod_nf_cte_inf")})
    public List<ItemProdNFCTeInf> getItemProdNFCteInf() {
        return this.itemProdNFCteInf;
    }

    public void setItemProdNFCteInf(List<ItemProdNFCTeInf> itemProdNFCteInf) {
        this.itemProdNFCteInf = itemProdNFCteInf;
    }

    @OneToOne(mappedBy="preRpsTransporte", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_PRE_RPS_TRANSP_NFE", foreignKey=@ForeignKey(name="FK_PRE_RPS_TRANSP_PRE_RPS_NFE"))
    public PreRpsTransporteNFe getPreRpsTransporteNfe() {
        return this.preRpsTransporteNfe;
    }

    public void setPreRpsTransporteNfe(PreRpsTransporteNFe preRpsTransporteNfe) {
        this.preRpsTransporteNfe = preRpsTransporteNfe;
    }

    @JoinColumn(name="ID_TIPO_OPERACAO", foreignKey=@ForeignKey(name="FK_PRERPS_TRANSP_TP_OP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoOperacao getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(TipoOperacao tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL_CARGA", precision=15, scale=6)
    public Double getQuantidadeTotalCarga() {
        return this.quantidadeTotalCarga;
    }

    public void setQuantidadeTotalCarga(Double quantidadeTotalCarga) {
        this.quantidadeTotalCarga = quantidadeTotalCarga;
    }

    @JoinColumn(name="ID_RPS", foreignKey=@ForeignKey(name="FK_PRE_RPS_TRANSPORTE_RPS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Rps getRps() {
        return this.rps;
    }

    public void setRps(Rps rps) {
        this.rps = rps;
    }

    @OneToOne(mappedBy="preRps")
    public PreRpsPagtoTranspAgregado getPreRpsPagtoTranspAgregado() {
        return this.preRpsPagtoTranspAgregado;
    }

    public void setPreRpsPagtoTranspAgregado(PreRpsPagtoTranspAgregado preRpsPagtoTranspAgregado) {
        this.preRpsPagtoTranspAgregado = preRpsPagtoTranspAgregado;
    }

    @JoinColumn(name="ID_DESTINATARIO", foreignKey=@ForeignKey(name="FK_PRE_RPS_TRANSPORTE_DESTINATA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getDestinatario() {
        return this.destinatario;
    }

    public void setDestinatario(Pessoa destinatario) {
        this.destinatario = destinatario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

