/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.PreTabelaPrecoBaseTabBaseVinc;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PRE_TABELA_PRECO_BASE")
public class PreTabelaPrecoBase
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Date dataEstimada;
    private String descricao;
    private Double percValorMin = 0.0;
    private Double percValorMax = 0.0;
    private Timestamp dataAtualizacao;
    private List<PreTabelaPrecoBaseProduto> produtos = new ArrayList<PreTabelaPrecoBaseProduto>();
    private List<PreTabelaPrecoBaseTabBaseVinc> tabelasVinculadas = new ArrayList<PreTabelaPrecoBaseTabBaseVinc>();
    private Date dataHoraGerAuto;

    @Id
    @Column(name="ID_PRE_TABELA_PRECO_BASE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRE_TABELA_PRECO_BASE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRE_TABELA_PRECO_BASE_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_ESTIMADA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEstimada() {
        return this.dataEstimada;
    }

    public void setDataEstimada(Date dataEstimada) {
        this.dataEstimada = dataEstimada;
    }

    @Column(name="DESCRICAO", length=250)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="preTabelaPrecoBase", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PreTabelaPrecoBaseProduto> getProdutos() {
        return this.produtos;
    }

    public void setProdutos(List<PreTabelaPrecoBaseProduto> produtos) {
        this.produtos = produtos;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="PERC_VALOR_MIN", precision=15, scale=2)
    public Double getPercValorMin() {
        return this.percValorMin;
    }

    public void setPercValorMin(Double percValorMin) {
        this.percValorMin = percValorMin;
    }

    @Column(nullable=false, name="PERC_VALOR_MAX", precision=15, scale=2)
    public Double getPercValorMax() {
        return this.percValorMax;
    }

    public void setPercValorMax(Double percValorMax) {
        this.percValorMax = percValorMax;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_HORA_GER_AUTO")
    public Date getDataHoraGerAuto() {
        return this.dataHoraGerAuto;
    }

    public void setDataHoraGerAuto(Date dataHoraGerAuto) {
        this.dataHoraGerAuto = dataHoraGerAuto;
    }

    @OneToMany(mappedBy="preTabelaPrecoBase", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<PreTabelaPrecoBaseTabBaseVinc> getTabelasVinculadas() {
        return this.tabelasVinculadas;
    }

    public void setTabelasVinculadas(List<PreTabelaPrecoBaseTabBaseVinc> tabelasVinculadas) {
        this.tabelasVinculadas = tabelasVinculadas;
    }
}

