/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ProdutosSimilaresEmp;
import com.touchcomp.basementor.model.vo.ProdutosSimilaresItens;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PRODUTOS_SIMILARES")
public class ProdutosSimilares
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private List<ProdutosSimilaresItens> produtosSimilaresItens = new ArrayList<ProdutosSimilaresItens>();
    private List<ProdutosSimilaresEmp> produtosSimilaresEmp = new ArrayList<ProdutosSimilaresEmp>();
    private Short precosMargensIguais = 1;
    private Double percMargemMarkup = 0.0;

    @Id
    @Column(nullable=false, unique=true, name="ID_PRODUTOS_SIMILARES")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRODUTOS_SIMILARES")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRODUTOS_SIMILARES_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @OneToMany(mappedBy="produtosSimilares", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ProdutosSimilaresItens> getProdutosSimilaresItens() {
        return this.produtosSimilaresItens;
    }

    public void setProdutosSimilaresItens(List<ProdutosSimilaresItens> produtosSimilaresItens) {
        this.produtosSimilaresItens = produtosSimilaresItens;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PRECOS_MARGENS_IGUAIS")
    public Short getPrecosMargensIguais() {
        return this.precosMargensIguais;
    }

    public void setPrecosMargensIguais(Short precosMargensIguais) {
        this.precosMargensIguais = precosMargensIguais;
    }

    @Column(name="PERC_MARGEM_MARKUP")
    public Double getPercMargemMarkup() {
        return this.percMargemMarkup;
    }

    public void setPercMargemMarkup(Double percMargemMarkup) {
        this.percMargemMarkup = percMargemMarkup;
    }

    @OneToMany(mappedBy="produtosSimilares", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProdutosSimilaresEmp> getProdutosSimilaresEmp() {
        return this.produtosSimilaresEmp;
    }

    public void setProdutosSimilaresEmp(List<ProdutosSimilaresEmp> produtosSimilaresEmp) {
        this.produtosSimilaresEmp = produtosSimilaresEmp;
    }
}

