/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoProjeto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LogStatusProjeto;
import com.touchcomp.basementor.model.vo.ModuloSistema;
import com.touchcomp.basementor.model.vo.MotivoDesistencia;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ProjetoParticipante;
import com.touchcomp.basementor.model.vo.ProjetoRecursos;
import com.touchcomp.basementor.model.vo.ProjetoTarefa;
import com.touchcomp.basementor.model.vo.ProjetoTarefaDependencia;
import com.touchcomp.basementor.model.vo.StatusProjeto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="PROJETO")
public class Projeto
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Pessoa pessoa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;
    private List<ModuloSistema> modulosSistema;
    private Double percentualTotal = 0.0;
    private Date dataInicial;
    private Date dataFinal;
    private String observacao;
    private String observacaoInterna;
    private Short desistenciaProjeto = 0;
    private MotivoDesistencia motivoDesistencia;
    private Date dataDesistencia;
    private String obsDesistencia;
    private Pessoa pessoaResponsavel;
    private ClassificacaoProjeto classificacaoProjeto;
    private List<ProjetoParticipante> participantesProjeto;
    private StatusProjeto statusProjeto;
    private Usuario usuarioUltAlteracao;
    private List<LogStatusProjeto> logsProjeto;
    private List<ProjetoTarefa> tarefas = new ArrayList<ProjetoTarefa>();
    private List<ProjetoRecursos> recursos = new ArrayList<ProjetoRecursos>();
    private List<ProjetoTarefaDependencia> dependencias = new ArrayList<ProjetoTarefaDependencia>();

    public Projeto() {
        this.modulosSistema = new ArrayList<ModuloSistema>();
        this.participantesProjeto = new ArrayList<ProjetoParticipante>();
        this.logsProjeto = new ArrayList<LogStatusProjeto>();
    }

    @Id
    @Column(nullable=false, name="ID_PROJETO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROJETO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_PROJETO_1"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_DACADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROJETO_2"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="projeto_modulo_sis", joinColumns={@JoinColumn(name="id_projeto")}, inverseJoinColumns={@JoinColumn(name="ID_modulo_sistema")})
    public List<ModuloSistema> getModulosSistema() {
        return this.modulosSistema;
    }

    public void setModulosSistema(List<ModuloSistema> modulosSistema) {
        this.modulosSistema = modulosSistema;
    }

    @Column(nullable=false, name="PERCENTUAL_TOTAL", precision=15, scale=2)
    public Double getPercentualTotal() {
        return this.percentualTotal;
    }

    public void setPercentualTotal(Double percentualTotal) {
        this.percentualTotal = percentualTotal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="OBSERVACAO", length=8000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DESISTENCIA_PROJETO")
    public Short getDesistenciaProjeto() {
        return this.desistenciaProjeto;
    }

    public void setDesistenciaProjeto(Short desistenciaProjeto) {
        this.desistenciaProjeto = desistenciaProjeto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_DESISTENCIA", foreignKey=@ForeignKey(name="FK_PROJETO_MOTIVO_D"))
    public MotivoDesistencia getMotivoDesistencia() {
        return this.motivoDesistencia;
    }

    public void setMotivoDesistencia(MotivoDesistencia motivoDesistencia) {
        this.motivoDesistencia = motivoDesistencia;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_DESISTENCIA")
    public Date getDataDesistencia() {
        return this.dataDesistencia;
    }

    public void setDataDesistencia(Date dataDesistencia) {
        this.dataDesistencia = dataDesistencia;
    }

    @Column(name="OBS_DESISTENCIA", length=1000)
    public String getObsDesistencia() {
        return this.obsDesistencia;
    }

    public void setObsDesistencia(String obsDesistencia) {
        this.obsDesistencia = obsDesistencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_PROJETO_PES_RESPONSAVEL"))
    public Pessoa getPessoaResponsavel() {
        return this.pessoaResponsavel;
    }

    public void setPessoaResponsavel(Pessoa pessoaResponsavel) {
        this.pessoaResponsavel = pessoaResponsavel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PROJETO", foreignKey=@ForeignKey(name="FK_PROJETO_CLAS_PROJETO"))
    public ClassificacaoProjeto getClassificacaoProjeto() {
        return this.classificacaoProjeto;
    }

    public void setClassificacaoProjeto(ClassificacaoProjeto classificacaoProjeto) {
        this.classificacaoProjeto = classificacaoProjeto;
    }

    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProjetoParticipante> getParticipantesProjeto() {
        return this.participantesProjeto;
    }

    public void setParticipantesProjeto(List<ProjetoParticipante> participantesProjeto) {
        this.participantesProjeto = participantesProjeto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_PROJETO", foreignKey=@ForeignKey(name="FK_PROJETO_CLAS_STATUS"))
    public StatusProjeto getStatusProjeto() {
        return this.statusProjeto;
    }

    public void setStatusProjeto(StatusProjeto statusProjeto) {
        this.statusProjeto = statusProjeto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_ULT_ALTERACAO", foreignKey=@ForeignKey(name="FK_PROJETO_USU_ALTERACAO"))
    public Usuario getUsuarioUltAlteracao() {
        return this.usuarioUltAlteracao;
    }

    public void setUsuarioUltAlteracao(Usuario usuarioUltAlteracao) {
        this.usuarioUltAlteracao = usuarioUltAlteracao;
    }

    @OneToMany(mappedBy="projeto", cascade={CascadeType.REMOVE})
    @OrderBy(value="dataTermino")
    public List<LogStatusProjeto> getLogsProjeto() {
        return this.logsProjeto;
    }

    public void setLogsProjeto(List<LogStatusProjeto> logsProjeto) {
        this.logsProjeto = logsProjeto;
    }

    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="indice")
    public List<ProjetoTarefa> getTarefas() {
        return this.tarefas;
    }

    public void setTarefas(List<ProjetoTarefa> tarefas) {
        this.tarefas = tarefas;
    }

    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProjetoRecursos> getRecursos() {
        return this.recursos;
    }

    public void setRecursos(List<ProjetoRecursos> recursos) {
        this.recursos = recursos;
    }

    @OneToMany(mappedBy="projeto", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ProjetoTarefaDependencia> getDependencias() {
        return this.dependencias;
    }

    public void setDependencias(List<ProjetoTarefaDependencia> dependencias) {
        this.dependencias = dependencias;
    }

    @Column(name="OBSERVACAO_INTERNA")
    public String getObservacaoInterna() {
        return this.observacaoInterna;
    }

    public void setObservacaoInterna(String observacaoInterna) {
        this.observacaoInterna = observacaoInterna;
    }
}

