/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.Projeto;
import com.touchcomp.basementor.model.vo.ProjetoParticipante;
import com.touchcomp.basementor.model.vo.ProjetoTarefaDep;
import com.touchcomp.basementor.model.vo.ProjetoTarefaHist;
import com.touchcomp.basementor.model.vo.ProjetoTarefaRecurso;
import com.touchcomp.basementor.model.vo.SubprojetoTarefasStat;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;

@Entity
@Table(name="PROJETO_TAREFA")
public class ProjetoTarefa
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_PROJETO_TAREFA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROJETO_TAREFA")
    private Long identificador;
    @Column(name="DESCRICAO")
    private String descricao;
    @Column(name="CODIGO_TAREFA")
    private String codigoTarefa;
    @Column(name="CODIGO_TAREFA_VINCULADA")
    private String codigoTarefaVinculada;
    @Column(name="MARCA")
    private Short marca;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROJETO")
    private Projeto projeto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROJETO_TAREFA_VINCULADA")
    private ProjetoTarefa tarefaVinculada;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRIORIDADE_TAREFA")
    private PrioridadeMarketing prioridadeTarefa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PARTICIPANTE_RESPONSAVEL")
    private ProjetoParticipante participanteResponsavel;
    @Column(name="COD_PARTICIPANTE_RESPONSAVEL")
    private String codParticipanteResponsavel;
    @Column(name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @Column(name="PERCENTUAL_ANDAMENTO")
    private Double percentualAndamento = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_TAREFA")
    private SubprojetoTarefasStat statusTarefa;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_INICIAL")
    private Date dataInicial;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FINAL")
    private Date dataFinal;
    @Column(name="DIAS_EXECUCAO")
    private Integer diasExecucao = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_AGENDAMENTO")
    private Date dataAgendamento;
    @Column(name="OBSERVACAO")
    private String observacao;
    @Column(name="INDICE")
    private Integer indice = 0;
    @OneToMany(mappedBy="projetoTarefa", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjetoTarefaRecurso> projetoTarefaRecurso = new ArrayList<ProjetoTarefaRecurso>();
    @OneToMany(mappedBy="projetoTarefa", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjetoTarefaHist> historicoTarefa;
    @OneToMany(mappedBy="projetoTarefa", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjetoTarefaDep> tarefasDependentes = new ArrayList<ProjetoTarefaDep>();

    public ProjetoTarefa() {
        this.historicoTarefa = new ArrayList<ProjetoTarefaHist>();
        this.marca = EnumConstSinteticoAnalitico.SINTETICO.getValue();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} ({2})", (Object[])new Object[]{this.getCodigoTarefa(), this.getDescricao(), this.getProjeto()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getCodigoTarefa() {
        return this.codigoTarefa;
    }

    @Generated
    public String getCodigoTarefaVinculada() {
        return this.codigoTarefaVinculada;
    }

    @Generated
    public Short getMarca() {
        return this.marca;
    }

    @Generated
    public Projeto getProjeto() {
        return this.projeto;
    }

    @Generated
    public ProjetoTarefa getTarefaVinculada() {
        return this.tarefaVinculada;
    }

    @Generated
    public PrioridadeMarketing getPrioridadeTarefa() {
        return this.prioridadeTarefa;
    }

    @Generated
    public ProjetoParticipante getParticipanteResponsavel() {
        return this.participanteResponsavel;
    }

    @Generated
    public String getCodParticipanteResponsavel() {
        return this.codParticipanteResponsavel;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Double getPercentualAndamento() {
        return this.percentualAndamento;
    }

    @Generated
    public SubprojetoTarefasStat getStatusTarefa() {
        return this.statusTarefa;
    }

    @Generated
    public Date getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public Date getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public Integer getDiasExecucao() {
        return this.diasExecucao;
    }

    @Generated
    public Date getDataAgendamento() {
        return this.dataAgendamento;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Integer getIndice() {
        return this.indice;
    }

    @Generated
    public List<ProjetoTarefaRecurso> getProjetoTarefaRecurso() {
        return this.projetoTarefaRecurso;
    }

    @Generated
    public List<ProjetoTarefaHist> getHistoricoTarefa() {
        return this.historicoTarefa;
    }

    @Generated
    public List<ProjetoTarefaDep> getTarefasDependentes() {
        return this.tarefasDependentes;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCodigoTarefa(String codigoTarefa) {
        this.codigoTarefa = codigoTarefa;
    }

    @Generated
    public void setCodigoTarefaVinculada(String codigoTarefaVinculada) {
        this.codigoTarefaVinculada = codigoTarefaVinculada;
    }

    @Generated
    public void setMarca(Short marca) {
        this.marca = marca;
    }

    @Generated
    public void setProjeto(Projeto projeto) {
        this.projeto = projeto;
    }

    @Generated
    public void setTarefaVinculada(ProjetoTarefa tarefaVinculada) {
        this.tarefaVinculada = tarefaVinculada;
    }

    @Generated
    public void setPrioridadeTarefa(PrioridadeMarketing prioridadeTarefa) {
        this.prioridadeTarefa = prioridadeTarefa;
    }

    @Generated
    public void setParticipanteResponsavel(ProjetoParticipante participanteResponsavel) {
        this.participanteResponsavel = participanteResponsavel;
    }

    @Generated
    public void setCodParticipanteResponsavel(String codParticipanteResponsavel) {
        this.codParticipanteResponsavel = codParticipanteResponsavel;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setPercentualAndamento(Double percentualAndamento) {
        this.percentualAndamento = percentualAndamento;
    }

    @Generated
    public void setStatusTarefa(SubprojetoTarefasStat statusTarefa) {
        this.statusTarefa = statusTarefa;
    }

    @Generated
    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setDiasExecucao(Integer diasExecucao) {
        this.diasExecucao = diasExecucao;
    }

    @Generated
    public void setDataAgendamento(Date dataAgendamento) {
        this.dataAgendamento = dataAgendamento;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setIndice(Integer indice) {
        this.indice = indice;
    }

    @Generated
    public void setProjetoTarefaRecurso(List<ProjetoTarefaRecurso> projetoTarefaRecurso) {
        this.projetoTarefaRecurso = projetoTarefaRecurso;
    }

    @Generated
    public void setHistoricoTarefa(List<ProjetoTarefaHist> historicoTarefa) {
        this.historicoTarefa = historicoTarefa;
    }

    @Generated
    public void setTarefasDependentes(List<ProjetoTarefaDep> tarefasDependentes) {
        this.tarefasDependentes = tarefasDependentes;
    }
}

